package com.bizunited.platform.mars.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 节点模板的处理源——服务源信息
 * @Author yinwenjie
 * @Date  2020-06-20
 */
@Entity
@Table(name = "engine_rule_source_servicable")
@ApiModel(value = "RuleSourceServicableEntity" , description="规则定义节点的处理源——服务源")
@org.hibernate.annotations.Table(appliesTo = "engine_rule_source_servicable" , comment = "规则定义节点的处理源——服务源信")
public class RuleSourceServicableEntity  extends UuidEntity {
  /**
   * 
   */
  private static final long serialVersionUID = -1478018741105342470L;
  /**
   * 完整的服务源方法名
   */
  @ApiModelProperty(name = "servicableMethod", value = "完整的服务源方法名")
  @Column(name = "servicable_method" , length = 256, nullable = false , columnDefinition = "varchar(256) COMMENT '完整的服务源方法名'")
  @SaturnColumn(description = "完整的服务源方法名")
  private String servicableMethod;
  
  public String getServicableMethod() {
    return servicableMethod;
  }
  public void setServicableMethod(String servicableMethod) {
    this.servicableMethod = servicableMethod;
  }
}
