package com.bizunited.platform.mars.repository;
import com.bizunited.platform.mars.entity.RuleTemplateParamsEntity;
import java.lang.String;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * RuleTemplateParamsEntity业务模型的数据库方法支持
 * @author saturn
 */
@Repository("_RuleTemplateParamsEntityRepository")
public interface RuleTemplateParamsEntityRepository
    extends
      JpaRepository<RuleTemplateParamsEntity, String>
      ,JpaSpecificationExecutor<RuleTemplateParamsEntity>
  {
  /**
   * 按照对应的节点模板信息进行详情查询（包括关联信息）
   * @param templateNode 对应的节点模板信息
   * */
  @Query("select ruleTemplateParamsEntity from RuleTemplateParamsEntity ruleTemplateParamsEntity "
      + " left join fetch ruleTemplateParamsEntity.templateNode ruleTemplateParamsEntity_templateNode "
       + " where ruleTemplateParamsEntity_templateNode.id = :id")
  public Set<RuleTemplateParamsEntity> findDetailsByTemplateNode(@Param("id") String id);

  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   * */
  @Query("select ruleTemplateParamsEntity from RuleTemplateParamsEntity ruleTemplateParamsEntity "
      + " left join fetch ruleTemplateParamsEntity.templateNode ruleTemplateParamsEntity_templateNode "
      + " where ruleTemplateParamsEntity.id=:id ")
  public RuleTemplateParamsEntity findDetailsById(@Param("id") String id);
  
  /**
   * 按照指定的节点模板id编号，删除相关的所有出参和入参信息
   * @param templateNodeId 指定的节点模板id
   */
  @Modifying
  @Query(value="delete from engine_rule_template_params where engine_rule_template_params.node_template_id = :templateNodeId " , nativeQuery = true)
  public void deleteByTemplateNode(@Param("templateNodeId") String templateNodeId);
}