package com.bizunited.platform.mars.entity;

import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import org.hibernate.annotations.Where;

import com.bizunited.platform.core.entity.UuidOpEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 规则节点模板，规则节点模板可以是依据相关注解生成，也可以是技术人员/业务人员在页面上直接创建</br>
 * 根据工作位置不一样，规则节点可分为：1:判定规则、2、逻辑规则、3、锁规则，4、开始规则、5、结束规则、6、异常规则</br>
 * 详情可参见文档介绍 
 * @Author yinwenjie 
 * @Date  2020-06-21 
 */
@Entity
@Table(name = "engine_rule_template_node")
@ApiModel(value = "RuleTemplateNodeEntity" , description="规则节点模板")
@org.hibernate.annotations.Table(appliesTo = "engine_rule_template_node" , comment = "规则节点模板")
public class RuleTemplateNodeEntity extends UuidOpEntity {
  /**
   * 
   */
  private static final long serialVersionUID = 4810559224348086431L;
  /**
   * 节点模板业务编号
   */
  @ApiModelProperty(name = "code", value = "节点模板业务编号")
  @Column(name = "code" , length = 128 , nullable = false  , unique = true, columnDefinition = "varchar(128) COMMENT '节点模板业务编号'")
  @SaturnColumn(description = "节点模板业务编号" , updatable = false)
  private String code;
  /**
   * 节点模板业务名称（中文）
   */
  @ApiModelProperty(name = "name", value = " 节点模板业务名称（中文）")
  @Column(name = "name" , length = 128 , nullable = false , columnDefinition = "varchar(128) COMMENT '节点模板业务名称（中文）'")
  @SaturnColumn(description = "节点模板业务名称（中文）")
  private String name;
  /**
   * 节点可用状态， 1：正常，其它值（0）不正常</br>
   * 如果节点不可用不会影响已有的设置规则，只是新规则中不能再使用了
   */
  @ApiModelProperty(name="nodeStatus" , value="节点可用状态， 1：正常，其它值（0）不正常" , required=false)
  @Column(name = "c_status", nullable = false, columnDefinition = "int(11) COMMENT '节点可用状态， 1：正常，其它值（0）不正常'")
  @SaturnColumn(description="节点可用状态")
  private Integer nodeStatus = 1;
  /**
   * 节点模板类型
   * 1:判定组件、2、逻辑组件、3、锁组件，4、开始组件、5、结束组件、6、异常组件
   */
  @ApiModelProperty(name = "type", value = "节点模板类型")
  @Column(name = "type" , nullable = false , columnDefinition = "int(11)  COMMENT '节点模板类型'")
  @SaturnColumn(description = "节点模板类型" , updatable = false)
  private Integer type;
  /**
   * 节点模板处理器类型：1、服务源；2、数据视图（聚集）、3、后台脚本；4、数据视图（结果集）；5、全动态后台脚本
   */
  @ApiModelProperty(name = "source_type", value = "节点模板工作逻辑类型")
  @Column(name = "source_type" , nullable = true , columnDefinition = "int(11)  COMMENT '节点模板工作逻辑类型'")
  @SaturnColumn(description = "节点模板工作逻辑类型" , updatable = false)
  private Integer sourceType;
  /**
   * 运行时规则处理器完整类名（运行时上下文一定实现了Ruleable接口）
   */
  @ApiModelProperty(name = "ruleable_class", value = "运行时规则处理器完整类名")
  @Column(name = "ruleable_class" , length = 256 , nullable = false, columnDefinition = "varchar(256) COMMENT '运行时规则处理器完整类名'")
  @SaturnColumn(description = "运行时规则处理器完整类名")
  private String ruleableClass;
  /**
   * 入参信息(可能没有，也可能有多个)
   */
  @SaturnColumn(description = "入参信息")
  @Where(clause = "type=1")
  @ApiModelProperty("入参信息")
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "templateNode")
  private Set<RuleTemplateParamsEntity> inputs;
  /**
   * 出参信息(可能没有，也可能有多个)
   */
  @SaturnColumn(description = "出参信息")
  @Where(clause = "type=2")
  @ApiModelProperty("出参信息")
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "templateNode")
  private Set<RuleTemplateParamsEntity> outputs;
  /**
   * 节点定义所属的分组（可以不属于任何分组）
   */
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="group_id" , nullable=true, columnDefinition = "varchar(255) COMMENT '节点定义所属的分组'")
  @SaturnColumn(description="节点定义所属的分组")
  private RuleTemplateGroupEntity templateGroup;
  /**
   * 可能对应的服务源，当sourceType == 1时使用
   */
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="source_servicable_id" , nullable=true, columnDefinition = "varchar(255) COMMENT '可能对应的服务源，当sourceType == 1时使用'")
  @SaturnColumn(description="可能对应的服务源，当sourceType == 1时使用")
  private RuleSourceServicableEntity sourceServicable;
  /**
   * 可能对应的数据视图（聚集函数），当sourceType == 2时使用
   */
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="source_aggregate_data_view_id" , nullable=true, columnDefinition = "varchar(255) COMMENT '可能对应的数据视图（聚集函数），当sourceType == 2时使用'")
  @SaturnColumn(description="可能对应的数据视图（聚集函数），当sourceType == 2时使用")
  private RuleSourceAggregateDataViewEntity sourceAggregateDataView;
  /**
   * 可能对应的groovy动态脚本，当sourceType == 3时使用
   */
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="source_script_id" , nullable=true, columnDefinition = "varchar(255) COMMENT '可能对应的groovy动态脚本，当sourceType == 3时使用'")
  @SaturnColumn(description="可能对应的groovy动态脚本，当sourceType == 3时使用")
  private RuleSourceScriptEntity sourceScript;
  
  public String getCode() {
    return code;
  }
  public void setCode(String code) {
    this.code = code;
  }
  public String getName() {
    return name;
  }
  public void setName(String name) {
    this.name = name;
  }
  public Integer getNodeStatus() {
    return nodeStatus;
  }
  public void setNodeStatus(Integer nodeStatus) {
    this.nodeStatus = nodeStatus;
  }
  public Set<RuleTemplateParamsEntity> getInputs() {
    return inputs;
  }
  public void setInputs(Set<RuleTemplateParamsEntity> inputs) {
    this.inputs = inputs;
  }
  public Set<RuleTemplateParamsEntity> getOutputs() {
    return outputs;
  }
  public void setOutputs(Set<RuleTemplateParamsEntity> outputs) {
    this.outputs = outputs;
  }
  public String getRuleableClass() {
    return ruleableClass;
  }
  public void setRuleableClass(String ruleableClass) {
    this.ruleableClass = ruleableClass;
  }
  public Integer getType() {
    return type;
  }
  public void setType(Integer type) {
    this.type = type;
  }
  public Integer getSourceType() {
    return sourceType;
  }
  public void setSourceType(Integer sourceType) {
    this.sourceType = sourceType;
  }
  public RuleTemplateGroupEntity getTemplateGroup() {
    return templateGroup;
  }
  public void setTemplateGroup(RuleTemplateGroupEntity templateGroup) {
    this.templateGroup = templateGroup;
  }
  public RuleSourceServicableEntity getSourceServicable() {
    return sourceServicable;
  }
  public void setSourceServicable(RuleSourceServicableEntity sourceServicable) {
    this.sourceServicable = sourceServicable;
  }
  public RuleSourceAggregateDataViewEntity getSourceAggregateDataView() {
    return sourceAggregateDataView;
  }
  public void setSourceAggregateDataView(RuleSourceAggregateDataViewEntity sourceAggregateDataView) {
    this.sourceAggregateDataView = sourceAggregateDataView;
  }
  public RuleSourceScriptEntity getSourceScript() {
    return sourceScript;
  }
  public void setSourceScript(RuleSourceScriptEntity sourceScript) {
    this.sourceScript = sourceScript;
  }
}