package com.bizunited.platform.mars.service;

import com.bizunited.platform.mars.entity.RuleDefinitionEntity;

/**
 * 规则定义的变化监听器
 * @author yinwenjie
 */
public interface RuleDefinitionListener {
  /**
   * 当规则定义变化时（创建时），该监听器将被触发
   * @param ruleDefinition
   */
  public void onDefinitionCreate(RuleDefinitionEntity ruleDefinition);
  
  /**
   * 当规则定义变化时（属性修改时），该监听器将被触发
   * @param ruleDefinition
   */
  public void onDefinitionModify(RuleDefinitionEntity ruleDefinition);
  
  /**
   * 当规则定义变化时（删除时），该监听器将被触发
   * @param ruleDefinition
   */
  public void onDefinitionDelete(RuleDefinitionEntity ruleDefinition);
}