package com.bizunited.platform.mars.repository.internal;

import java.util.List;

import org.springframework.stereotype.Repository;

import com.bizunited.platform.mars.entity.RuleTemplateNodeEntity;

/**
 * 基于节点模板的自定义查询方法
 * @author yinwenjie
 */
@Repository("RuleTemplateNodeEntityRepositoryCustom")
public interface RuleTemplateNodeEntityRepositoryCustom {
  /**
   * 按照模板节点分组，节点状态，节点模板类型查询符合要求的模板节点的信息（只包括基本信息）,返回信息将按照创建时间进行倒叙排列</br>
   * 注意，其中的三个参数都不是必须填写的
   * @param templateGroup 指定的模板分组id
   * @param nodeStatus 节点模板的状态条件(可以不传入)，如果不传就不再参考该条件
   * @param type  1:判定组件、2、逻辑组件、3、锁组件，4、开始组件、5、结束组件、
   */
  public List<RuleTemplateNodeEntity> findByTemplateGroupAndStatusAndType(String templateGroup , Integer nodeStatus , Integer type);
}
