/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.mars.service.internal;

import com.bizunited.platform.mars.entity.RuleSourceServicableEntity;
import com.bizunited.platform.mars.repository.RuleSourceServicableEntityRepository;
import com.bizunited.platform.mars.service.RuleSourceServicableEntityService;
import java.util.Optional;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="RuleSourceServicableEntityServiceImpl")
public class RuleSourceServicableEntityServiceImpl
implements RuleSourceServicableEntityService {
    @Autowired
    private RuleSourceServicableEntityRepository ruleSourceServicableEntityRepository;

    @Override
    @Transactional
    public RuleSourceServicableEntity create(RuleSourceServicableEntity ruleSourceServicableEntity) {
        RuleSourceServicableEntity current = this.createForm(ruleSourceServicableEntity);
        return current;
    }

    @Override
    @Transactional
    public RuleSourceServicableEntity createForm(RuleSourceServicableEntity ruleSourceServicableEntity) {
        this.createValidation(ruleSourceServicableEntity);
        this.ruleSourceServicableEntityRepository.save((Object)ruleSourceServicableEntity);
        return ruleSourceServicableEntity;
    }

    private void createValidation(RuleSourceServicableEntity ruleSourceServicableEntity) {
        Validate.notNull((Object)((Object)ruleSourceServicableEntity), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)ruleSourceServicableEntity.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        ruleSourceServicableEntity.setId(null);
        String servicableMethod = ruleSourceServicableEntity.getServicableMethod();
        Validate.notBlank((CharSequence)servicableMethod, (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5b8c\u6574\u7684\u670d\u52a1\u6e90\u65b9\u6cd5\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((servicableMethod == null || servicableMethod.length() < 256 ? 1 : 0) != 0, (String)"\u5b8c\u6574\u7684\u670d\u52a1\u6e90\u65b9\u6cd5\u540d,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(256)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        RuleSourceServicableEntity currentRuleSourceServicableEntity = this.findByServicableMethod(servicableMethod);
        Validate.isTrue((currentRuleSourceServicableEntity == null ? 1 : 0) != 0, (String)"\u5b8c\u6574\u7684\u670d\u52a1\u6e90\u65b9\u6cd5\u540d\u5df2\u5b58\u5728,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public RuleSourceServicableEntity update(RuleSourceServicableEntity ruleSourceServicableEntity) {
        RuleSourceServicableEntity current = this.updateForm(ruleSourceServicableEntity);
        return current;
    }

    @Override
    @Transactional
    public RuleSourceServicableEntity updateForm(RuleSourceServicableEntity ruleSourceServicableEntity) {
        this.updateValidation(ruleSourceServicableEntity);
        String currentId = ruleSourceServicableEntity.getId();
        Optional op_currentRuleSourceServicableEntity = this.ruleSourceServicableEntityRepository.findById(currentId);
        RuleSourceServicableEntity currentRuleSourceServicableEntity = op_currentRuleSourceServicableEntity.orElse(null);
        currentRuleSourceServicableEntity = (RuleSourceServicableEntity)((Object)Validate.notNull((Object)((Object)currentRuleSourceServicableEntity), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]));
        currentRuleSourceServicableEntity.setServicableMethod(ruleSourceServicableEntity.getServicableMethod());
        this.ruleSourceServicableEntityRepository.saveAndFlush((Object)currentRuleSourceServicableEntity);
        return currentRuleSourceServicableEntity;
    }

    private void updateValidation(RuleSourceServicableEntity ruleSourceServicableEntity) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)ruleSourceServicableEntity.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)ruleSourceServicableEntity.getServicableMethod(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5b8c\u6574\u7684\u670d\u52a1\u6e90\u65b9\u6cd5\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        RuleSourceServicableEntity currentForServicableMethod = this.findByServicableMethod(ruleSourceServicableEntity.getServicableMethod());
        Validate.isTrue((currentForServicableMethod == null || StringUtils.equals((CharSequence)currentForServicableMethod.getId(), (CharSequence)ruleSourceServicableEntity.getId()) ? 1 : 0) != 0, (String)"\u5b8c\u6574\u7684\u670d\u52a1\u6e90\u65b9\u6cd5\u540d\u5df2\u5b58\u5728,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.isTrue((ruleSourceServicableEntity.getServicableMethod() == null || ruleSourceServicableEntity.getServicableMethod().length() < 256 ? 1 : 0) != 0, (String)"\u5b8c\u6574\u7684\u670d\u52a1\u6e90\u65b9\u6cd5\u540d,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(256)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    public RuleSourceServicableEntity findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.ruleSourceServicableEntityRepository.findDetailsById(id);
    }

    @Override
    public RuleSourceServicableEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.ruleSourceServicableEntityRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        RuleSourceServicableEntity current = this.findById(id);
        if (current != null) {
            this.ruleSourceServicableEntityRepository.delete((Object)current);
        }
    }

    @Override
    public RuleSourceServicableEntity findByServicableMethod(String servicableMethod) {
        if (StringUtils.isBlank((CharSequence)servicableMethod)) {
            return null;
        }
        return this.ruleSourceServicableEntityRepository.findByServicableMethod(servicableMethod);
    }
}

