package com.bizunited.platform.mars.service.internal;

import org.apache.commons.lang3.Validate;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

/**
 * mars服务层，为了减少代码重复度，而在mars服务层范围内使用的父级类。
 * @author yinwenjie
 */
class AbstractMarsSaveableService {
  /**
   * 该方法可以获取当前作为创建者的操作信息
   * @return
   */
  protected String findCreator() {
    SecurityContext securityContext = SecurityContextHolder.getContext();
    Validate.notNull(securityContext, "未发现任何创建者权限信息!!");
    Authentication authentication = securityContext.getAuthentication();
    Validate.notNull(authentication, "未发现任何创建者登录信息!!");
    String account = authentication.getName();
    Validate.notBlank(account, "未获取到创建者登录账号！");
    return account;
  }
  /**
   * 该方法可以获取当前作为修改者的操作信息
   * @return
   */
  protected String findModifyor() {
    SecurityContext securityContext = SecurityContextHolder.getContext();
    Validate.notNull(securityContext, "未发现任何修改则权限信息!!");
    Authentication authentication = securityContext.getAuthentication();
    Validate.notNull(authentication, "未发现任何修改者登录信息!!");
    String account = authentication.getName();
    Validate.notBlank(account, "未获取到修改者登录账号！");
    return account;
  }
}
