package com.bizunited.platform.mars.entity;

import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import org.hibernate.annotations.Where;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 规则定义节点
 * 根据工作位置不一样，节点定义可分为：1:判定规则、2、逻辑规则、3、锁规则，4、开始规则、5、结束规则、6、异常规则</br>
 * 详情可参见文档介绍 
 * @Author yinwenjie 
 * @Date  2020-06-20 
 */
@Entity
@Table(name = "engine_rule_nodes")
@ApiModel(value = "RuleNodeEntity" , description="规则定义节点")
@org.hibernate.annotations.Table(appliesTo = "engine_rule_nodes" , comment = "规则定义节点")
public class RuleNodeEntity extends UuidEntity {
  /**
   * 
   */
  private static final long serialVersionUID = 3218912718719020074L;
  /**
   * 节点定义业务编号
   */
  @ApiModelProperty(name = "code", value = "节点定义业务编号")
  @Column(name = "code" , length = 128 , nullable = false  , unique = true, columnDefinition = "varchar(128) COMMENT '节点定义业务编号'")
  @SaturnColumn(description = "节点定义业务编号" , updatable = false)
  private String code;
  /**
   * 该节点定义使用的节点模板，这个必须要，例如【该人员近两月销售额】，就是一个节点模板
   */
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="template_node_id" , nullable=false, columnDefinition = "varchar(255) COMMENT '该节点定义使用的节点模板'")
  @SaturnColumn(description="该节点定义使用的节点模板")
  private RuleTemplateNodeEntity templateNode;
  /**
   * 节点定义所属的规则定义
   */
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="definition_id" , nullable=false, columnDefinition = "varchar(255) COMMENT '规则工作节点所属的规则模板'")
  @SaturnColumn(description="规则工作节点所属的规则模板")
  private RuleDefinitionEntity definition;
  /**
   * 节点定义类型
   * 1:判定组件、2、逻辑组件、3、锁组件，4、开始组件、5、结束组件、6、异常组件
   */
  @ApiModelProperty(name = "type", value = "节点定义类型")
  @Column(name = "type" , nullable = false , columnDefinition = "int(11)  COMMENT '节点定义类型'")
  @SaturnColumn(description = "节点定义类型" , updatable = false)
  private Integer type;
  /**
   * 只有逻辑组件（节点）一定需要处理源，其余类型的节点组件不一定需要</br>
   * 节点定义工作逻辑类型：
   * 1、服务源；2、数据视图（聚集）、3、后台脚本；4、数据权限；5、全动态脚本
   */
  @ApiModelProperty(name = "source_type", value = "节点定义工作逻辑类型")
  @Column(name = "source_type" , nullable = true , columnDefinition = "int(11)  COMMENT '节点定义工作逻辑类型'")
  @SaturnColumn(description = "节点定义工作逻辑类型" , updatable = false)
  private Integer sourceType;
  /**
   * 入参信息(可能没有，也可能有多个)
   */
  @SaturnColumn(description = "入参信息")
  @Where(clause = "type=1")
  @ApiModelProperty("入参信息")
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "node")
  private Set<RuleNodeParamsEntity> inputs;
  /**
   * 出参信息(可能没有，也可能有多个)
   */
  @SaturnColumn(description = "出参信息")
  @Where(clause = "type=2")
  @ApiModelProperty("出参信息")
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "node")
  private Set<RuleNodeParamsEntity> outputs;
  /**
   * 该处理节点的连线信息（以连线的起始节点为标准）
   */
  @SaturnColumn(description = "该处理节点的连线信息")
  @ApiModelProperty("该处理节点的连线信息")
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "fromNode")
  private Set<RuleNodeNextsEntity> nexts;
  
  public Set<RuleNodeNextsEntity> getNexts() {
    return nexts;
  }
  public void setNexts(Set<RuleNodeNextsEntity> nexts) {
    this.nexts = nexts;
  }
  public RuleTemplateNodeEntity getTemplateNode() {
    return templateNode;
  }
  public void setTemplateNode(RuleTemplateNodeEntity templateNode) {
    this.templateNode = templateNode;
  }
  public RuleDefinitionEntity getDefinition() {
    return definition;
  }
  public void setDefinition(RuleDefinitionEntity definition) {
    this.definition = definition;
  }
  public Integer getType() {
    return type;
  }
  public void setType(Integer type) {
    this.type = type;
  }
  public Integer getSourceType() {
    return sourceType;
  }
  public void setSourceType(Integer sourceType) {
    this.sourceType = sourceType;
  }
  public String getCode() {
    return code;
  }
  public void setCode(String code) {
    this.code = code;
  }
  public Set<RuleNodeParamsEntity> getInputs() {
    return inputs;
  }
  public void setInputs(Set<RuleNodeParamsEntity> inputs) {
    this.inputs = inputs;
  }
  public Set<RuleNodeParamsEntity> getOutputs() {
    return outputs;
  }
  public void setOutputs(Set<RuleNodeParamsEntity> outputs) {
    this.outputs = outputs;
  }
}