package com.bizunited.platform.mars.entity;

import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import com.bizunited.platform.core.entity.UuidOpEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 规则定义
 * @Author yinwenjie
 * @Date  2020-06-20
 */
@Entity
@Table(name = "engine_rule_definition" , indexes = {@Index(columnList = "code , c_version" , unique = true) , 
                                                  @Index(columnList = "template_filename , template_relativepath" , unique = true)})
@ApiModel(value = "RuleDefinitionEntity" , description="规则定义")
@org.hibernate.annotations.Table(appliesTo = "engine_rule_definition" , comment = "规则定义")
public class RuleDefinitionEntity extends UuidOpEntity {
  /**
   * 
   */
  private static final long serialVersionUID = 4810559224348086431L;
  /**
   * 规则定义业务编号
   */
  @ApiModelProperty(name = "code", value = "规则定义业务编号")
  @Column(name = "code" , length = 128 , nullable = false , columnDefinition = "varchar(128) COMMENT '规则定义业务编号'")
  @SaturnColumn(description = "规则定义业务编号")
  private String code;
  /**
   * 规则定义版本
   */
  @ApiModelProperty(name = "cverion", value = "规则定义版本")
  @Column(name = "c_version" , length = 128 , nullable = false , columnDefinition = "varchar(128) COMMENT '规则定义版本'")
  @SaturnColumn(description = "规则定义版本" , updatable = false)
  private String cverion;
  /**
   * 规则定义用途说明
   */
  @ApiModelProperty(name = "desc", value = "规则定义用途说明")
  @Column(name = "c_desc" , length = 512 , nullable = false , columnDefinition = "varchar(512) COMMENT '规则定义用途说明'")
  @SaturnColumn(description = "规则定义用途说明")
  private String desc;
  /**
   * 规则定义前端图形化展示结构描述文件的文件名
   */
  @ApiModelProperty(name = "templateFilename", value = "前端图形化展示结构描述文件的文件名")
  @Column(name = "template_filename" , length = 256 , nullable = false , columnDefinition = "varchar(256) COMMENT '前端图形化展示结构描述文件的文件名'")
  @SaturnColumn(description = "规则定义用途说明")
  private String templateFilename;
  /**
   * 规则定义前端图形化展示结构描述文件的相对路径
   */
  @ApiModelProperty(name = "templateRelativepath", value = "前端图形化展示结构描述文件的相对路径")
  @Column(name = "template_relativepath" , length = 256 , nullable = false , columnDefinition = "varchar(256) COMMENT '前端图形化展示结构描述文件的相对路径'")
  @SaturnColumn(description = "前端图形化展示结构描述文件的相对路径")
  private String templateRelativepath;
  /**
   * 最终返回值所在的规则执行上下文的那可以key值，可以不填写
   */
  @ApiModelProperty(name = "returnParam", value = "前端图形化展示结构描述文件的相对路径")
  @Column(name = "return_param" , length = 64 , nullable = true , columnDefinition = "varchar(64) COMMENT '最终返回值所在的规则执行上下文的那可以key值'")
  @SaturnColumn(description = "最终返回值所在的规则执行上下文的那可以key值")
  private String returnParam;
  /**
   * 该定义已被设定的各个规则节点信息
   */
  @SaturnColumn(description = "已被设定的各个规则节点")
  @ApiModelProperty("已被设定的各个规则节点")
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "definition")
  private Set<RuleNodeEntity> nodes;

  /**
   * 当前项目名工程名
   */
  @ApiModelProperty("项目名")
  @Column(name="project_name", nullable = false, columnDefinition = "varchar(255) default '' comment '工程名'")
  @SaturnColumn(description = "工程名")
  private String projectName;

  public String getProjectName() {
    return projectName;
  }

  public void setProjectName(String projectName) {
    this.projectName = projectName;
  }
  
  public String getCode() {
    return code;
  }
  public void setCode(String code) {
    this.code = code;
  }
  public String getCverion() {
    return cverion;
  }
  public void setCverion(String cverion) {
    this.cverion = cverion;
  }
  public String getDesc() {
    return desc;
  }
  public void setDesc(String desc) {
    this.desc = desc;
  }
  public Set<RuleNodeEntity> getNodes() {
    return nodes;
  }
  public void setNodes(Set<RuleNodeEntity> nodes) {
    this.nodes = nodes;
  }
  public String getTemplateFilename() {
    return templateFilename;
  }
  public void setTemplateFilename(String templateFilename) {
    this.templateFilename = templateFilename;
  }
  public String getTemplateRelativepath() {
    return templateRelativepath;
  }
  public void setTemplateRelativepath(String templateRelativepath) {
    this.templateRelativepath = templateRelativepath;
  }
  public String getReturnParam() {
    return returnParam;
  }
  public void setReturnParam(String returnParam) {
    this.returnParam = returnParam;
  }
}
