package com.bizunited.platform.mars.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 节点定义的出参或入参信息说明
 * @Author yinwenjie
 * @Date  2020-06-20
 */
@Entity
@Table(name = "engine_rule_node_params")
@ApiModel(value = "RuleTemplateParamsEntity" , description="节点定义的出参或入参信息说明")
@org.hibernate.annotations.Table(appliesTo = "engine_rule_node_params" , comment = "节点定义的出参或入参信息说明")
public class RuleNodeParamsEntity extends UuidEntity {
  /**
   * 
   */
  private static final long serialVersionUID = 3218912718719020074L;
  /**
   * 对应的节点定义信息
   */
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="node_id" , nullable=false, columnDefinition = "varchar(255) COMMENT '对应的节点定义信息'")
  @SaturnColumn(description="对应的节点定义信息")
  private RuleNodeEntity node;
  /**
   * 出参还是入参：1、入参；2、出参
   */
  @ApiModelProperty(name = "type", value = "出参还是入参：1、入参；2、出参")
  @Column(name = "type" , nullable = false , columnDefinition = "int(11)  COMMENT '出参还是入参：1、入参；2、出参'")
  @SaturnColumn(description = "出参还是入参：1、入参；2、出参")
  private Integer type;
  /**
   * 参数中文说明
   */
  @ApiModelProperty(name = "paramDesc", value = "参数中文说明")
  @Column(name = "param_desc" , length = 512 , nullable = false , columnDefinition = "varchar(512)  COMMENT '参数中文说明'")
  @SaturnColumn(description = "参数中文说明")
  private String paramDesc;
  /**
   * 模板参数名（符合变量命名格式）
   */
  @ApiModelProperty(name = "templateParamName", value = "模板参数名（符合变量命名格式）")
  @Column(name = "template_param_name" , length = 128 , nullable = false , columnDefinition = "varchar(128)  COMMENT '模板参数名（符合变量命名格式）'")
  @SaturnColumn(description = "模板参数名（符合变量命名格式）")
  private String templateParamName;
  /**
   * 上下文中的参数名（符合变量命名格式）
   * 入参固定值和上下文绑定之间只能选择一种（优先选择前者）
   */
  @ApiModelProperty(name = "contextParamName", value = "上下文中的参数名（符合变量命名格式）")
  @Column(name = "context_param_name" , length = 128 , nullable = true , columnDefinition = "varchar(128)  COMMENT '上下文中的参数名（符合变量命名格式）'")
  @SaturnColumn(description = "上下文中的参数名（符合变量命名格式）")
  private String contextParamName;
  /**
   * 入参固定值，
   * 入参固定值永远优先规则执行时上线文中的参数值。
   * 且入参固定值和上下文绑定之间只能选择一种（优先选择这种）
   */
  @Column(name = "fixed_value" , length = 1024 , nullable = true , columnDefinition = "varchar(1024)  COMMENT '入参固定值永远优先规则执行时上线文中的参数值'")
  @SaturnColumn(description = "入参固定值永远优先规则执行时上线文中的参数值")
  private String fixedValue;
  /**
   * 参数类型（八大类型、字符串、Object、Collections）：</br>
   * chart、long、int、float、boolean、double、short、byte、string、object、collection
   */
  @ApiModelProperty(name = "paramType", value = "参数类型（八大类型、Object、Collections？）")
  @Column(name = "param_type" , nullable = false , columnDefinition = "varchar(128)  COMMENT '参数类型'")
  @SaturnColumn(description = "参数类型")
  private String paramType;
  /**
   * 参数是否可为null。如果不能为null，则会进行判定
   */
  @ApiModelProperty(name = "nullable", value = "参数是否可为null")
  @SaturnColumn(description = "参数是否可为null")
  @Column(name = "nullable", nullable = false, columnDefinition = "bit(1) comment '参数是否可为null'")
  private Boolean nullable;

  /**
   * 当前项目名工程名
   */
  @ApiModelProperty("项目名")
  @Column(name="project_name", nullable = false, columnDefinition = "varchar(255) default '' comment '工程名'")
  @SaturnColumn(description = "工程名")
  private String projectName;

  public String getProjectName() {
    return projectName;
  }

  public void setProjectName(String projectName) {
    this.projectName = projectName;
  }
  
  public Integer getType() {
    return type;
  }
  public void setType(Integer type) {
    this.type = type;
  }
  public String getParamDesc() {
    return paramDesc;
  }
  public void setParamDesc(String paramDesc) {
    this.paramDesc = paramDesc;
  }
  public String getParamType() {
    return paramType;
  }
  public void setParamType(String paramType) {
    this.paramType = paramType;
  }
  public Boolean getNullable() {
    return nullable;
  }
  public void setNullable(Boolean nullable) {
    this.nullable = nullable;
  }
  public RuleNodeEntity getNode() {
    return node;
  }
  public void setNode(RuleNodeEntity node) {
    this.node = node;
  }
  public String getTemplateParamName() {
    return templateParamName;
  }
  public void setTemplateParamName(String templateParamName) {
    this.templateParamName = templateParamName;
  }
  public String getContextParamName() {
    return contextParamName;
  }
  public void setContextParamName(String contextParamName) {
    this.contextParamName = contextParamName;
  }
  public String getFixedValue() {
    return fixedValue;
  }
  public void setFixedValue(String fixedValue) {
    this.fixedValue = fixedValue;
  }
}