package com.bizunited.platform.mars.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 节点模板的出参或入参信息说明
 * @Author yinwenjie
 * @Date  2020-06-20
 */
@Entity
@Table(name = "engine_rule_template_params")
@ApiModel(value = "RuleTemplateParamsEntity" , description="节点模板的出参或入参信息说明")
@org.hibernate.annotations.Table(appliesTo = "engine_rule_template_params" , comment = "节点模板的出参或入参信息说明")
public class RuleTemplateParamsEntity extends UuidEntity {
  /**
   * 
   */
  private static final long serialVersionUID = 3218912718719020074L;
  /**
   * 对应的节点模板信息
   */
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="node_template_id" , nullable=false, columnDefinition = "varchar(255) COMMENT '对应的节点模板信息'")
  @SaturnColumn(description="对应的节点模板信息")
  private RuleTemplateNodeEntity templateNode;
  /**
   * 出参还是入参：1、入参；2、出参
   */
  @ApiModelProperty(name = "type", value = "出参还是入参：1、入参；2、出参")
  @Column(name = "type" , nullable = false , columnDefinition = "int(11)  COMMENT '出参还是入参：1、入参；2、出参'")
  @SaturnColumn(description = "出参还是入参：1、入参；2、出参")
  private Integer type;
  /**
   * 参数中文说明
   */
  @ApiModelProperty(name = "paramDesc", value = "参数中文说明")
  @Column(name = "param_desc" , length = 512 , nullable = false , columnDefinition = "varchar(512)  COMMENT '参数中文说明'")
  @SaturnColumn(description = "参数中文说明")
  private String paramDesc;
  /**
   * 参数名（符合变量命名格式）
   */
  @ApiModelProperty(name = "paramName", value = "参数名")
  @Column(name = "param_name" , length = 128 , nullable = false , columnDefinition = "varchar(128)  COMMENT '参数名'")
  @SaturnColumn(description = "参数名")
  private String paramName;
  /**
   * 参数类型（八大类型、字符串、Object、Collections）：</br>
   * chart、long、int、float、boolean、double、short、byte、string、object、collection
   */
  @ApiModelProperty(name = "paramType", value = "参数类型（八大类型、Object、Collections？）")
  @Column(name = "param_type" , nullable = false , columnDefinition = "varchar(128)  COMMENT '参数类型'")
  @SaturnColumn(description = "参数类型")
  private String paramType;
  /**
   * 参数是否可为null。如果不能为null，则会进行判定
   */
  @ApiModelProperty(name = "nullable", value = "参数是否可为null")
  @SaturnColumn(description = "参数是否可为null")
  @Column(name = "nullable", nullable = false, columnDefinition = "bit(1) comment '参数是否可为null'")
  private Boolean nullable;

  /**
   * 当前项目名工程名
   */
  @ApiModelProperty("项目名")
  @Column(name="project_name", nullable = false, columnDefinition = "varchar(255) default '' comment '工程名'")
  @SaturnColumn(description = "工程名")
  private String projectName;

  public String getProjectName() {
    return projectName;
  }

  public void setProjectName(String projectName) {
    this.projectName = projectName;
  }
  
  public Integer getType() {
    return type;
  }
  public void setType(Integer type) {
    this.type = type;
  }
  public String getParamDesc() {
    return paramDesc;
  }
  public void setParamDesc(String paramDesc) {
    this.paramDesc = paramDesc;
  }
  public String getParamName() {
    return paramName;
  }
  public void setParamName(String paramName) {
    this.paramName = paramName;
  }
  public String getParamType() {
    return paramType;
  }
  public void setParamType(String paramType) {
    this.paramType = paramType;
  }
  public static long getSerialversionuid() {
    return serialVersionUID;
  }
  public Boolean getNullable() {
    return nullable;
  }
  public void setNullable(Boolean nullable) {
    this.nullable = nullable;
  }
  public RuleTemplateNodeEntity getTemplateNode() {
    return templateNode;
  }
  public void setTemplateNode(RuleTemplateNodeEntity templateNode) {
    this.templateNode = templateNode;
  }
}