package com.bizunited.platform.mars.repository;
import com.bizunited.platform.mars.entity.RuleNodeEntity;
import java.lang.String;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * RuleNodeEntity业务模型的数据库方法支持
 * @author saturn
 */
@Repository("_RuleNodeEntityRepository")
public interface RuleNodeEntityRepository
    extends
      JpaRepository<RuleNodeEntity, String>
      ,JpaSpecificationExecutor<RuleNodeEntity>
  {
  /**
   * 按照该节点定义使用的节点模板进行详情查询（包括关联信息）
   * @param templateNode 该节点定义使用的节点模板
   * */
  @Query("select distinct ruleNodeEntity from RuleNodeEntity ruleNodeEntity "
      + " left join fetch ruleNodeEntity.templateNode ruleNodeEntity_templateNode "
      + " left join fetch ruleNodeEntity.definition ruleNodeEntity_definition "
       + " where ruleNodeEntity_templateNode.id = :id")
  public Set<RuleNodeEntity> findDetailsByTemplateNode(@Param("id") String id);
  /**
   * 按照规则工作节点所属的规则模板进行详情查询（包括关联信息）
   * @param definition 规则工作节点所属的规则模板
   * */
  @Query("select distinct ruleNodeEntity from RuleNodeEntity ruleNodeEntity "
      + " left join fetch ruleNodeEntity.templateNode ruleNodeEntity_templateNode "
      + " left join fetch ruleNodeEntity.definition ruleNodeEntity_definition "
       + " where ruleNodeEntity_definition.id = :id")
  public Set<RuleNodeEntity> findDetailsByDefinition(@Param("id") String id);

  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   * */
  @Query("select distinct ruleNodeEntity from RuleNodeEntity ruleNodeEntity "
      + " left join fetch ruleNodeEntity.templateNode ruleNodeEntity_templateNode "
      + " left join fetch ruleNodeEntity.definition ruleNodeEntity_definition "
      + " where ruleNodeEntity.id=:id ")
  public RuleNodeEntity findDetailsById(@Param("id") String id); 
  /**
   * 按照节点定义编号进行基本信息查询
   * @param code 业务编号
   * */
  @Query("from RuleNodeEntity r where r.code=:code and r.projectName=:projectName ")
  public RuleNodeEntity findByCodeAndProjectName(@Param("code") String code, @Param("projectName") String projectName);
  /**
   * 按照多个主键进行信息的真删除
   * @param ids
   */
  @Modifying
  @Query(value="delete from engine_rule_nodes where engine_rule_nodes.id in (:ids)" , nativeQuery = true)
  public void deleteByIds(@Param("ids") String ids[]);
}