package com.bizunited.platform.mars.repository;
import com.bizunited.platform.mars.entity.RuleNodeParamsEntity;
import java.lang.String;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * RuleNodeParamsEntity业务模型的数据库方法支持
 * @author saturn
 */
@Repository("_RuleNodeParamsEntityRepository")
public interface RuleNodeParamsEntityRepository
    extends
      JpaRepository<RuleNodeParamsEntity, String>
      ,JpaSpecificationExecutor<RuleNodeParamsEntity>
  {
  /**
   * 按照对应的节点定义信息进行详情查询（包括关联信息）
   * @param node 对应的节点定义信息
   * */
  @Query("select distinct ruleNodeParamsEntity from RuleNodeParamsEntity ruleNodeParamsEntity "
      + " left join fetch ruleNodeParamsEntity.node ruleNodeParamsEntity_node "
       + " where ruleNodeParamsEntity_node.id = :id")
  public Set<RuleNodeParamsEntity> findDetailsByNode(@Param("id") String id);

  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   * */
  @Query("select distinct ruleNodeParamsEntity from RuleNodeParamsEntity ruleNodeParamsEntity "
      + " left join fetch ruleNodeParamsEntity.node ruleNodeParamsEntity_node "
      + " where ruleNodeParamsEntity.id=:id ")
  public RuleNodeParamsEntity findDetailsById(@Param("id") String id);

  /**
   * 按照一个或者多个节点定义id信息，删除这些id下的所有参数定义信息
   * @param ruleNodeIds
   */
  @Modifying
  @Query(value="delete from engine_rule_node_params where engine_rule_node_params.node_id in (:ruleNodeIds) " , nativeQuery = true)
  public void deleteByRuleNodes(@Param("ruleNodeIds") String ruleNodeIds[]);
}