package com.bizunited.platform.mars.repository;

import com.bizunited.platform.mars.entity.RuleTemplateNodeEntity;
import com.bizunited.platform.mars.repository.internal.RuleTemplateNodeEntityRepositoryCustom;

import java.lang.String;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * RuleTemplateNodeEntity业务模型的数据库方法支持
 * @author saturn
 */
@Repository("_RuleTemplateNodeEntityRepository")
public interface RuleTemplateNodeEntityRepository
    extends
      JpaRepository<RuleTemplateNodeEntity, String>
      ,JpaSpecificationExecutor<RuleTemplateNodeEntity>
      ,RuleTemplateNodeEntityRepositoryCustom 
  {
  /**
   * 按照节点模板所属的分组进行详情查询（包括关联信息）
   * @param templateGroup 节点模板所属的分组
   * */
  @Query("select ruleTemplateNodeEntity from RuleTemplateNodeEntity ruleTemplateNodeEntity "
      + " left join fetch ruleTemplateNodeEntity.templateGroup ruleTemplateNodeEntity_templateGroup "
       + " where ruleTemplateNodeEntity_templateGroup.id = :id")
  public Set<RuleTemplateNodeEntity> findDetailsByTemplateGroup(@Param("id") String id);

  /**
   * 根据多个主键编号，查询指定的数据信息（不包括任何关联信息）
   * @param ids 多个id信息
   * @return
   */
  @Query("from RuleTemplateNodeEntity r "
      + " where r.id in (:ids) ")
  public Set<RuleTemplateNodeEntity> findByIds(@Param("ids") String ids[]);
  
  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   * */
  @Query("from RuleTemplateNodeEntity r "
      + " left join fetch r.templateGroup g "
      + " left join fetch r.inputs "
      + " left join fetch r.outputs "
      + " left join fetch r.sourceServicable "
      + " left join fetch r.sourceAggregateDataView "
      + " left join fetch r.sourceScript ss "
      + " left join fetch ss.script "
      + " where r.id=:id ")
  public RuleTemplateNodeEntity findDetailsById(@Param("id") String id);
  /**
   * 按照节点模板业务编号进行查询
   * @param code 节点模板业务编号
   * */
  @Query(" from RuleTemplateNodeEntity f where f.code = :code and f.projectName=:projectName ")
  public RuleTemplateNodeEntity findByCodeAndProjectName(@Param("code") String code, @Param("projectName") String projectName);
  /**
   * 按照节点定义编号进行详细信息查询（包括了该节点模板关联的出参、入参，处理器信息）
   * @param code 指定的模板节点业务编号
   * @return
   */
  @Query("from RuleTemplateNodeEntity r "
      + " left join fetch r.templateGroup g "
      + " left join fetch r.inputs "
      + " left join fetch r.outputs "
      + " left join fetch r.sourceServicable "
      + " left join fetch r.sourceAggregateDataView "
      + " left join fetch r.sourceScript ss "
      + " left join fetch ss.script "
      + " where r.code=:code and r.projectName=:projectName ")
  public RuleTemplateNodeEntity findDetailsByCodeAndProjectName(@Param("code") String code, @Param("projectName") String projectName);
  /**
   * 按照模板节点分组，查询属于这个模板分组下模板节点的信息（只包括基本信息）,返回信息将按照节点模板业务编号进行排序
   * @param templateGroup 指定的模板分组id
   * @return 
   */
  @Query(" from RuleTemplateNodeEntity f where f.templateGroup.id = :templateGroup order by f.code ")
  public Set<RuleTemplateNodeEntity> findByTemplateGroup(@Param("templateGroup") String templateGroup);
  
  /**
   * 按照模板节点分组，查询属于这个模板分组下符合模板定义的模板节点的信息（只包括基本信息）,返回信息将按照节点模板业务编号进行排序
   * @param templateGroup 指定的模板分组id
   * @param nodeStatus 节点模板的状态条件
   * @return 
   */
  @Query(" from RuleTemplateNodeEntity f where f.templateGroup.id = :templateGroup And f.nodeStatus = :nodeStatus order by f.code ")
  public Set<RuleTemplateNodeEntity> findByTemplateGroupAndStatus(@Param("templateGroup") String templateGroup , @Param("nodeStatus") Integer nodeStatus);
  
  /**
   * 按照模板节点分组，查询属于这个模板分组下模板节点的信息（只包括基本信息）,返回数量信息
   * @param templateGroup 指定的模板分组id
   * @return 
   */
  @Query(" select count(*) from RuleTemplateNodeEntity f where f.templateGroup.id = :templateGroup")
  public long countByTemplateGroup(@Param("templateGroup") String templateGroup);
  /**
   * 基于指定的模板分组，解除所有节点模板和他的绑定关系
   * @param id
   * @param templateNodeIds
   */
  @Modifying
  @Query(value="update engine_rule_template_node set group_id = null where group_id = :templateGroupId" , nativeQuery = true)
  public void unbindAllTemplateGroups(@Param("templateGroupId") String templateGroupId);
}