/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.mars.repository.internal;

import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.platform.common.util.ApplicationContextUtils;
import com.bizunited.platform.mars.entity.RuleTemplateNodeEntity;
import com.bizunited.platform.mars.repository.internal.RuleTemplateNodeEntityRepositoryCustom;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="RuleTemplateNodeEntityRepositoryImpl")
public class RuleTemplateNodeEntityRepositoryImpl
implements RuleTemplateNodeEntityRepositoryCustom,
PageRepositoryImpl {
    @Autowired
    private EntityManager entityManager;

    @Override
    public List<RuleTemplateNodeEntity> findByTemplateGroupAndStatusAndType(String templateGroup, Integer nodeStatus, Integer type) {
        StringBuilder hql = new StringBuilder("from RuleTemplateNodeEntity et left join fetch et.templateGroup tg where 1=1 ");
        StringBuilder condition = new StringBuilder();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        condition.append(" and et.projectName=:projectName ");
        parameters.put("projectName", ApplicationContextUtils.getProjectName());
        if (StringUtils.isNotBlank((CharSequence)templateGroup)) {
            condition.append(" AND tg.id = :templateGroup ");
            parameters.put("templateGroup", templateGroup);
        }
        if (nodeStatus != null) {
            condition.append(" AND et.nodeStatus = :nodeStatus ");
            parameters.put("nodeStatus", nodeStatus);
        }
        if (type != null) {
            condition.append(" AND et.type = :type ");
            parameters.put("type", type);
        }
        hql.append((CharSequence)condition).append(" order by et.createTime desc  ");
        Query query = this.entityManager.createQuery(hql.toString());
        parameters.forEach((k, v) -> query.setParameter(k, v));
        return query.getResultList();
    }
}

