/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.mars.service.internal;

import com.bizunited.platform.common.util.ApplicationContextUtils;
import com.bizunited.platform.mars.entity.RuleNodeParamsEntity;
import com.bizunited.platform.mars.repository.RuleNodeParamsEntityRepository;
import com.bizunited.platform.mars.service.RuleNodeParamsEntityService;
import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="RuleNodeParamsEntityServiceImpl")
public class RuleNodeParamsEntityServiceImpl
implements RuleNodeParamsEntityService {
    @Autowired
    private RuleNodeParamsEntityRepository ruleNodeParamsEntityRepository;

    @Override
    @Transactional
    public RuleNodeParamsEntity create(RuleNodeParamsEntity ruleNodeParamsEntity) {
        RuleNodeParamsEntity current = this.createForm(ruleNodeParamsEntity);
        return current;
    }

    @Override
    @Transactional
    public RuleNodeParamsEntity createForm(RuleNodeParamsEntity ruleNodeParamsEntity) {
        this.createValidation(ruleNodeParamsEntity);
        ruleNodeParamsEntity.setProjectName(ApplicationContextUtils.getProjectName());
        this.ruleNodeParamsEntityRepository.save((Object)ruleNodeParamsEntity);
        return ruleNodeParamsEntity;
    }

    private void createValidation(RuleNodeParamsEntity ruleNodeParamsEntity) {
        Validate.notNull((Object)((Object)ruleNodeParamsEntity), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)ruleNodeParamsEntity.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        ruleNodeParamsEntity.setId(null);
        Validate.notNull((Object)ruleNodeParamsEntity.getType(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u51fa\u53c2\u8fd8\u662f\u5165\u53c2\uff1a1\u3001\u5165\u53c2\uff1b2\u3001\u51fa\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)ruleNodeParamsEntity.getParamDesc(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u53c2\u6570\u4e2d\u6587\u8bf4\u660e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String contextParamName = ruleNodeParamsEntity.getContextParamName();
        String fixedValue = ruleNodeParamsEntity.getFixedValue();
        if (StringUtils.isEmpty((CharSequence)contextParamName) && StringUtils.isEmpty((CharSequence)fixedValue)) {
            throw new IllegalArgumentException("\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5165\u53c2\u6765\u6e90\u5fc5\u987b\u4ece\u201c\u56fa\u5b9a\u503c\u201d/\u201c\u4e0a\u4e0b\u6587\u7ed1\u5b9a\u201d\u4e24\u79cd\u65b9\u5f0f\u4e2d\uff0c\u9009\u62e9\u4e00\u79cd");
        }
        Validate.notBlank((CharSequence)ruleNodeParamsEntity.getTemplateParamName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5bf9\u5e94\u7684\u6a21\u677f\u53c2\u6570\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)ruleNodeParamsEntity.getParamType(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u53c2\u6570\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)ruleNodeParamsEntity.getNullable(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u53c2\u6570\u662f\u5426\u53ef\u4e3anull\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((ruleNodeParamsEntity.getParamDesc() == null || ruleNodeParamsEntity.getParamDesc().length() < 512 ? 1 : 0) != 0, (String)"\u53c2\u6570\u4e2d\u6587\u8bf4\u660e,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(512)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((ruleNodeParamsEntity.getContextParamName() == null || ruleNodeParamsEntity.getContextParamName().length() < 128 ? 1 : 0) != 0, (String)"\u4e0a\u4e0b\u6587\u53c2\u6570\u540d,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((ruleNodeParamsEntity.getTemplateParamName() == null || ruleNodeParamsEntity.getTemplateParamName().length() < 128 ? 1 : 0) != 0, (String)"\u6a21\u677f\u53c2\u6570\u540d,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public RuleNodeParamsEntity update(RuleNodeParamsEntity ruleNodeParamsEntity) {
        RuleNodeParamsEntity current = this.updateForm(ruleNodeParamsEntity);
        return current;
    }

    @Override
    @Transactional
    public RuleNodeParamsEntity updateForm(RuleNodeParamsEntity ruleNodeParamsEntity) {
        this.updateValidation(ruleNodeParamsEntity);
        String currentId = ruleNodeParamsEntity.getId();
        Optional op_currentRuleNodeParamsEntity = this.ruleNodeParamsEntityRepository.findById(currentId);
        RuleNodeParamsEntity currentRuleNodeParamsEntity = op_currentRuleNodeParamsEntity.orElse(null);
        currentRuleNodeParamsEntity = (RuleNodeParamsEntity)((Object)Validate.notNull((Object)((Object)currentRuleNodeParamsEntity), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]));
        currentRuleNodeParamsEntity.setType(ruleNodeParamsEntity.getType());
        currentRuleNodeParamsEntity.setParamDesc(ruleNodeParamsEntity.getParamDesc());
        currentRuleNodeParamsEntity.setContextParamName(ruleNodeParamsEntity.getContextParamName());
        currentRuleNodeParamsEntity.setParamType(ruleNodeParamsEntity.getParamType());
        currentRuleNodeParamsEntity.setNullable(ruleNodeParamsEntity.getNullable());
        currentRuleNodeParamsEntity.setNode(ruleNodeParamsEntity.getNode());
        this.ruleNodeParamsEntityRepository.saveAndFlush((Object)currentRuleNodeParamsEntity);
        return currentRuleNodeParamsEntity;
    }

    private void updateValidation(RuleNodeParamsEntity ruleNodeParamsEntity) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)ruleNodeParamsEntity.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)ruleNodeParamsEntity.getType(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u51fa\u53c2\u8fd8\u662f\u5165\u53c2\uff1a1\u3001\u5165\u53c2\uff1b2\u3001\u51fa\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)ruleNodeParamsEntity.getParamDesc(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u53c2\u6570\u4e2d\u6587\u8bf4\u660e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String contextParamName = ruleNodeParamsEntity.getContextParamName();
        String fixedValue = ruleNodeParamsEntity.getFixedValue();
        if (StringUtils.isEmpty((CharSequence)contextParamName) && StringUtils.isEmpty((CharSequence)fixedValue)) {
            throw new IllegalArgumentException("\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5165\u53c2\u6765\u6e90\u5fc5\u987b\u4ece\u201c\u56fa\u5b9a\u503c\u201d/\u201c\u4e0a\u4e0b\u6587\u7ed1\u5b9a\u201d\u4e24\u79cd\u65b9\u5f0f\u4e2d\uff0c\u9009\u62e9\u4e00\u79cd");
        }
        Validate.notBlank((CharSequence)ruleNodeParamsEntity.getTemplateParamName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5bf9\u5e94\u7684\u6a21\u677f\u53c2\u6570\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)ruleNodeParamsEntity.getParamType(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u53c2\u6570\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)ruleNodeParamsEntity.getNullable(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u53c2\u6570\u662f\u5426\u53ef\u4e3anull\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((ruleNodeParamsEntity.getParamDesc() == null || ruleNodeParamsEntity.getParamDesc().length() < 512 ? 1 : 0) != 0, (String)"\u53c2\u6570\u4e2d\u6587\u8bf4\u660e,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(512)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((ruleNodeParamsEntity.getContextParamName() == null || ruleNodeParamsEntity.getContextParamName().length() < 128 ? 1 : 0) != 0, (String)"\u4e0a\u4e0b\u6587\u53c2\u6570\u540d,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        RuleNodeParamsEntity current = this.findById(id);
        if (current != null) {
            this.ruleNodeParamsEntityRepository.delete((Object)current);
        }
    }

    @Override
    @Transactional
    public void deleteByRuleNodes(String[] ruleNodeIds) {
        Validate.isTrue((ruleNodeIds != null && ruleNodeIds.length > 0 ? 1 : 0) != 0, (String)"\u5220\u9664\u8282\u70b9\u53c2\u6570\u65f6\uff0c\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u89c4\u5219\u5b9a\u4e49\u4fe1\u606f\u7684\u7f16\u53f7", (Object[])new Object[0]);
        this.ruleNodeParamsEntityRepository.deleteByRuleNodes(ruleNodeIds);
        this.ruleNodeParamsEntityRepository.flush();
    }

    @Override
    public Set<RuleNodeParamsEntity> findDetailsByNode(String node) {
        if (StringUtils.isBlank((CharSequence)node)) {
            return Sets.newHashSet();
        }
        return this.ruleNodeParamsEntityRepository.findDetailsByNode(node);
    }

    @Override
    public RuleNodeParamsEntity findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.ruleNodeParamsEntityRepository.findDetailsById(id);
    }

    @Override
    public RuleNodeParamsEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.ruleNodeParamsEntityRepository.findById(id);
        return op.orElse(null);
    }
}

