/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.mars.service.internal;

import com.bizunited.platform.common.util.ApplicationContextUtils;
import com.bizunited.platform.mars.entity.RuleSourceScriptEntity;
import com.bizunited.platform.mars.repository.RuleSourceScriptEntityRepository;
import com.bizunited.platform.mars.service.RuleSourceScriptEntityService;
import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="RuleSourceScriptEntityServiceImpl")
public class RuleSourceScriptEntityServiceImpl
implements RuleSourceScriptEntityService {
    @Autowired
    private RuleSourceScriptEntityRepository ruleSourceScriptRepository;

    @Override
    @Transactional
    public RuleSourceScriptEntity create(RuleSourceScriptEntity ruleSourceScript) {
        RuleSourceScriptEntity current = this.createForm(ruleSourceScript);
        return current;
    }

    @Override
    @Transactional
    public RuleSourceScriptEntity createForm(RuleSourceScriptEntity ruleSourceScript) {
        this.createValidation(ruleSourceScript);
        ruleSourceScript.setProjectName(ApplicationContextUtils.getProjectName());
        this.ruleSourceScriptRepository.save((Object)ruleSourceScript);
        return ruleSourceScript;
    }

    private void createValidation(RuleSourceScriptEntity ruleSourceScript) {
        Validate.notNull((Object)((Object)ruleSourceScript), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)ruleSourceScript.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        ruleSourceScript.setId(null);
    }

    @Override
    @Transactional
    public RuleSourceScriptEntity update(RuleSourceScriptEntity ruleSourceScript) {
        RuleSourceScriptEntity current = this.updateForm(ruleSourceScript);
        return current;
    }

    @Override
    @Transactional
    public RuleSourceScriptEntity updateForm(RuleSourceScriptEntity ruleSourceScript) {
        this.updateValidation(ruleSourceScript);
        String currentId = ruleSourceScript.getId();
        Optional op_currentRuleSourceScriptEntity = this.ruleSourceScriptRepository.findById(currentId);
        RuleSourceScriptEntity currentRuleSourceScriptEntity = op_currentRuleSourceScriptEntity.orElse(null);
        currentRuleSourceScriptEntity = (RuleSourceScriptEntity)((Object)Validate.notNull((Object)((Object)currentRuleSourceScriptEntity), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]));
        currentRuleSourceScriptEntity.setScript(ruleSourceScript.getScript());
        this.ruleSourceScriptRepository.saveAndFlush((Object)currentRuleSourceScriptEntity);
        return currentRuleSourceScriptEntity;
    }

    private void updateValidation(RuleSourceScriptEntity ruleSourceScript) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)ruleSourceScript.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
    }

    @Override
    public Set<RuleSourceScriptEntity> findDetailsByScript(String script) {
        if (StringUtils.isBlank((CharSequence)script)) {
            return Sets.newHashSet();
        }
        return this.ruleSourceScriptRepository.findDetailsByScript(script);
    }

    @Override
    public RuleSourceScriptEntity findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.ruleSourceScriptRepository.findDetailsById(id);
    }

    @Override
    public RuleSourceScriptEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.ruleSourceScriptRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        RuleSourceScriptEntity current = this.findById(id);
        if (current != null) {
            this.ruleSourceScriptRepository.delete((Object)current);
        }
    }
}

