/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.mars.service.internal;

import com.bizunited.platform.common.util.ApplicationContextUtils;
import com.bizunited.platform.mars.entity.RuleTemplateGroupEntity;
import com.bizunited.platform.mars.repository.RuleTemplateGroupEntityRepository;
import com.bizunited.platform.mars.service.RuleTemplateGroupEntityService;
import com.bizunited.platform.mars.service.RuleTemplateNodeEntityService;
import com.bizunited.platform.mars.service.internal.AbstractMarsSaveableService;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="RuleTemplateGroupEntityServiceImpl")
public class RuleTemplateGroupEntityServiceImpl
extends AbstractMarsSaveableService
implements RuleTemplateGroupEntityService {
    @Autowired
    private RuleTemplateGroupEntityRepository ruleTemplateGroupEntityRepository;
    @Autowired
    private RuleTemplateNodeEntityService ruleTemplateNodeEntityService;

    @Override
    @Transactional
    public RuleTemplateGroupEntity create(RuleTemplateGroupEntity ruleTemplateGroupEntity) {
        String account = this.findCreator();
        ruleTemplateGroupEntity.setCreateAccount(account);
        ruleTemplateGroupEntity.setCreateTime(new Date());
        ruleTemplateGroupEntity.setModifyAccount(account);
        ruleTemplateGroupEntity.setModifyTime(new Date());
        ruleTemplateGroupEntity.setGroupStatus(1);
        RuleTemplateGroupEntity current = this.createForm(ruleTemplateGroupEntity);
        return current;
    }

    @Override
    @Transactional
    public RuleTemplateGroupEntity createForm(RuleTemplateGroupEntity ruleTemplateGroupEntity) {
        this.createValidation(ruleTemplateGroupEntity);
        ruleTemplateGroupEntity.setProjectName(ApplicationContextUtils.getProjectName());
        this.ruleTemplateGroupEntityRepository.save((Object)ruleTemplateGroupEntity);
        return ruleTemplateGroupEntity;
    }

    private void createValidation(RuleTemplateGroupEntity ruleTemplateGroupEntity) {
        Validate.notNull((Object)((Object)ruleTemplateGroupEntity), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)ruleTemplateGroupEntity.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        ruleTemplateGroupEntity.setId(null);
        Validate.notBlank((CharSequence)ruleTemplateGroupEntity.getCreateAccount(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u521b\u5efa\u4eba\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)ruleTemplateGroupEntity.getCreateTime(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u521b\u5efa\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)ruleTemplateGroupEntity.getModifyAccount(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u66f4\u65b0\u4eba\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)ruleTemplateGroupEntity.getCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5206\u7ec4\u7f16\u53f7\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)ruleTemplateGroupEntity.getName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u6a21\u677f\u5206\u7ec4\u540d\u79f0\uff08\u4e2d\u6587\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)ruleTemplateGroupEntity.getGroupStatus(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5206\u7ec4\u53ef\u7528\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)ruleTemplateGroupEntity.getType(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5206\u7ec4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((ruleTemplateGroupEntity.getCreateAccount() == null || ruleTemplateGroupEntity.getCreateAccount().length() < 255 ? 1 : 0) != 0, (String)"\u521b\u5efa\u4eba\u8d26\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((ruleTemplateGroupEntity.getModifyAccount() == null || ruleTemplateGroupEntity.getModifyAccount().length() < 255 ? 1 : 0) != 0, (String)"\u66f4\u65b0\u4eba\u8d26\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((ruleTemplateGroupEntity.getCode() == null || ruleTemplateGroupEntity.getCode().length() < 128 ? 1 : 0) != 0, (String)"\u5206\u7ec4\u7f16\u53f7\u7f16\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((ruleTemplateGroupEntity.getName() == null || ruleTemplateGroupEntity.getName().length() < 128 ? 1 : 0) != 0, (String)"\u6a21\u677f\u5206\u7ec4\u540d\u79f0\uff08\u4e2d\u6587\uff09,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        RuleTemplateGroupEntity currentRuleTemplateGroupEntity = this.findByCode(ruleTemplateGroupEntity.getCode());
        Validate.isTrue((currentRuleTemplateGroupEntity == null ? 1 : 0) != 0, (String)"\u5206\u7ec4\u7f16\u53f7\u7f16\u53f7\u5df2\u5b58\u5728,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public RuleTemplateGroupEntity update(RuleTemplateGroupEntity ruleTemplateGroupEntity) {
        String account = this.findModifyor();
        ruleTemplateGroupEntity.setModifyAccount(account);
        ruleTemplateGroupEntity.setModifyTime(new Date());
        RuleTemplateGroupEntity current = this.updateForm(ruleTemplateGroupEntity);
        return current;
    }

    @Override
    @Transactional
    public RuleTemplateGroupEntity updateForm(RuleTemplateGroupEntity ruleTemplateGroupEntity) {
        this.updateValidation(ruleTemplateGroupEntity);
        String currentId = ruleTemplateGroupEntity.getId();
        Optional op_currentRuleTemplateGroupEntity = this.ruleTemplateGroupEntityRepository.findById(currentId);
        RuleTemplateGroupEntity currentRuleTemplateGroupEntity = op_currentRuleTemplateGroupEntity.orElse(null);
        currentRuleTemplateGroupEntity = (RuleTemplateGroupEntity)((Object)Validate.notNull((Object)((Object)currentRuleTemplateGroupEntity), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]));
        currentRuleTemplateGroupEntity.setModifyAccount(ruleTemplateGroupEntity.getModifyAccount());
        currentRuleTemplateGroupEntity.setModifyTime(ruleTemplateGroupEntity.getModifyTime());
        currentRuleTemplateGroupEntity.setName(ruleTemplateGroupEntity.getName());
        currentRuleTemplateGroupEntity.setGroupStatus(ruleTemplateGroupEntity.getGroupStatus());
        this.ruleTemplateGroupEntityRepository.saveAndFlush((Object)currentRuleTemplateGroupEntity);
        return currentRuleTemplateGroupEntity;
    }

    private void updateValidation(RuleTemplateGroupEntity ruleTemplateGroupEntity) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)ruleTemplateGroupEntity.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)ruleTemplateGroupEntity.getModifyAccount(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u66f4\u65b0\u4eba\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)ruleTemplateGroupEntity.getName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u6a21\u677f\u5206\u7ec4\u540d\u79f0\uff08\u4e2d\u6587\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)ruleTemplateGroupEntity.getGroupStatus(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5206\u7ec4\u53ef\u7528\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        RuleTemplateGroupEntity currentForCode = this.findByCode(ruleTemplateGroupEntity.getCode());
        Validate.isTrue((currentForCode == null || StringUtils.equals((CharSequence)currentForCode.getId(), (CharSequence)ruleTemplateGroupEntity.getId()) ? 1 : 0) != 0, (String)"\u5206\u7ec4\u7f16\u53f7\u7f16\u53f7\u5df2\u5b58\u5728,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.isTrue((ruleTemplateGroupEntity.getModifyAccount() == null || ruleTemplateGroupEntity.getModifyAccount().length() < 255 ? 1 : 0) != 0, (String)"\u66f4\u65b0\u4eba\u8d26\u53f7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((ruleTemplateGroupEntity.getName() == null || ruleTemplateGroupEntity.getName().length() < 128 ? 1 : 0) != 0, (String)"\u6a21\u677f\u5206\u7ec4\u540d\u79f0\uff08\u4e2d\u6587\uff09,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    public RuleTemplateGroupEntity findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.ruleTemplateGroupEntityRepository.findDetailsById(id);
    }

    @Override
    public RuleTemplateGroupEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.ruleTemplateGroupEntityRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        RuleTemplateGroupEntity current = this.findById(id);
        Validate.isTrue((this.ruleTemplateNodeEntityService.countByTemplateGroup(id) == 0L ? 1 : 0) != 0, (String)"\u5f53\u524d\u8981\u88ab\u5220\u9664\u7684\u5206\u7ec4\u4fe1\u606f\u8fd8\u5b58\u5728\u5173\u8054\u7684\u8282\u70b9\u6a21\u677f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        if (current != null) {
            this.ruleTemplateGroupEntityRepository.delete((Object)current);
        }
    }

    @Override
    public RuleTemplateGroupEntity findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return this.ruleTemplateGroupEntityRepository.findByCodeAndProjectName(code, ApplicationContextUtils.getProjectName());
    }

    @Override
    public Set<RuleTemplateGroupEntity> findByGroupStatus(Integer groupStatus) {
        if (groupStatus == null) {
            return this.ruleTemplateGroupEntityRepository.findAllOrderByTypeAndNameAndProjectName(ApplicationContextUtils.getProjectName());
        }
        return this.ruleTemplateGroupEntityRepository.findByGroupStatusAndProjectName(groupStatus, ApplicationContextUtils.getProjectName());
    }

    @Override
    public Set<RuleTemplateGroupEntity> findByType(Integer type) {
        if (type == null || type <= 0) {
            return null;
        }
        return this.ruleTemplateGroupEntityRepository.findByTypeAndProjectName(type, ApplicationContextUtils.getProjectName());
    }
}

