/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.mars.service.internal;

import com.bizunited.platform.common.util.ApplicationContextUtils;
import com.bizunited.platform.core.entity.ScriptEntity;
import com.bizunited.platform.core.service.ScriptService;
import com.bizunited.platform.mars.entity.RuleSourceAggregateDataViewEntity;
import com.bizunited.platform.mars.entity.RuleSourceScriptEntity;
import com.bizunited.platform.mars.entity.RuleSourceServicableEntity;
import com.bizunited.platform.mars.entity.RuleTemplateGroupEntity;
import com.bizunited.platform.mars.entity.RuleTemplateNodeEntity;
import com.bizunited.platform.mars.entity.RuleTemplateParamsEntity;
import com.bizunited.platform.mars.repository.RuleTemplateNodeEntityRepository;
import com.bizunited.platform.mars.service.RuleSourceAggregateDataViewEntityService;
import com.bizunited.platform.mars.service.RuleSourceScriptEntityService;
import com.bizunited.platform.mars.service.RuleSourceServicableEntityService;
import com.bizunited.platform.mars.service.RuleTemplateGroupEntityService;
import com.bizunited.platform.mars.service.RuleTemplateNodeEntityService;
import com.bizunited.platform.mars.service.RuleTemplateParamsEntityService;
import com.bizunited.platform.mars.service.internal.AbstractMarsSaveableService;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="RuleTemplateNodeEntityServiceImpl")
public class RuleTemplateNodeEntityServiceImpl
extends AbstractMarsSaveableService
implements RuleTemplateNodeEntityService {
    @Autowired
    private RuleTemplateNodeEntityRepository ruleTemplateNodeEntityRepository;
    @Autowired
    private RuleTemplateGroupEntityService ruleTemplateGroupEntityService;
    @Autowired
    private RuleTemplateParamsEntityService ruleTemplateParamsService;
    @Autowired
    private RuleSourceServicableEntityService ruleSourceServicableService;
    @Autowired
    private RuleSourceAggregateDataViewEntityService ruleSourceAggregateDataViewService;
    @Autowired
    private RuleSourceScriptEntityService ruleSourceScriptService;
    @Autowired
    private ScriptService scriptService;
    @Autowired
    private ApplicationContext applicationContext;
    private static final Logger LOGGER = LoggerFactory.getLogger(RuleTemplateNodeEntityServiceImpl.class);
    private static final String STARTER_RULEABLE_INTERFACE = "com.bizunited.platform.mars.service.rule.start.StarterRuleable";
    private static final String PROCESS_RULEABLE_INTERFACE = "com.bizunited.platform.mars.service.rule.processes.ProcessRuleable";
    private static final String MUTEX_RULEABLE_INTERFACE = "com.bizunited.platform.mars.service.rule.mutex.MutexLockRuleable";
    private static final String END_RULEABLE_INTERFACE = "com.bizunited.platform.mars.service.rule.end.EndRuleable";
    private static final String CONDITION_RULEABLE_INTERFACE = "com.bizunited.platform.mars.service.rule.conditions.ConditionRuleable";

    @Override
    @Transactional
    public RuleTemplateNodeEntity create(RuleTemplateNodeEntity ruleTemplateNodeEntity) {
        String account = this.findCreator();
        ruleTemplateNodeEntity.setCreateAccount(account);
        ruleTemplateNodeEntity.setCreateTime(new Date());
        ruleTemplateNodeEntity.setModifyAccount(account);
        ruleTemplateNodeEntity.setModifyTime(new Date());
        ruleTemplateNodeEntity.setNodeStatus(1);
        RuleTemplateNodeEntity current = this.createForm(ruleTemplateNodeEntity);
        return current;
    }

    @Override
    @Transactional
    public RuleTemplateNodeEntity createForm(RuleTemplateNodeEntity ruleTemplateNode) {
        this.createValidation(ruleTemplateNode);
        this.createValidationSource(ruleTemplateNode);
        ruleTemplateNode.setProjectName(ApplicationContextUtils.getProjectName());
        this.ruleTemplateNodeEntityRepository.saveAndFlush((Object)ruleTemplateNode);
        Set<RuleTemplateParamsEntity> intpus = ruleTemplateNode.getInputs();
        Set<RuleTemplateParamsEntity> outpus = ruleTemplateNode.getOutputs();
        this.createValidationParams(ruleTemplateNode, intpus, outpus);
        return ruleTemplateNode;
    }

    private void validateNodeType(String ruleableClassValue, Integer type) {
        ClassLoader classLoader = this.applicationContext.getClassLoader();
        Class<?> ruleableClass = null;
        Class<?> starterRuleableInterface = null;
        Class<?> processRuleableInterface = null;
        Class<?> mutexRuleableInterface = null;
        Class<?> endRuleableInterface = null;
        Class<?> conditionRuleableInterface = null;
        try {
            ruleableClass = classLoader.loadClass(ruleableClassValue);
            starterRuleableInterface = classLoader.loadClass(STARTER_RULEABLE_INTERFACE);
            processRuleableInterface = classLoader.loadClass(PROCESS_RULEABLE_INTERFACE);
            mutexRuleableInterface = classLoader.loadClass(MUTEX_RULEABLE_INTERFACE);
            endRuleableInterface = classLoader.loadClass(END_RULEABLE_INTERFACE);
            conditionRuleableInterface = classLoader.loadClass(CONDITION_RULEABLE_INTERFACE);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        switch (type) {
            case 1: {
                Validate.isTrue((boolean)conditionRuleableInterface.isAssignableFrom(ruleableClass), (String)"\u5224\u5b9a\u7ec4\u4ef6\u6240\u4f7f\u7528\u7684\u5904\u7406\u5668\u5fc5\u987b\u5b9e\u73b0ConditionRuleable\u63a5\u53e3\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6216\u8005\u81ea\u884c\u5b9e\u73b0!!", (Object[])new Object[0]);
                break;
            }
            case 2: {
                Validate.isTrue((boolean)processRuleableInterface.isAssignableFrom(ruleableClass), (String)"\u903b\u8f91\u7ec4\u4ef6\u6240\u4f7f\u7528\u7684\u5904\u7406\u5668\u5fc5\u987b\u5b9e\u73b0ProcessRuleable\u63a5\u53e3\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6216\u8005\u81ea\u884c\u5b9e\u73b0!!", (Object[])new Object[0]);
                break;
            }
            case 3: {
                Validate.isTrue((boolean)mutexRuleableInterface.isAssignableFrom(ruleableClass), (String)"\u9501\u7ec4\u4ef6\u6240\u4f7f\u7528\u7684\u5904\u7406\u5668\u5fc5\u987b\u5b9e\u73b0MutexLockRuleable\u63a5\u53e3\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6216\u8005\u81ea\u884c\u5b9e\u73b0!!", (Object[])new Object[0]);
                break;
            }
            case 4: {
                Validate.isTrue((boolean)starterRuleableInterface.isAssignableFrom(ruleableClass), (String)"\u5f00\u59cb\u7ec4\u4ef6\u6240\u4f7f\u7528\u7684\u5904\u7406\u5668\u5fc5\u987b\u5b9e\u73b0StarterRuleable\u63a5\u53e3\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6216\u8005\u81ea\u884c\u5b9e\u73b0!!", (Object[])new Object[0]);
                break;
            }
            case 5: {
                Validate.isTrue((boolean)endRuleableInterface.isAssignableFrom(ruleableClass), (String)"\u7ed3\u675f\u7ec4\u4ef6\u6240\u4f7f\u7528\u7684\u5904\u7406\u5668\u5fc5\u987b\u5b9e\u73b0EndRuleable\u63a5\u53e3\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6216\u8005\u81ea\u884c\u5b9e\u73b0!!", (Object[])new Object[0]);
                break;
            }
        }
    }

    private void createValidation(RuleTemplateNodeEntity ruleTemplateNode) {
        Set<RuleTemplateParamsEntity> outtpus;
        Validate.notNull((Object)((Object)ruleTemplateNode), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)ruleTemplateNode.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        ruleTemplateNode.setId(null);
        Validate.notBlank((CharSequence)ruleTemplateNode.getCreateAccount(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u521b\u5efa\u4eba\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)ruleTemplateNode.getCreateTime(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u521b\u5efa\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)ruleTemplateNode.getModifyAccount(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u66f4\u65b0\u4eba\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)ruleTemplateNode.getCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8282\u70b9\u6a21\u677f\u4e1a\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)ruleTemplateNode.getName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8282\u70b9\u6a21\u677f\u4e1a\u52a1\u540d\u79f0\uff08\u4e2d\u6587\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)ruleTemplateNode.getNodeStatus(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8282\u70b9\u53ef\u7528\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Integer type = ruleTemplateNode.getType();
        Validate.notNull((Object)type, (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8282\u70b9\u6a21\u677f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String ruleableClassValue = ruleTemplateNode.getRuleableClass();
        Validate.notBlank((CharSequence)ruleableClassValue, (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8fd0\u884c\u65f6\u89c4\u5219\u5904\u7406\u5668\u5b8c\u6574\u7c7b\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((ruleTemplateNode.getCreateAccount() == null || ruleTemplateNode.getCreateAccount().length() < 255 ? 1 : 0) != 0, (String)"\u521b\u5efa\u4eba\u8d26\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((ruleTemplateNode.getModifyAccount() == null || ruleTemplateNode.getModifyAccount().length() < 255 ? 1 : 0) != 0, (String)"\u66f4\u65b0\u4eba\u8d26\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((ruleTemplateNode.getCode() == null || ruleTemplateNode.getCode().length() < 128 ? 1 : 0) != 0, (String)"\u8282\u70b9\u6a21\u677f\u4e1a\u52a1\u7f16\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((ruleTemplateNode.getName() == null || ruleTemplateNode.getName().length() < 128 ? 1 : 0) != 0, (String)"\u8282\u70b9\u6a21\u677f\u4e1a\u52a1\u540d\u79f0\uff08\u4e2d\u6587\uff09,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((ruleableClassValue == null || ruleableClassValue.length() < 256 ? 1 : 0) != 0, (String)"\u8fd0\u884c\u65f6\u89c4\u5219\u5904\u7406\u5668\u5b8c\u6574\u7c7b\u540d,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(256)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        RuleTemplateNodeEntity currentRuleTemplateNodeEntity = this.findByCode(ruleTemplateNode.getCode());
        Validate.isTrue((currentRuleTemplateNodeEntity == null ? 1 : 0) != 0, (String)"\u8282\u70b9\u6a21\u677f\u4e1a\u52a1\u7f16\u53f7\u5df2\u5b58\u5728,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        this.validateNodeType(ruleableClassValue, type);
        Set<RuleTemplateParamsEntity> intpus = ruleTemplateNode.getInputs();
        if (!CollectionUtils.isEmpty(intpus)) {
            Set paramNames = intpus.stream().map(RuleTemplateParamsEntity::getParamName).filter(item -> StringUtils.isNotBlank((CharSequence)item)).collect(Collectors.toSet());
            Validate.isTrue((paramNames.size() == intpus.size() ? 1 : 0) != 0, (String)"\u5728\u8fdb\u884c\u8282\u70b9\u6a21\u677f\u6dfb\u52a0\u65f6\uff0c\u53d1\u73b0\u81f3\u5c11\u4e00\u7ec4\u5165\u53c2\u540d\u79f0\u91cd\u590d\uff0c\u6216\u4e3anull\u3002\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        }
        if (!CollectionUtils.isEmpty(outtpus = ruleTemplateNode.getInputs())) {
            Set paramNames = outtpus.stream().map(RuleTemplateParamsEntity::getParamName).filter(item -> StringUtils.isNotBlank((CharSequence)item)).collect(Collectors.toSet());
            Validate.isTrue((paramNames.size() == outtpus.size() ? 1 : 0) != 0, (String)"\u5728\u8fdb\u884c\u8282\u70b9\u6a21\u677f\u6dfb\u52a0\u65f6\uff0c\u53d1\u73b0\u81f3\u5c11\u4e00\u7ec4\u51fa\u53c2\u540d\u79f0\u91cd\u590d\uff0c\u6216\u4e3anull\u3002\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        }
    }

    private void createValidationParams(RuleTemplateNodeEntity currentTemplateNode, Set<RuleTemplateParamsEntity> intpus, Set<RuleTemplateParamsEntity> outpus) {
        if (!CollectionUtils.isEmpty(intpus)) {
            intpus.stream().forEach(item -> {
                item.setId(null);
                item.setType(1);
                item.setTemplateNode(currentTemplateNode);
                this.ruleTemplateParamsService.create((RuleTemplateParamsEntity)((Object)item));
            });
        }
        if (!CollectionUtils.isEmpty(outpus)) {
            outpus.stream().forEach(item -> {
                item.setId(null);
                item.setType(2);
                item.setTemplateNode(currentTemplateNode);
                this.ruleTemplateParamsService.create((RuleTemplateParamsEntity)((Object)item));
            });
        }
    }

    private void createValidationSource(RuleTemplateNodeEntity node) {
        String nodeCode = node.getCode();
        int type = node.getType();
        Integer sourceType = node.getSourceType();
        if (type != 2) {
            return;
        }
        if (sourceType == null) {
            throw new IllegalArgumentException("\u5f53\u8282\u70b9\u7ec4\u4ef6\u7c7b\u578b\u4e3a\u201c\u903b\u8f91\u7ec4\u4ef6\u201d\uff08type==2\uff09\u65f6\uff0c\u5fc5\u987b\u4e3a\u8be5\u7ec4\u4ef6\u8bbe\u5b9a\u5904\u7406\u6e90");
        }
        switch (sourceType) {
            case 1: {
                RuleSourceServicableEntity ruleSourceServicable = node.getSourceServicable();
                Validate.notNull((Object)((Object)ruleSourceServicable), (String)"\u672a\u53d1\u73b0\u4e3a\u8be5\u8282\u70b9\u6a21\u677f\u6307\u5b9a\u7684\u670d\u52a1\u6e90\u4fe1\u606f", (Object[])new Object[0]);
                ruleSourceServicable.setId(null);
                ruleSourceServicable.setServicableMethod(ruleSourceServicable.getServicableMethod());
                this.ruleSourceServicableService.create(ruleSourceServicable);
                node.setSourceServicable(ruleSourceServicable);
                node.setSourceAggregateDataView(null);
                node.setSourceScript(null);
                break;
            }
            case 2: {
                RuleSourceAggregateDataViewEntity ruleSourceAggregateDataView = node.getSourceAggregateDataView();
                Validate.notNull((Object)((Object)ruleSourceAggregateDataView), (String)"\u5728\u521b\u5efa\u7f16\u53f7\u4e3a[%s]\u7684\u8282\u70b9\u6a21\u677f\u65f6\uff0c\u672a\u53d1\u73b0\u8bbe\u5b9a\u7684\u6570\u636e\u6e90\uff08\u6570\u636e\u89c6\u56fe[\u805a\u5408]\uff09\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{nodeCode});
                String aggregateField = ruleSourceAggregateDataView.getAggregateField();
                Validate.notBlank((CharSequence)aggregateField, (String)"\u5728\u521b\u5efa\u7f16\u53f7\u4e3a[%s]\u7684\u8282\u70b9\u6a21\u677f\u65f6\uff0c\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u6570\u636e\u89c6\u56fe\u8bbe\u5b9a\u7684\u805a\u5408\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{nodeCode});
                Integer aggregateType = ruleSourceAggregateDataView.getAggregateType();
                Validate.notNull((Object)aggregateType, (String)"\u5728\u521b\u5efa\u7f16\u53f7\u4e3a[%s]\u7684\u8282\u70b9\u6a21\u677f\u65f6\uff0c\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u6570\u636e\u89c6\u56fe\u8bbe\u5b9a\u7684\u805a\u5408\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{nodeCode});
                Integer scale = ruleSourceAggregateDataView.getScale() == null ? 0 : ruleSourceAggregateDataView.getScale();
                String viewCode = ruleSourceAggregateDataView.getViewCode();
                Validate.notBlank((CharSequence)viewCode, (String)"\u5728\u521b\u5efa\u7f16\u53f7\u4e3a[%s]\u7684\u8282\u70b9\u6a21\u677f\u65f6\uff0c\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u6570\u636e\u89c6\u56fe\u8bbe\u5b9a\u7684\u6570\u636e\u89c6\u56fe\u7f16\u53f7\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{nodeCode});
                ruleSourceAggregateDataView.setId(null);
                ruleSourceAggregateDataView.setAggregateField(aggregateField);
                ruleSourceAggregateDataView.setAggregateType(aggregateType);
                ruleSourceAggregateDataView.setScale(scale);
                ruleSourceAggregateDataView.setViewCode(viewCode);
                this.ruleSourceAggregateDataViewService.create(ruleSourceAggregateDataView);
                node.setSourceServicable(null);
                node.setSourceAggregateDataView(ruleSourceAggregateDataView);
                node.setSourceScript(null);
                break;
            }
            case 3: {
                RuleSourceScriptEntity ruleSourceScript = node.getSourceScript();
                Validate.notNull((Object)((Object)ruleSourceScript), (String)"\u5728\u521b\u5efa\u7f16\u53f7\u4e3a[%s]\u7684\u8282\u70b9\u6a21\u677f\u65f6\uff0c\u672a\u53d1\u73b0\u8bbe\u5b9a\u7684\u6570\u636e\u6e90\uff08\u540e\u7aef\u811a\u672c\uff09\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{nodeCode});
                ScriptEntity currentScript = ruleSourceScript.getScript();
                Validate.notNull((Object)currentScript, (String)"\u5728\u521b\u5efa\u7f16\u53f7\u4e3a[%s]\u7684\u8282\u70b9\u6a21\u677f\u65f6\uff0c\u672a\u53d1\u73b0\u8bbe\u5b9a\u7684\u811a\u672c\u5185\u5bb9\uff0c\u5e94\u9996\u5148\u521b\u5efa/\u4fee\u6539\u811a\u672c\u5185\u5bb9\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{nodeCode});
                String scriptId = currentScript.getId();
                ScriptEntity exsitScript = this.scriptService.findById(scriptId);
                Validate.notNull((Object)exsitScript, (String)"\u5728\u521b\u5efa\u7f16\u53f7\u4e3a[%s]\u7684\u8282\u70b9\u6a21\u677f\u65f6\uff0c\u672a\u53d1\u73b0\u8bbe\u5b9a\u7684\u811a\u672c\u5185\u5bb9\uff0c\u5e94\u9996\u5148\u521b\u5efa/\u4fee\u6539\u811a\u672c\u5185\u5bb9\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{nodeCode});
                this.ruleSourceScriptService.create(ruleSourceScript);
                node.setSourceServicable(null);
                node.setSourceAggregateDataView(null);
                node.setSourceScript(ruleSourceScript);
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException("\u53d1\u73b0\u672a\u77e5\u7684\u5904\u7406\u6e90\u8bbe\u5b9a\uff0c\u8bf7\u68c0\u67e5sourceType\u7684\u4f20\u5165\u503c!!");
            }
        }
    }

    @Override
    @Transactional
    public RuleTemplateNodeEntity update(RuleTemplateNodeEntity ruleTemplateNodeEntity) {
        String account = this.findModifyor();
        ruleTemplateNodeEntity.setModifyAccount(account);
        ruleTemplateNodeEntity.setModifyTime(new Date());
        return this.updateForm(ruleTemplateNodeEntity);
    }

    @Override
    @Transactional
    public RuleTemplateNodeEntity updateForm(RuleTemplateNodeEntity ruleTemplateNodeEntity) {
        this.updateValidation(ruleTemplateNodeEntity);
        String currentId = ruleTemplateNodeEntity.getId();
        RuleTemplateNodeEntity currentRuleTemplateNodeEntity = this.ruleTemplateNodeEntityRepository.findDetailsById(currentId);
        currentRuleTemplateNodeEntity = (RuleTemplateNodeEntity)((Object)Validate.notNull((Object)((Object)currentRuleTemplateNodeEntity), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]));
        currentRuleTemplateNodeEntity.setModifyAccount(ruleTemplateNodeEntity.getModifyAccount());
        currentRuleTemplateNodeEntity.setModifyTime(ruleTemplateNodeEntity.getModifyTime());
        currentRuleTemplateNodeEntity.setName(ruleTemplateNodeEntity.getName());
        currentRuleTemplateNodeEntity.setNodeStatus(ruleTemplateNodeEntity.getNodeStatus());
        currentRuleTemplateNodeEntity.setRuleableClass(ruleTemplateNodeEntity.getRuleableClass());
        this.ruleTemplateNodeEntityRepository.saveAndFlush((Object)currentRuleTemplateNodeEntity);
        if (currentRuleTemplateNodeEntity.getSourceAggregateDataView() != null) {
            RuleSourceAggregateDataViewEntity newRuleSourceAggregateDataViewEntity = ruleTemplateNodeEntity.getSourceAggregateDataView();
            Validate.notNull((Object)((Object)newRuleSourceAggregateDataViewEntity), (String)"\u4fee\u6539\u65f6\uff08\u5904\u7406\u5668\u7c7b\u578b\u4e0d\u80fd\u4fee\u6539\uff09\uff0c\u5fc5\u987b\u8bbe\u5b9a\u6570\u636e\u89c6\u56fe\uff08\u805a\u96c6\uff09\u7684\u76f8\u5173\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            newRuleSourceAggregateDataViewEntity.setId(currentRuleTemplateNodeEntity.getSourceAggregateDataView().getId());
            this.ruleSourceAggregateDataViewService.update(newRuleSourceAggregateDataViewEntity);
        }
        if (currentRuleTemplateNodeEntity.getSourceScript() != null) {
            RuleSourceScriptEntity newRuleSourceScriptEntity = ruleTemplateNodeEntity.getSourceScript();
            Validate.notNull((Object)((Object)newRuleSourceScriptEntity), (String)"\u4fee\u6539\u65f6\uff08\u5904\u7406\u5668\u7c7b\u578b\u4e0d\u80fd\u4fee\u6539\uff09\uff0c\u5fc5\u987b\u8bbe\u5b9a\u540e\u7aef\u811a\u672c\uff08groovy\uff09\u7684\u76f8\u5173\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            newRuleSourceScriptEntity.setId(currentRuleTemplateNodeEntity.getSourceScript().getId());
            this.ruleSourceScriptService.update(newRuleSourceScriptEntity);
        }
        if (currentRuleTemplateNodeEntity.getSourceServicable() != null) {
            RuleSourceServicableEntity newRuleSourceServicableEntity = ruleTemplateNodeEntity.getSourceServicable();
            Validate.notNull((Object)((Object)newRuleSourceServicableEntity), (String)"\u4fee\u6539\u65f6\uff08\u5904\u7406\u5668\u7c7b\u578b\u4e0d\u80fd\u4fee\u6539\uff09\uff0c\u5fc5\u987b\u8bbe\u5b9a\u670d\u52a1\u6e90\u7684\u76f8\u5173\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            newRuleSourceServicableEntity.setId(currentRuleTemplateNodeEntity.getSourceServicable().getId());
            this.ruleSourceServicableService.update(newRuleSourceServicableEntity);
        }
        String templateNodeId = ruleTemplateNodeEntity.getId();
        this.ruleTemplateParamsService.deleteByTemplateNode(templateNodeId);
        Set<RuleTemplateParamsEntity> intpus = ruleTemplateNodeEntity.getInputs();
        Set<RuleTemplateParamsEntity> outpus = ruleTemplateNodeEntity.getOutputs();
        this.createValidationParams(ruleTemplateNodeEntity, intpus, outpus);
        return ruleTemplateNodeEntity;
    }

    private void updateValidation(RuleTemplateNodeEntity ruleTemplateNodeEntity) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)ruleTemplateNodeEntity.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)ruleTemplateNodeEntity.getModifyAccount(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u66f4\u65b0\u4eba\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)ruleTemplateNodeEntity.getName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u8282\u70b9\u6a21\u677f\u4e1a\u52a1\u540d\u79f0\uff08\u4e2d\u6587\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)ruleTemplateNodeEntity.getNodeStatus(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u8282\u70b9\u53ef\u7528\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)ruleTemplateNodeEntity.getRuleableClass(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u8fd0\u884c\u65f6\u89c4\u5219\u5904\u7406\u5668\u5b8c\u6574\u7c7b\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        RuleTemplateNodeEntity currentForCode = this.findByCode(ruleTemplateNodeEntity.getCode());
        Validate.isTrue((currentForCode == null || StringUtils.equals((CharSequence)currentForCode.getId(), (CharSequence)ruleTemplateNodeEntity.getId()) ? 1 : 0) != 0, (String)"\u8282\u70b9\u6a21\u677f\u4e1a\u52a1\u7f16\u53f7\u5df2\u5b58\u5728,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.isTrue((ruleTemplateNodeEntity.getModifyAccount() == null || ruleTemplateNodeEntity.getModifyAccount().length() < 255 ? 1 : 0) != 0, (String)"\u66f4\u65b0\u4eba\u8d26\u53f7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((ruleTemplateNodeEntity.getName() == null || ruleTemplateNodeEntity.getName().length() < 128 ? 1 : 0) != 0, (String)"\u8282\u70b9\u6a21\u677f\u4e1a\u52a1\u540d\u79f0\uff08\u4e2d\u6587\uff09,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((ruleTemplateNodeEntity.getRuleableClass() == null || ruleTemplateNodeEntity.getRuleableClass().length() < 256 ? 1 : 0) != 0, (String)"\u8fd0\u884c\u65f6\u89c4\u5219\u5904\u7406\u5668\u5b8c\u6574\u7c7b\u540d,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(256)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Integer type = ruleTemplateNodeEntity.getType();
        Integer sourceType = ruleTemplateNodeEntity.getSourceType();
        if (type == 2) {
            Validate.notNull((Object)sourceType, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u524d\u8282\u70b9\u6a21\u677f\u7684\u7c7b\u578b\u4e3a\u201c\u903b\u8f91\u5904\u7406\u8282\u70b9\u201d\uff0c\u90a3\u4e48\u5904\u7406\u5668\u7c7b\u578b\uff08sourceType\uff09\u5fc5\u987b\u9009\u62e9", (Object[])new Object[0]);
            if (sourceType == 1) {
                Validate.isTrue((ruleTemplateNodeEntity.getSourceServicable() != null ? 1 : 0) != 0, (String)"\u5f53\u5904\u7406\u5668\u7c7b\u578b\u4e3a\u201c\u670d\u52a1\u6e90\u201d\u65f6\uff0c\u5219\u670d\u52a1\u6e90\u540d\u79f0\u7b49\u6269\u5c55\u4fe1\u606f\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
            }
            if (sourceType == 2) {
                Validate.isTrue((ruleTemplateNodeEntity.getSourceAggregateDataView() != null ? 1 : 0) != 0, (String)"\u5f53\u5904\u7406\u5668\u7c7b\u578b\u4e3a\u201c\u6570\u636e\u89c6\u56fe\uff08\u805a\u96c6\uff09\u201d\u65f6\uff0c\u5219\u6570\u636e\u89c6\u56fe\u7f16\u53f7\u7b49\u6269\u5c55\u4fe1\u606f\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
            }
            if (sourceType == 3) {
                Validate.isTrue((ruleTemplateNodeEntity.getSourceScript() != null ? 1 : 0) != 0, (String)"\u5f53\u5904\u7406\u5668\u7c7b\u578b\u4e3a\u201c\u540e\u53f0\u811a\u672c\u201d\u65f6\uff0c\u5219\u811a\u672c\u5185\u5bb9\u7b49\u6269\u5c55\u4fe1\u606f\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
            }
        }
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        RuleTemplateNodeEntity current = this.findById(id);
        if (current != null) {
            this.ruleTemplateNodeEntityRepository.delete((Object)current);
        }
    }

    @Override
    public long countByTemplateGroup(String templateGroup) {
        if (StringUtils.isBlank((CharSequence)templateGroup)) {
            return 0L;
        }
        return this.ruleTemplateNodeEntityRepository.countByTemplateGroup(templateGroup);
    }

    @Override
    @Transactional
    public void bindTemplateGroup(String templateGroupId, String[] templateNodeIds) {
        RuleTemplateGroupEntity templateGroup = this.ruleTemplateGroupEntityService.findById(templateGroupId);
        Validate.notNull((Object)((Object)templateGroup), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u5206\u7ec4\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Set<RuleTemplateNodeEntity> nodes = this.validateOnMapping(templateNodeIds);
        for (RuleTemplateNodeEntity node : nodes) {
            Validate.isTrue((node.getNodeStatus() == 1 ? 1 : 0) != 0, (String)"\u5728\u7ed1\u5b9a\u8282\u70b9\u6a21\u677f[%s]\u65f6\uff0c\u53d1\u73b0\u8be5\u8282\u70b9\u6a21\u677f\u5df2\u88ab\u7981\u7528\uff0c\u4e0d\u80fd\u53c2\u4e0e\u7ed1\u5b9a\u8fc7\u7a0b", (Object[])new Object[]{node.getCode()});
            Validate.isTrue((templateGroup.getType().intValue() == node.getType().intValue() ? 1 : 0) != 0, (String)"\u5728\u7ed1\u5b9a\u8282\u70b9\u6a21\u677f[%s]\u662f\uff0c\u53d1\u73b0\u8be5\u8282\u70b9\u6a21\u677f\u7684\u7c7b\u578b\u548c\u6a21\u677f\u5206\u7ec4\u7684\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u4e0d\u80fd\u8fdb\u884c\u7ed1\u5b9a!!", (Object[])new Object[0]);
        }
        for (RuleTemplateNodeEntity node : nodes) {
            node.setTemplateGroup(templateGroup);
        }
        this.ruleTemplateNodeEntityRepository.saveAll(nodes);
    }

    @Override
    @Transactional
    public void rebindTemplateGroup(String templateGroupId, String[] templateNodeIds) {
        this.unbindAllTemplateGroups(templateGroupId);
        this.bindTemplateGroup(templateGroupId, templateNodeIds);
    }

    @Override
    @Transactional
    public void unbindTemplateGroups(String templateGroupId, String[] templateNodeIds) {
        RuleTemplateGroupEntity templateGroup = this.ruleTemplateGroupEntityService.findById(templateGroupId);
        Validate.notNull((Object)((Object)templateGroup), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u5206\u7ec4\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Set<RuleTemplateNodeEntity> nodes = this.validateOnMapping(templateNodeIds);
        for (RuleTemplateNodeEntity node : nodes) {
            node.setTemplateGroup(null);
        }
        this.ruleTemplateNodeEntityRepository.saveAll(nodes);
    }

    @Override
    @Transactional
    public void unbindAllTemplateGroups(String templateGroupId) {
        RuleTemplateGroupEntity templateGroup = this.ruleTemplateGroupEntityService.findById(templateGroupId);
        Validate.notNull((Object)((Object)templateGroup), (String)"\u5728\u8fdb\u884c\u89e3\u7ed1\u64cd\u4f5c\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u5206\u7ec4\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        this.ruleTemplateNodeEntityRepository.unbindAllTemplateGroups(templateGroupId);
    }

    private Set<RuleTemplateNodeEntity> validateOnMapping(String[] templateNodeIds) {
        Set<RuleTemplateNodeEntity> nodes = this.ruleTemplateNodeEntityRepository.findByIds(templateNodeIds);
        Validate.isTrue((!CollectionUtils.isEmpty(nodes) && templateNodeIds.length == nodes.size() ? 1 : 0) != 0, (String)"\u5728\u8fdb\u884c\u6a21\u677f\u5206\u7ec4\u548c\u6a21\u677f\u8282\u70b9\u7ed1\u5b9a/\u91cd\u7ed1\u5b9a/\u89e3\u7ed1\uff0c\u53d1\u73b0\u4f20\u5165\u7684\u6a21\u677fid\u7f16\u53f7\u4fe1\u606f\u4e3anull\uff0c\u6216\u8005\u672a\u5168\u90e8\u627e\u5230\u5339\u914d\u7684\u6a21\u677f\u8282\u70b9\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        return nodes;
    }

    @Override
    public RuleTemplateNodeEntity findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.ruleTemplateNodeEntityRepository.findDetailsById(id);
    }

    @Override
    public RuleTemplateNodeEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.ruleTemplateNodeEntityRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    public RuleTemplateNodeEntity findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return this.ruleTemplateNodeEntityRepository.findByCodeAndProjectName(code, ApplicationContextUtils.getProjectName());
    }

    @Override
    public RuleTemplateNodeEntity findDetailsByCode(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        return this.ruleTemplateNodeEntityRepository.findDetailsByCodeAndProjectName(code, ApplicationContextUtils.getProjectName());
    }

    @Override
    public Set<RuleTemplateNodeEntity> findByTemplateGroupAndStatus(String templateGroup, Integer nodeStatus) {
        if (StringUtils.isBlank((CharSequence)templateGroup)) {
            return null;
        }
        if (nodeStatus == null) {
            return this.ruleTemplateNodeEntityRepository.findByTemplateGroup(templateGroup);
        }
        return this.ruleTemplateNodeEntityRepository.findByTemplateGroupAndStatus(templateGroup, nodeStatus);
    }

    @Override
    public List<RuleTemplateNodeEntity> findByTemplateGroupAndStatusAndType(String templateGroup, Integer nodeStatus, Integer type) {
        return this.ruleTemplateNodeEntityRepository.findByTemplateGroupAndStatusAndType(templateGroup, nodeStatus, type);
    }
}

