/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.mars.service.init;

import com.bizunited.platform.common.service.init.InitProcessService;
import com.bizunited.platform.mars.entity.RuleTemplateNodeEntity;
import com.bizunited.platform.mars.repository.RuleTemplateNodeEntityRepository;
import com.bizunited.platform.mars.service.RuleTemplateNodeEntityService;
import java.util.Date;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="RuleTemplateNodeInitProcessService")
public class RuleTemplateNodeInitProcessService
implements InitProcessService {
    @Autowired
    private RuleTemplateNodeEntityService ruleTemplateNodeService;
    @Autowired
    private RuleTemplateNodeEntityRepository ruleTemplateNodeRepository;
    private static final String START_TEMPLATE_CODE = "defaultStart";
    private static final String END_TEMPLATE_CODE = "defaultEnd";
    private static final String CONDITION_TEMPLATE_CODE = "defaultCondition";
    private static final String DYNAMIC_SCRIPT_TEMPLATE_CODE = "dynamicScript";

    public boolean doProcess() {
        RuleTemplateNodeEntity defaultStart = this.ruleTemplateNodeService.findByCode(START_TEMPLATE_CODE);
        RuleTemplateNodeEntity defaultEnd = this.ruleTemplateNodeService.findByCode(END_TEMPLATE_CODE);
        RuleTemplateNodeEntity defaultCondition = this.ruleTemplateNodeService.findByCode(CONDITION_TEMPLATE_CODE);
        RuleTemplateNodeEntity dynamicScript = this.ruleTemplateNodeService.findByCode(DYNAMIC_SCRIPT_TEMPLATE_CODE);
        return defaultStart == null || defaultEnd == null || defaultCondition == null || dynamicScript == null;
    }

    @Transactional
    public void init() {
        RuleTemplateNodeEntity dynamicScript;
        RuleTemplateNodeEntity defaultCondition;
        RuleTemplateNodeEntity defaultEnd;
        RuleTemplateNodeEntity defaultStart = this.ruleTemplateNodeService.findByCode(START_TEMPLATE_CODE);
        if (defaultStart == null) {
            this.initDefaultStart();
        }
        if ((defaultEnd = this.ruleTemplateNodeService.findByCode(END_TEMPLATE_CODE)) == null) {
            this.initDefaultEnd();
        }
        if ((defaultCondition = this.ruleTemplateNodeService.findByCode(CONDITION_TEMPLATE_CODE)) == null) {
            this.initDefaultCondition();
        }
        if ((dynamicScript = this.ruleTemplateNodeService.findByCode(DYNAMIC_SCRIPT_TEMPLATE_CODE)) == null) {
            this.initDefaultDynamicScript();
        }
    }

    private void initDefaultStart() {
        Date currentTime = new Date();
        RuleTemplateNodeEntity ruleTemplateNode = new RuleTemplateNodeEntity();
        ruleTemplateNode.setCode(START_TEMPLATE_CODE);
        ruleTemplateNode.setName("\u9ed8\u8ba4\u5f00\u59cb");
        ruleTemplateNode.setCreateAccount("admin");
        ruleTemplateNode.setCreateTime(currentTime);
        ruleTemplateNode.setModifyAccount("admin");
        ruleTemplateNode.setModifyTime(currentTime);
        ruleTemplateNode.setNodeStatus(1);
        ruleTemplateNode.setRuleableClass("com.bizunited.platform.mars.service.rule.start.SimpleStarterRuleable");
        ruleTemplateNode.setType(4);
        this.ruleTemplateNodeRepository.save((Object)ruleTemplateNode);
    }

    private void initDefaultEnd() {
        Date currentTime = new Date();
        RuleTemplateNodeEntity ruleTemplateNode = new RuleTemplateNodeEntity();
        ruleTemplateNode.setCode(END_TEMPLATE_CODE);
        ruleTemplateNode.setName("\u9ed8\u8ba4\u7ed3\u675f");
        ruleTemplateNode.setCreateAccount("admin");
        ruleTemplateNode.setCreateTime(currentTime);
        ruleTemplateNode.setModifyAccount("admin");
        ruleTemplateNode.setModifyTime(currentTime);
        ruleTemplateNode.setNodeStatus(1);
        ruleTemplateNode.setRuleableClass("com.bizunited.platform.mars.service.rule.end.SimpleEndRuleable");
        ruleTemplateNode.setType(5);
        this.ruleTemplateNodeRepository.save((Object)ruleTemplateNode);
    }

    private void initDefaultCondition() {
        Date currentTime = new Date();
        RuleTemplateNodeEntity ruleTemplateNode = new RuleTemplateNodeEntity();
        ruleTemplateNode.setCode(CONDITION_TEMPLATE_CODE);
        ruleTemplateNode.setName("\u9ed8\u8ba4\u6761\u4ef6");
        ruleTemplateNode.setCreateAccount("admin");
        ruleTemplateNode.setCreateTime(currentTime);
        ruleTemplateNode.setModifyAccount("admin");
        ruleTemplateNode.setModifyTime(currentTime);
        ruleTemplateNode.setNodeStatus(1);
        ruleTemplateNode.setRuleableClass("com.bizunited.platform.mars.service.rule.conditions.SimpleConditionRuleable");
        ruleTemplateNode.setType(1);
        this.ruleTemplateNodeRepository.save((Object)ruleTemplateNode);
    }

    private void initDefaultDynamicScript() {
        Date currentTime = new Date();
        RuleTemplateNodeEntity ruleTemplateNode = new RuleTemplateNodeEntity();
        ruleTemplateNode.setCode(DYNAMIC_SCRIPT_TEMPLATE_CODE);
        ruleTemplateNode.setName("\u9ed8\u8ba4\u52a8\u6001\u811a\u672c\u903b\u8f91");
        ruleTemplateNode.setCreateAccount("admin");
        ruleTemplateNode.setCreateTime(currentTime);
        ruleTemplateNode.setModifyAccount("admin");
        ruleTemplateNode.setModifyTime(currentTime);
        ruleTemplateNode.setNodeStatus(1);
        ruleTemplateNode.setRuleableClass("com.bizunited.platform.mars.service.rule.processes.DynamicGroovyScriptProcessRuleable");
        ruleTemplateNode.setType(2);
        ruleTemplateNode.setSourceType(5);
        this.ruleTemplateNodeRepository.save((Object)ruleTemplateNode);
    }
}

