/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.mars.service.internal;

import com.bizunited.platform.mars.entity.RuleDefinitionEntity;
import com.bizunited.platform.mars.repository.RuleDefinitionEntityRepository;
import com.bizunited.platform.mars.service.RuleDefinitionListener;
import com.bizunited.platform.mars.service.RuleDefinitionService;
import com.bizunited.platform.mars.service.internal.AbstractMarsSaveableService;
import com.bizunited.platform.venus.common.service.file.VenusFileService;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service(value="RuleDefinitionEntityServiceImpl")
public class RuleDefinitionEntityServiceImpl
extends AbstractMarsSaveableService
implements RuleDefinitionService {
    @Autowired
    private RuleDefinitionEntityRepository ruleDefinitionEntityRepository;
    @Autowired(required=false)
    private List<RuleDefinitionListener> ruleDefinitionListeners;
    @Autowired
    private VenusFileService venusFileService;

    @Override
    @Transactional
    public RuleDefinitionEntity create(RuleDefinitionEntity ruleDefinitionEntity) {
        String account = this.findCreator();
        ruleDefinitionEntity.setCreateAccount(account);
        ruleDefinitionEntity.setCreateTime(new Date());
        ruleDefinitionEntity.setModifyAccount(account);
        ruleDefinitionEntity.setModifyTime(new Date());
        RuleDefinitionEntity current = this.createForm(ruleDefinitionEntity);
        return current;
    }

    @Override
    @Transactional
    public RuleDefinitionEntity createForm(RuleDefinitionEntity ruleDefinitionEntity) {
        this.createValidation(ruleDefinitionEntity);
        this.ruleDefinitionEntityRepository.save((Object)ruleDefinitionEntity);
        if (this.ruleDefinitionListeners != null) {
            this.ruleDefinitionListeners.forEach(item -> item.onDefinitionModify(ruleDefinitionEntity));
        }
        return ruleDefinitionEntity;
    }

    private void createValidation(RuleDefinitionEntity ruleDefinitionEntity) {
        Validate.notNull((Object)((Object)ruleDefinitionEntity), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)ruleDefinitionEntity.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        ruleDefinitionEntity.setId(null);
        Validate.notBlank((CharSequence)ruleDefinitionEntity.getCreateAccount(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u521b\u5efa\u4eba\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)ruleDefinitionEntity.getCreateTime(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u521b\u5efa\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)ruleDefinitionEntity.getModifyAccount(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u66f4\u65b0\u4eba\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)ruleDefinitionEntity.getCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u89c4\u5219\u5b9a\u4e49\u4e1a\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)ruleDefinitionEntity.getCverion(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u89c4\u5219\u5b9a\u4e49\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)ruleDefinitionEntity.getDesc(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u89c4\u5219\u5b9a\u4e49\u7528\u9014\u8bf4\u660e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)ruleDefinitionEntity.getTemplateFilename(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u89c4\u5219\u5b9a\u4e49\u7528\u9014\u8bf4\u660e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)ruleDefinitionEntity.getTemplateRelativepath(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u524d\u7aef\u56fe\u5f62\u5316\u5c55\u793a\u7ed3\u6784\u63cf\u8ff0\u6587\u4ef6\u7684\u76f8\u5bf9\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((ruleDefinitionEntity.getCreateAccount() == null || ruleDefinitionEntity.getCreateAccount().length() < 255 ? 1 : 0) != 0, (String)"\u521b\u5efa\u4eba\u8d26\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((ruleDefinitionEntity.getModifyAccount() == null || ruleDefinitionEntity.getModifyAccount().length() < 255 ? 1 : 0) != 0, (String)"\u66f4\u65b0\u4eba\u8d26\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((ruleDefinitionEntity.getCode() == null || ruleDefinitionEntity.getCode().length() < 128 ? 1 : 0) != 0, (String)"\u89c4\u5219\u5b9a\u4e49\u4e1a\u52a1\u7f16\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((ruleDefinitionEntity.getCverion() == null || ruleDefinitionEntity.getCverion().length() < 128 ? 1 : 0) != 0, (String)"\u89c4\u5219\u5b9a\u4e49\u7248\u672c,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((ruleDefinitionEntity.getDesc() == null || ruleDefinitionEntity.getDesc().length() < 512 ? 1 : 0) != 0, (String)"\u89c4\u5219\u5b9a\u4e49\u7528\u9014\u8bf4\u660e,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(512)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((ruleDefinitionEntity.getTemplateFilename() == null || ruleDefinitionEntity.getTemplateFilename().length() < 256 ? 1 : 0) != 0, (String)"\u89c4\u5219\u5b9a\u4e49\u7528\u9014\u8bf4\u660e,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(256)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((ruleDefinitionEntity.getTemplateRelativepath() == null || ruleDefinitionEntity.getTemplateRelativepath().length() < 256 ? 1 : 0) != 0, (String)"\u524d\u7aef\u56fe\u5f62\u5316\u5c55\u793a\u7ed3\u6784\u63cf\u8ff0\u6587\u4ef6\u7684\u76f8\u5bf9\u8def\u5f84,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(256)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public RuleDefinitionEntity update(RuleDefinitionEntity ruleDefinitionEntity) {
        String account = this.findModifyor();
        ruleDefinitionEntity.setModifyAccount(account);
        ruleDefinitionEntity.setModifyTime(new Date());
        RuleDefinitionEntity current = this.updateForm(ruleDefinitionEntity);
        return current;
    }

    @Override
    @Transactional
    public RuleDefinitionEntity updateForm(RuleDefinitionEntity ruleDefinitionEntity) {
        this.updateValidation(ruleDefinitionEntity);
        String currentId = ruleDefinitionEntity.getId();
        Optional op_currentRuleDefinitionEntity = this.ruleDefinitionEntityRepository.findById(currentId);
        RuleDefinitionEntity currentRuleDefinitionEntity = op_currentRuleDefinitionEntity.orElse(null);
        Validate.notNull((Object)((Object)currentRuleDefinitionEntity), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]);
        currentRuleDefinitionEntity.setModifyAccount(ruleDefinitionEntity.getModifyAccount());
        currentRuleDefinitionEntity.setModifyTime(ruleDefinitionEntity.getModifyTime());
        currentRuleDefinitionEntity.setDesc(ruleDefinitionEntity.getDesc());
        currentRuleDefinitionEntity.setTemplateFilename(ruleDefinitionEntity.getTemplateFilename());
        currentRuleDefinitionEntity.setTemplateRelativepath(ruleDefinitionEntity.getTemplateRelativepath());
        this.ruleDefinitionEntityRepository.saveAndFlush((Object)currentRuleDefinitionEntity);
        if (this.ruleDefinitionListeners != null) {
            this.ruleDefinitionListeners.forEach(item -> item.onDefinitionModify(currentRuleDefinitionEntity));
        }
        return currentRuleDefinitionEntity;
    }

    private void updateValidation(RuleDefinitionEntity ruleDefinitionEntity) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)ruleDefinitionEntity.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)ruleDefinitionEntity.getModifyAccount(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u66f4\u65b0\u4eba\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)ruleDefinitionEntity.getDesc(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u89c4\u5219\u5b9a\u4e49\u7528\u9014\u8bf4\u660e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)ruleDefinitionEntity.getTemplateFilename(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u89c4\u5219\u5b9a\u4e49\u7528\u9014\u8bf4\u660e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)ruleDefinitionEntity.getTemplateRelativepath(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u524d\u7aef\u56fe\u5f62\u5316\u5c55\u793a\u7ed3\u6784\u63cf\u8ff0\u6587\u4ef6\u7684\u76f8\u5bf9\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((ruleDefinitionEntity.getModifyAccount() == null || ruleDefinitionEntity.getModifyAccount().length() < 255 ? 1 : 0) != 0, (String)"\u66f4\u65b0\u4eba\u8d26\u53f7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((ruleDefinitionEntity.getDesc() == null || ruleDefinitionEntity.getDesc().length() < 512 ? 1 : 0) != 0, (String)"\u89c4\u5219\u5b9a\u4e49\u7528\u9014\u8bf4\u660e,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(512)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((ruleDefinitionEntity.getTemplateFilename() == null || ruleDefinitionEntity.getTemplateFilename().length() < 256 ? 1 : 0) != 0, (String)"\u89c4\u5219\u5b9a\u4e49\u7528\u9014\u8bf4\u660e,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(256)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((ruleDefinitionEntity.getTemplateRelativepath() == null || ruleDefinitionEntity.getTemplateRelativepath().length() < 256 ? 1 : 0) != 0, (String)"\u524d\u7aef\u56fe\u5f62\u5316\u5c55\u793a\u7ed3\u6784\u63cf\u8ff0\u6587\u4ef6\u7684\u76f8\u5bf9\u8def\u5f84,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(256)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        RuleDefinitionEntity current = this.findById(id);
        if (current != null) {
            this.ruleDefinitionEntityRepository.delete((Object)current);
        }
        if (this.ruleDefinitionListeners != null) {
            this.ruleDefinitionListeners.forEach(item -> item.onDefinitionDelete(current));
        }
    }

    @Override
    public RuleDefinitionEntity findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.ruleDefinitionEntityRepository.findDetailsById(id);
    }

    @Override
    public RuleDefinitionEntity findDetailsByCodeAndVersion(String code, String cversion) {
        if (StringUtils.isBlank((CharSequence)code) || StringUtils.isBlank((CharSequence)cversion)) {
            return null;
        }
        return this.ruleDefinitionEntityRepository.findDetailsByCodeAndVersion(code, cversion);
    }

    @Override
    public RuleDefinitionEntity findByCodeAndVersion(String code, String cversion) {
        if (StringUtils.isBlank((CharSequence)code) || StringUtils.isBlank((CharSequence)cversion)) {
            return null;
        }
        return this.ruleDefinitionEntityRepository.findByCodeAndVersion(code, cversion);
    }

    @Override
    public RuleDefinitionEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.ruleDefinitionEntityRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    public List<RuleDefinitionEntity> findAll() {
        return this.ruleDefinitionEntityRepository.findAll(Sort.by((String[])new String[]{"createTime"}));
    }

    @Override
    public String findContentByCodeAndVersion(String code, String version) {
        if (StringUtils.isBlank((CharSequence)code) || StringUtils.isBlank((CharSequence)version)) {
            return null;
        }
        RuleDefinitionEntity ruleDefinition = this.ruleDefinitionEntityRepository.findByCodeAndVersion(code, version);
        if (ruleDefinition == null) {
            return null;
        }
        byte[] content = this.venusFileService.readFileContent(ruleDefinition.getTemplateRelativepath(), ruleDefinition.getTemplateFilename());
        if (content == null || content.length == 0) {
            return null;
        }
        return new String(content, StandardCharsets.UTF_8);
    }
}

