package com.bizunited.platform.mars.entity;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.core.entity.ScriptEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;

import io.swagger.annotations.ApiModel;

/**
 * 规则定义节点的处理源——groovy动态脚本信息
 * @Author yinwenjie
 * @Date  2020-06-20
 */
@Entity
@Table(name = "engine_rule_source_script")
@ApiModel(value = "RuleNodeParamsEntity" , description="规则定义节点的处理源——groovy动态脚本信息")
@org.hibernate.annotations.Table(appliesTo = "engine_rule_source_script" , comment = "规则定义节点的处理源——groovy动态脚本信息")
public class RuleSourceScriptEntity  extends UuidEntity {
  /**
   * 
   */
  private static final long serialVersionUID = -1478018741105342470L;
  
  /**
   * 标准的后端脚本信息
   */
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="script_id" , nullable=false, columnDefinition = "varchar(255) COMMENT '标准的后端脚本信息'")
  @SaturnColumn(description="标准的后端脚本信息")
  private ScriptEntity script;

  public ScriptEntity getScript() {
    return script;
  }

  public void setScript(ScriptEntity script) {
    this.script = script;
  }
}
