package com.bizunited.platform.mars.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 时间节点定义信息
 * @author yinwenjie
 */
@Entity
@Table(name = "engine_timer_rule_nodes")
@ApiModel(value = "RuleTimerNodeEntity" , description="时间节点定义信息")
@org.hibernate.annotations.Table(appliesTo = "engine_timer_rule_nodes" , comment = "时间节点定义信息")
public class RuleTimerNodeEntity extends UuidEntity {
  /**
   * 
   */
  private static final long serialVersionUID = -2495327454729570988L;
  /**
   * 从当前规则节点将要开始执行的时间开始计算，需要暂停的时间数（配合单位使用，最小时间为秒）
   */
  @ApiModelProperty(name = "timerCount", value = "需要暂停的时间数（配合单位使用，最小时间为秒）")
  @Column(name = "timer_count" , nullable = false)
  @SaturnColumn(description = "锁表达式")
  private int timerCount = 0;
  /**
   * 时间单位：1：秒；2：分；3：小时；4：天；其它值无效
   */
  @ApiModelProperty(name = "timeUnit", value = "时间单位：1：秒；2：分；3：小时；4：天；其它值无效")
  @Column(name = "time_unit" , nullable = false)
  @SaturnColumn(description = "时间单位：1：秒；2：分；3：小时；4：天；其它值无效")
  private int timeUnit;
  
  public int getTimerCount() {
    return timerCount;
  }
  public void setTimerCount(int timerCount) {
    this.timerCount = timerCount;
  }
  public int getTimeUnit() {
    return timeUnit;
  }
  public void setTimeUnit(int timeUnit) {
    this.timeUnit = timeUnit;
  } 
}
