/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.mars.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.common.util.JsonUtils;
import com.bizunited.platform.mars.entity.RuleConcurrentAggregationEntity;
import com.bizunited.platform.mars.entity.RuleDefinitionEntity;
import com.bizunited.platform.mars.entity.RuleLockNodeEntity;
import com.bizunited.platform.mars.entity.RuleNodeEntity;
import com.bizunited.platform.mars.entity.RuleNodeNextsEntity;
import com.bizunited.platform.mars.entity.RuleNodeParamsEntity;
import com.bizunited.platform.mars.entity.RuleTemplateNodeEntity;
import com.bizunited.platform.mars.entity.RuleTemplateParamsEntity;
import com.bizunited.platform.mars.entity.RuleTimerNodeEntity;
import com.bizunited.platform.mars.repository.RuleDefinitionEntityRepository;
import com.bizunited.platform.mars.service.RuleConcurrentAggregationService;
import com.bizunited.platform.mars.service.RuleDefinitionListener;
import com.bizunited.platform.mars.service.RuleDefinitionService;
import com.bizunited.platform.mars.service.RuleLockNodeService;
import com.bizunited.platform.mars.service.RuleNodeNextsService;
import com.bizunited.platform.mars.service.RuleNodeParamsService;
import com.bizunited.platform.mars.service.RuleNodeService;
import com.bizunited.platform.mars.service.RuleTemplateNodeService;
import com.bizunited.platform.mars.service.RuleTimerNodeService;
import com.bizunited.platform.mars.service.internal.AbstractMarsSaveableService;
import com.bizunited.platform.venus.common.service.file.VenusFileService;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="RuleDefinitionEntityServiceImpl")
public class RuleDefinitionServiceImpl
extends AbstractMarsSaveableService
implements RuleDefinitionService {
    @Autowired
    private RuleDefinitionEntityRepository ruleDefinitionEntityRepository;
    @Autowired(required=false)
    private List<RuleDefinitionListener> ruleDefinitionListeners;
    @Autowired
    private VenusFileService venusFileService;
    @Autowired
    private RuleTemplateNodeService ruleTemplateNodeService;
    @Autowired
    private RuleNodeService ruleNodeService;
    @Autowired
    private RuleNodeParamsService ruleNodeParamsService;
    @Autowired
    private RuleNodeNextsService ruleNodeNextsService;
    @Autowired
    private RuleLockNodeService ruleLockNodeService;
    @Autowired
    private RuleConcurrentAggregationService ruleConcurrentAggregationService;
    @Autowired
    private RuleTimerNodeService ruleTimerNodeService;
    @Autowired
    private PlatformContext platformContext;
    private static final Logger LOGGER = LoggerFactory.getLogger(RuleDefinitionServiceImpl.class);

    @Override
    @Transactional
    public RuleDefinitionEntity create(RuleDefinitionEntity definition, JSONObject layoutContent, Map<String, Object> params) {
        byte[] fileContent;
        Validate.notNull((Object)((Object)definition), (String)"\u521b\u5efa\u89c4\u5219\u5b9a\u4e49\u65f6\uff0c\u5b9a\u4e49\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        Validate.notNull((Object)layoutContent, (String)"\u89c4\u5219\u5b9a\u4e49\u7ed3\u6784\u5185\u5bb9\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        try {
            fileContent = layoutContent.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        Validate.isTrue((fileContent != null && fileContent.length > 0 ? 1 : 0) != 0, (String)"\u521b\u5efa\u89c4\u5219\u5b9a\u4e49\u65f6\uff0c\u9875\u9762\u5e03\u5c40\u6587\u4ef6\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        String code = definition.getCode();
        String version = definition.getCverion();
        String desc = definition.getDesc();
        String id = definition.getId();
        Validate.isTrue((id == null ? 1 : 0) != 0, (String)"\u521b\u5efa\u89c4\u5219\u5b9a\u4e49\u65f6\uff0c\u5176id\u4fe1\u606f\u4e0d\u80fd\u6709\u503c!!", (Object[])new Object[0]);
        definition.setId(null);
        Validate.notBlank((CharSequence)desc, (String)"\u521b\u5efa\u89c4\u5219\u5b9a\u4e49\u65f6\uff0c\u5176desc\u63cf\u8ff0\u4fe1\u606f\u5fc5\u987b\u6709\u503c!!", (Object[])new Object[0]);
        RuleDefinitionEntity exsitRuleDefinition = this.findByCodeAndVersion(code, version);
        Validate.isTrue((exsitRuleDefinition == null ? 1 : 0) != 0, (String)"\u521b\u5efa\u89c4\u5219\u5b9a\u4e49\u65f6\uff0c\u6307\u5b9a\u7684code\u3010%s\u3011\u548cversion\u3010%s\u3011\u5df2\u7ecf\u5b58\u5728\u4e8e\u89c4\u5219\u5b9a\u4e49\u4e2d\uff0c\u8bf7\u91cd\u65b0\u8bbe\u5b9a", (Object[])new Object[]{code, version});
        Set<RuleNodeEntity> nodes = definition.getNodes();
        Validate.isTrue((!CollectionUtils.isEmpty(nodes) ? 1 : 0) != 0, (String)"\u521b\u5efa\u89c4\u5219\u5b9a\u4e49\u65f6\uff0c\u672a\u53d1\u73b0\u4efb\u4f55\u89c4\u5219\u8282\u70b9\u5b9a\u4e49\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        long startNodeCount = nodes.stream().filter(item -> item.getType() == 4).count();
        long endNodeCount = nodes.stream().filter(item -> item.getType() == 5).count();
        Validate.isTrue((startNodeCount == 1L ? 1 : 0) != 0, (String)"\u89c4\u5219\u5b9a\u4e49\u4e2d\u5fc5\u987b\u6709\u4e14\u53ea\u6709\u4e00\u4e2a\u5f00\u59cb\u8282\u70b9\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((endNodeCount >= 1L ? 1 : 0) != 0, (String)"\u89c4\u5219\u5b9a\u4e49\u4e2d\u5fc5\u987b\u81f3\u5c11\u6709\u4e00\u4e2a\u7ed3\u675f\u8282\u70b9\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String relativePath = this.saveScriptContent();
        String fileName = StringUtils.join((Object[])new String[]{code, "_", version, ".txt"});
        this.venusFileService.saveFile(relativePath, fileName, fileName, fileContent);
        definition.setTemplateFilename(fileName);
        definition.setTemplateRelativepath(relativePath);
        if (params != null && !params.isEmpty()) {
            definition.setExtParams(JsonUtils.obj2JsonString(params));
        }
        RuleDefinitionEntity newDefinition = this.create(definition);
        definition.setId(newDefinition.getId());
        HashMap<String, RuleNodeEntity> nodeCodeMapping = new HashMap<String, RuleNodeEntity>();
        nodes.stream().forEach(node -> {
            this.validateAndSaveRuleNode(definition, (RuleNodeEntity)((Object)node), (Map<String, RuleNodeEntity>)nodeCodeMapping);
            this.validateAndSaveRuleNodeParams(definition, (RuleNodeEntity)((Object)node), (Map<String, RuleNodeEntity>)nodeCodeMapping);
        });
        this.validateAndSaveNexts(nodes, nodeCodeMapping);
        return definition;
    }

    private void validateAndSaveRuleNode(RuleDefinitionEntity ruleDefinition, RuleNodeEntity node, Map<String, RuleNodeEntity> nodeCodeMapping) {
        String nodeId = node.getId();
        Validate.isTrue((nodeId == null ? 1 : 0) != 0, (String)"\u521b\u5efa\u89c4\u5219\u8282\u70b9\u5b9a\u4e49\u65f6\uff0c\u5176id\u4fe1\u606f\u4e0d\u80fd\u6709\u503c!!", (Object[])new Object[0]);
        node.setId(null);
        String nodeCode = node.getCode();
        RuleTemplateNodeEntity templateNode = node.getTemplateNode();
        Validate.notNull((Object)((Object)templateNode), (String)"\u521b\u5efa\u89c4\u5219\u8282\u70b9\u5b9a\u4e49\u65f6\uff0c\u5176\u4f7f\u7528\u7684\u8282\u70b9\u6a21\u677f\u5fc5\u987b\u6307\u5b9a", (Object[])new Object[0]);
        String templateNodeId = templateNode.getId();
        Validate.notBlank((CharSequence)templateNodeId, (String)"\u521b\u5efa\u89c4\u5219\u8282\u70b9\u5b9a\u4e49\u65f6\uff0c\u5176\u4f7f\u7528\u7684\u8282\u70b9\u6a21\u677f\u7f16\u53f7\u9700\u8981\u6307\u5b9a", (Object[])new Object[0]);
        RuleTemplateNodeEntity exsitTemplateNode = this.ruleTemplateNodeService.findDetailsById(templateNodeId);
        Validate.notNull((Object)((Object)exsitTemplateNode), (String)"\u521b\u5efa\u89c4\u5219\u8282\u70b9\u5b9a\u4e49\u65f6\uff0c\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u8282\u70b9\u6a21\u677f\u4fe1\u606f[%s]", (Object[])new Object[]{templateNodeId});
        Validate.isTrue((templateNode.getNodeStatus() == 1 ? 1 : 0) != 0, (String)"\u521b\u5efa\u89c4\u5219\u8282\u70b9\u5b9a\u4e49\u65f6\uff0c\u53d1\u73b0\u81f3\u5c11\u4e00\u4e2a\u8282\u70b9\u6a21\u677f\u72b6\u6001\u4e0d\u53ef\u7528\uff0c\u8bf7\u68c0\u67e5\uff01\uff01", (Object[])new Object[0]);
        RuleNodeEntity exsitRuleNode = this.ruleNodeService.findByCode(nodeCode);
        Validate.isTrue((exsitRuleNode == null ? 1 : 0) != 0, (String)"\u521b\u5efa\u89c4\u5219\u8282\u70b9\u5b9a\u4e49\u65f6\uff0c\u53d1\u73b0\u91cd\u590d\u7684\u8282\u70b9\u5b9a\u4e49code\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Integer type = node.getType();
        Validate.notNull((Object)type, (String)"\u521b\u5efa\u89c4\u5219\u8282\u70b9\u5b9a\u4e49\u65f6\uff0c\u8282\u70b9\u7c7b\u578b\u5fc5\u987b\u586b\u5199", (Object[])new Object[0]);
        Validate.isTrue((type == exsitTemplateNode.getType() ? 1 : 0) != 0, (String)"\u521b\u5efa\u89c4\u5219\u5b9a\u4e49\u65f6\uff0c\u53d1\u73b0\u81f3\u5c11\u4e00\u4e2a\u8282\u70b9\u5b9a\u4e49\u7684\u7c7b\u578b\u548c\u5bf9\u5e94\u7684\u6a21\u677f\u8282\u70b9\u4e2d\u7684\u4e0d\u4e00\u81f4", (Object[])new Object[0]);
        if (type == 2) {
            Integer sourceType = node.getSourceType();
            Validate.notNull((Object)sourceType, (String)"\u521b\u5efa\u89c4\u5219\u8282\u70b9\u5b9a\u4e49\u65f6\uff0c\u8282\u70b9\u5de5\u4f5c\u903b\u8f91\u7c7b\u578b\u5fc5\u987b\u586b\u5199", (Object[])new Object[0]);
            Validate.isTrue((sourceType == exsitTemplateNode.getSourceType() ? 1 : 0) != 0, (String)"\u521b\u5efa\u89c4\u5219\u5b9a\u4e49\u65f6\uff0c\u53d1\u73b0\u81f3\u5c11\u4e00\u4e2a\u8282\u70b9\u5b9a\u4e49\u7684\u6570\u636e\u6e90\u7c7b\u578b\u548c\u5bf9\u5e94\u7684\u6a21\u677f\u8282\u70b9\u4e2d\u7684\u4e0d\u4e00\u81f4", (Object[])new Object[0]);
        } else if (type == 3) {
            RuleLockNodeEntity ruleLockNode = node.getRuleLockExt();
            Validate.notNull((Object)((Object)ruleLockNode), (String)"\u9501\u8282\u70b9\u5b9a\u4e49[%s]\uff0c\u6ca1\u6709\u53d1\u73b0\u4f20\u5165\u7684\u6269\u5c55\u4fe1\u606fruleLockExt\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{nodeCode});
            ruleLockNode = this.ruleLockNodeService.create(ruleLockNode);
        } else if (type == 6) {
            RuleConcurrentAggregationEntity ruleConcurrentAggregation = node.getRuleAggregationExt();
            Validate.notNull((Object)((Object)ruleConcurrentAggregation), (String)"A/B\u5e76\u884c\u5206\u652f\u5904\u7406\u8282\u70b9\u5b9a\u4e49[%s]\uff0c\u6ca1\u6709\u53d1\u73b0\u4f20\u5165\u7684\u6269\u5c55\u4fe1\u606fruleAggregationExt \uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{nodeCode});
            ruleConcurrentAggregation = this.ruleConcurrentAggregationService.create(ruleConcurrentAggregation);
        } else if (type == 8) {
            RuleTimerNodeEntity ruleTimerNode = node.getRuleTimerExt();
            Validate.notNull((Object)((Object)ruleTimerNode), (String)"\u8ba1\u65f6\u8282\u70b9\u5b9a\u4e49[%s]\uff0c\u6ca1\u6709\u53d1\u73b0\u4f20\u5165\u7684\u6269\u5c55\u4fe1\u606fruleTimerExt\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{nodeCode});
            Validate.isTrue((ruleTimerNode.getTimerCount() >= 0 ? 1 : 0) != 0, (String)"\u6682\u505c\u7684\u65f6\u95f4\u6570\u4e0d\u80fd\u4e3a\u8d1f\u6570\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            Validate.isTrue((ruleTimerNode.getTimeUnit() > 0 && ruleTimerNode.getTimeUnit() < 5 ? 1 : 0) != 0, (String)"\u6682\u505c\u7684\u65f6\u95f4\u5355\u4f4d\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            ruleTimerNode = this.ruleTimerNodeService.create(ruleTimerNode);
        } else if (type == 9) {
            Integer extType = node.getExtType();
            Validate.notNull((Object)extType, (String)"\u521b\u5efa\u4e1a\u52a1\u6269\u5c55\u8282\u70b9\u65f6\uff0c\u8282\u70b9\u6269\u5c55\u7c7b\u578b\u5fc5\u987b\u586b\u5199", (Object[])new Object[0]);
        } else if (type == 10) {
            Integer extType = node.getExtType();
            Validate.notNull((Object)extType, (String)"\u521b\u5efaA/B\u5e76\u884c\u6269\u5c55\u8282\u70b9\u65f6\uff0c\u8282\u70b9\u6269\u5c55\u7c7b\u578b\u5fc5\u987b\u586b\u5199", (Object[])new Object[0]);
            RuleConcurrentAggregationEntity ruleConcurrentAggregation = node.getRuleAggregationExt();
            Validate.notNull((Object)((Object)ruleConcurrentAggregation), (String)"\u81ea\u5b9a\u4e49A/B\u5e76\u884c\u5206\u652f\u5904\u7406\u8282\u70b9\u5b9a\u4e49[%s]\uff0c\u6ca1\u6709\u53d1\u73b0\u4f20\u5165\u7684\u6269\u5c55\u4fe1\u606fruleAggregationExt \uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{nodeCode});
            ruleConcurrentAggregation = this.ruleConcurrentAggregationService.create(ruleConcurrentAggregation);
        } else if (type == 11) {
            Integer extType = node.getExtType();
            Validate.notNull((Object)extType, (String)"\u521b\u5efa\u6761\u4ef6\u5224\u5b9a\u6269\u5c55\u8282\u70b9\u65f6\uff0c\u8282\u70b9\u6269\u5c55\u7c7b\u578b\u5fc5\u987b\u586b\u5199", (Object[])new Object[0]);
        }
        node.setDefinition(ruleDefinition);
        this.ruleNodeService.create(node);
        nodeCodeMapping.put(nodeCode, node);
    }

    private void validateAndSaveRuleNodeParams(RuleDefinitionEntity ruleDefinition, RuleNodeEntity node, Map<String, RuleNodeEntity> nodeCodeMapping) {
        long count;
        String templateNodeId = node.getTemplateNode().getId();
        RuleTemplateNodeEntity templateNode = this.ruleTemplateNodeService.findDetailsById(templateNodeId);
        Set<RuleTemplateParamsEntity> inputTemplates = templateNode.getInputs();
        Set<RuleTemplateParamsEntity> outputTemplates = templateNode.getOutputs();
        Set<Object> inputs = node.getInputs() == null ? new HashSet() : node.getInputs();
        Set<Object> outputs = node.getOutputs() == null ? new HashSet() : node.getOutputs();
        Set inputTemplateParamNames = inputs.stream().map(RuleNodeParamsEntity::getTemplateParamName).collect(Collectors.toSet());
        Set outputTemplateParamNames = outputs.stream().map(RuleNodeParamsEntity::getTemplateParamName).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(inputTemplates)) {
            count = inputTemplates.stream().filter(item -> inputTemplateParamNames.contains(item.getParamName())).count();
            Validate.isTrue((count == (long)inputTemplates.size() && inputs.size() == inputTemplates.size() ? 1 : 0) != 0, (String)"\u81f3\u5c11\u4e00\u4e2a\u8282\u70b9\u6a21\u677f\u8bbe\u5b9a\u7684\u5165\u53c2\uff0c\u5728\u8282\u70b9\u5b9a\u4e49\u4e2d\u5e76\u6ca1\u6709\u7ed1\u5b9a\u4e0a\u4e0b\u6587\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        }
        if (!CollectionUtils.isEmpty(outputTemplates)) {
            count = outputTemplates.stream().filter(item -> outputTemplateParamNames.contains(item.getParamName())).count();
            Validate.isTrue((count == (long)outputTemplates.size() && outputs.size() == outputTemplates.size() ? 1 : 0) != 0, (String)"\u81f3\u5c11\u4e00\u4e2a\u8282\u70b9\u6a21\u677f\u8bbe\u5b9a\u7684\u51fa\u53c2\uff0c\u5728\u8282\u70b9\u5b9a\u4e49\u4e2d\u5e76\u6ca1\u6709\u7ed1\u5b9a\u4e0a\u4e0b\u6587\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        }
        inputs.stream().forEach(inputItem -> {
            String paramDesc = inputItem.getParamDesc();
            String paramType = inputItem.getParamType();
            String templateParamName = inputItem.getTemplateParamName();
            inputItem.setType(1);
            inputItem.setNode(node);
            Validate.notBlank((CharSequence)paramDesc, (String)"\u5165\u53c2\u6570\u63cf\u8ff0\u4fe1\u606f\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)templateParamName, (String)"\u5165\u53c2\u3010\u5b9e\u53c2\u3011-\u6a21\u677f\u53c2\u6570\u540d\u4fe1\u606f\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
            Validate.notNull((Object)paramType, (String)"\u5165\u53c2\u6570\u7c7b\u578b\u4fe1\u606f\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
            this.ruleNodeParamsService.create((RuleNodeParamsEntity)((Object)inputItem));
        });
        outputs.stream().forEach(outputItem -> {
            String paramDesc = outputItem.getParamDesc();
            String paramType = outputItem.getParamType();
            String templateParamName = outputItem.getTemplateParamName();
            outputItem.setType(2);
            outputItem.setNode(node);
            Validate.notBlank((CharSequence)paramDesc, (String)"\u51fa\u53c2\u6570\u63cf\u8ff0\u4fe1\u606f\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)templateParamName, (String)"\u51fa\u53c2\u3010\u5b9e\u53c2\u3011-\u6a21\u677f\u53c2\u6570\u540d\u4fe1\u606f\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
            Validate.notNull((Object)paramType, (String)"\u51fa\u53c2\u6570\u7c7b\u578b\u4fe1\u606f\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
            this.ruleNodeParamsService.create((RuleNodeParamsEntity)((Object)outputItem));
        });
    }

    private void validateAndSaveNexts(Set<RuleNodeEntity> nodes, Map<String, RuleNodeEntity> nodeCodeMapping) {
        nodes.stream().forEach(node -> {
            Integer type = node.getType();
            String nodeCode = node.getCode();
            Set<Object> nexts = node.getNexts() == null ? new HashSet() : node.getNexts();
            Set normalNexts = nexts.stream().filter(item -> item.getLineType() == 1).collect(Collectors.toSet());
            RuleNodeEntity fromNode = (RuleNodeEntity)((Object)((Object)nodeCodeMapping.get(node.getCode())));
            String fromNodeCode = fromNode.getCode();
            switch (type) {
                case 1: 
                case 11: {
                    Validate.isTrue((normalNexts.size() >= 1 ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u7f16\u53f7\u4e3a[%s]\u7684\u8282\u70b9\u5b9a\u4e49,\u5176\u81f3\u5c11\u6709\u4e00\u4e2a\uff08\u6b63\u5e38\u7684\uff09\u540e\u7eed\u5206\u652f\u8fde\u7ebf\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{nodeCode});
                    break;
                }
                case 5: {
                    Validate.isTrue((normalNexts == null || normalNexts.size() == 0 ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u7f16\u53f7\u4e3a[%s]\u7684\u8282\u70b9\u5b9a\u4e49,\u5176\u4e0d\u80fd\u6709\u4efb\u4f55\uff08\u6b63\u5e38\u7684\uff09\u540e\u7eed\u5206\u652f\u8fde\u7ebf\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{nodeCode});
                    break;
                }
                case 6: 
                case 10: {
                    Validate.isTrue((normalNexts.size() >= 2 ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u7f16\u53f7\u4e3a[%s]\u7684\u8282\u70b9\u5b9a\u4e49,\u5176\u81f3\u5c11\u6709\u4e24\u4e2a\uff08\u6b63\u5e38\u7684\uff09\u540e\u7eed\u5206\u652f\u8fde\u7ebf\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{nodeCode});
                    break;
                }
                default: {
                    Validate.isTrue((normalNexts.size() == 1 ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u7f16\u53f7\u4e3a[%s]\u7684\u8282\u70b9\u5b9a\u4e49,\u5176\u5fc5\u987b\u6709\u4e00\u4e2a\uff08\u6b63\u5e38\u7684\uff09\u540e\u7eed\u5206\u652f\u8fde\u7ebf\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{nodeCode});
                }
            }
            nexts.stream().forEach(nextItem -> {
                String conditions = nextItem.getConditions();
                String exceptions = nextItem.getExceptions();
                Integer lineType = nextItem.getLineType();
                Integer sort = nextItem.getSort() == null ? 100 : nextItem.getSort();
                String toNodeCode = nextItem.getToNodeCode();
                String bindParam = nextItem.getBindParam();
                RuleNodeEntity toNode = (RuleNodeEntity)((Object)((Object)((Object)nodeCodeMapping.get(toNodeCode))));
                Validate.notNull((Object)((Object)toNode), (String)"\u6307\u5b9a\u7684\u76ee\u6807\u5b9a\u4e49\u8282\u70b9[%s]\u672a\u88ab\u53d1\u73b0\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{toNodeCode});
                RuleNodeNextsEntity exsitNext = this.ruleNodeNextsService.findByFromAndTo(fromNodeCode, toNodeCode);
                Validate.isTrue((exsitNext == null ? 1 : 0) != 0, (String)"\u6307\u5b9a\u7684\u8fde\u7ebf\u4ece[%s]\u5230[%s]\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u8fde\u63a5\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{fromNodeCode, toNodeCode});
                RuleNodeNextsEntity ruleNext = new RuleNodeNextsEntity();
                ruleNext.setConditions(conditions);
                ruleNext.setExceptions(exceptions);
                ruleNext.setFromNode(fromNode);
                ruleNext.setToNode(toNode);
                ruleNext.setLineType(lineType);
                ruleNext.setSort(sort);
                ruleNext.setBindParam(bindParam);
                this.ruleNodeNextsService.create(ruleNext);
            });
        });
    }

    private RuleDefinitionEntity create(RuleDefinitionEntity ruleDefinitionEntity) {
        String account = this.findCreator();
        ruleDefinitionEntity.setCreateAccount(account);
        ruleDefinitionEntity.setCreateTime(new Date());
        ruleDefinitionEntity.setModifyAccount(account);
        ruleDefinitionEntity.setModifyTime(new Date());
        ruleDefinitionEntity.setProjectName(this.platformContext.getAppName());
        RuleDefinitionEntity current = this.createForm(ruleDefinitionEntity);
        return current;
    }

    private RuleDefinitionEntity createForm(RuleDefinitionEntity ruleDefinitionEntity) {
        this.createValidation(ruleDefinitionEntity);
        this.ruleDefinitionEntityRepository.save((Object)ruleDefinitionEntity);
        if (this.ruleDefinitionListeners != null) {
            this.ruleDefinitionListeners.forEach(item -> item.onDefinitionModify(ruleDefinitionEntity));
        }
        return ruleDefinitionEntity;
    }

    private String saveScriptContent() {
        Date nowDate = new Date();
        String folderName = new SimpleDateFormat("yyyyMMdd").format(nowDate);
        String relativePath = StringUtils.join((Object[])new Serializable[]{"/ruleengine/", folderName, "/", Integer.valueOf(new Random().nextInt(100) % 10)});
        return relativePath;
    }

    private void createValidation(RuleDefinitionEntity ruleDefinitionEntity) {
        Validate.notNull((Object)((Object)ruleDefinitionEntity), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)ruleDefinitionEntity.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        ruleDefinitionEntity.setId(null);
        Validate.notBlank((CharSequence)ruleDefinitionEntity.getCreateAccount(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u521b\u5efa\u4eba\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)ruleDefinitionEntity.getCreateTime(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u521b\u5efa\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)ruleDefinitionEntity.getModifyAccount(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u66f4\u65b0\u4eba\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)ruleDefinitionEntity.getCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u89c4\u5219\u5b9a\u4e49\u4e1a\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)ruleDefinitionEntity.getCverion(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u89c4\u5219\u5b9a\u4e49\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)ruleDefinitionEntity.getDesc(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u89c4\u5219\u5b9a\u4e49\u7528\u9014\u8bf4\u660e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)ruleDefinitionEntity.getTemplateFilename(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u89c4\u5219\u5b9a\u4e49\u7528\u9014\u8bf4\u660e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)ruleDefinitionEntity.getTemplateRelativepath(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u524d\u7aef\u56fe\u5f62\u5316\u5c55\u793a\u7ed3\u6784\u63cf\u8ff0\u6587\u4ef6\u7684\u76f8\u5bf9\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((ruleDefinitionEntity.getCreateAccount() == null || ruleDefinitionEntity.getCreateAccount().length() < 255 ? 1 : 0) != 0, (String)"\u521b\u5efa\u4eba\u8d26\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((ruleDefinitionEntity.getModifyAccount() == null || ruleDefinitionEntity.getModifyAccount().length() < 255 ? 1 : 0) != 0, (String)"\u66f4\u65b0\u4eba\u8d26\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((ruleDefinitionEntity.getCode() == null || ruleDefinitionEntity.getCode().length() < 128 ? 1 : 0) != 0, (String)"\u89c4\u5219\u5b9a\u4e49\u4e1a\u52a1\u7f16\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((ruleDefinitionEntity.getCverion() == null || ruleDefinitionEntity.getCverion().length() < 128 ? 1 : 0) != 0, (String)"\u89c4\u5219\u5b9a\u4e49\u7248\u672c,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((ruleDefinitionEntity.getDesc() == null || ruleDefinitionEntity.getDesc().length() < 512 ? 1 : 0) != 0, (String)"\u89c4\u5219\u5b9a\u4e49\u7528\u9014\u8bf4\u660e,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(512)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((ruleDefinitionEntity.getTemplateFilename() == null || ruleDefinitionEntity.getTemplateFilename().length() < 256 ? 1 : 0) != 0, (String)"\u89c4\u5219\u5b9a\u4e49\u7528\u9014\u8bf4\u660e,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(256)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((ruleDefinitionEntity.getTemplateRelativepath() == null || ruleDefinitionEntity.getTemplateRelativepath().length() < 256 ? 1 : 0) != 0, (String)"\u524d\u7aef\u56fe\u5f62\u5316\u5c55\u793a\u7ed3\u6784\u63cf\u8ff0\u6587\u4ef6\u7684\u76f8\u5bf9\u8def\u5f84,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(256)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public RuleDefinitionEntity update(RuleDefinitionEntity definition, JSONObject layoutContent, Map<String, Object> params) {
        byte[] fileContent;
        Validate.notNull((Object)((Object)definition), (String)"\u4fee\u6539\u89c4\u5219\u5b9a\u4e49\u65f6\uff0c\u5b9a\u4e49\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        Validate.notNull((Object)layoutContent, (String)"\u89c4\u5219\u5b9a\u4e49\u7ed3\u6784\u5185\u5bb9\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        try {
            fileContent = layoutContent.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        Validate.isTrue((fileContent != null && fileContent.length > 0 ? 1 : 0) != 0, (String)"\u4fee\u6539\u89c4\u5219\u5b9a\u4e49\u65f6\uff0c\u9875\u9762\u5e03\u5c40\u6587\u4ef6\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        String desc = definition.getDesc();
        String definitionId = definition.getId();
        Validate.notBlank((CharSequence)definitionId, (String)"\u4fee\u6539\u89c4\u5219\u5b9a\u4e49\u65f6\uff0c\u5176id\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)desc, (String)"\u4fee\u6539\u89c4\u5219\u5b9a\u4e49\u65f6\uff0c\u5176desc\u63cf\u8ff0\u4fe1\u606f\u4e0d\u80fd\u6ca1\u6709\u503c!!", (Object[])new Object[0]);
        RuleDefinitionEntity exsitRuleDefinition = this.findById(definitionId);
        Validate.notNull((Object)((Object)exsitRuleDefinition), (String)"\u4fee\u6539\u89c4\u5219\u5b9a\u4e49\u65f6\uff0c\u6307\u5b9a\u7684\u89c4\u5219\u5b9a\u4e49\u672a\u627e\u5230[%s]\uff0c\u8bf7\u91cd\u65b0\u8bbe\u5b9a", (Object[])new Object[]{definitionId});
        Set<RuleNodeEntity> nodes = definition.getNodes();
        long startNodeCount = nodes.stream().filter(item -> item.getType() == 4).count();
        long endNodeCount = nodes.stream().filter(item -> item.getType() == 5).count();
        Validate.isTrue((startNodeCount == 1L ? 1 : 0) != 0, (String)"\u89c4\u5219\u5b9a\u4e49\u4e2d\u5fc5\u987b\u6709\u4e14\u53ea\u6709\u4e00\u4e2a\u5f00\u59cb\u8282\u70b9\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((endNodeCount >= 1L ? 1 : 0) != 0, (String)"\u89c4\u5219\u5b9a\u4e49\u4e2d\u5fc5\u987b\u81f3\u5c11\u6709\u4e00\u4e2a\u7ed3\u675f\u8282\u70b9\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Set<RuleNodeEntity> ruleNodes = this.ruleNodeService.findDetailsByDefinition(definitionId);
        if (!CollectionUtils.isEmpty(ruleNodes)) {
            Set<String> ruleNodeIds = ruleNodes.stream().map(UuidEntity::getId).collect(Collectors.toSet());
            this.ruleLockNodeService.deleteByIds(ruleNodeIds.toArray(new String[0]));
            this.ruleConcurrentAggregationService.deleteByIds(ruleNodeIds.toArray(new String[0]));
            this.ruleTimerNodeService.deleteByIds(ruleNodeIds.toArray(new String[0]));
            this.ruleNodeParamsService.deleteByRuleNodes(ruleNodeIds.toArray(new String[0]));
            this.ruleNodeNextsService.deleteByFromNodes(ruleNodeIds.toArray(new String[0]));
            this.ruleNodeService.deleteByIds(ruleNodeIds.toArray(new String[0]));
        }
        String relativePath = this.saveScriptContent();
        String fileName = StringUtils.join((Object[])new String[]{exsitRuleDefinition.getCode(), "_", exsitRuleDefinition.getCverion(), ".txt"});
        this.venusFileService.saveFile(relativePath, fileName, fileName, fileContent);
        definition.setTemplateFilename(fileName);
        definition.setTemplateRelativepath(relativePath);
        if (params != null && !params.isEmpty()) {
            definition.setExtParams(JsonUtils.obj2JsonString(params));
        }
        this.update(definition);
        HashMap<String, RuleNodeEntity> nodeCodeMapping = new HashMap<String, RuleNodeEntity>();
        nodes.stream().forEach(node -> {
            node.setId(null);
            if (node.getInputs() != null) {
                node.getInputs().stream().forEach(item -> item.setId(null));
            }
            if (node.getOutputs() != null) {
                node.getOutputs().stream().forEach(item -> item.setId(null));
            }
            if (node.getNexts() != null) {
                node.getNexts().stream().forEach(item -> item.setId(null));
            }
            if (node.getRuleAggregationExt() != null) {
                node.getRuleAggregationExt().setId(null);
            }
            if (node.getRuleLockExt() != null) {
                node.getRuleLockExt().setId(null);
            }
            if (node.getRuleTimerExt() != null) {
                node.getRuleTimerExt().setId(null);
            }
            this.validateAndSaveRuleNode(definition, (RuleNodeEntity)((Object)node), (Map<String, RuleNodeEntity>)nodeCodeMapping);
            this.validateAndSaveRuleNodeParams(definition, (RuleNodeEntity)((Object)node), (Map<String, RuleNodeEntity>)nodeCodeMapping);
        });
        this.validateAndSaveNexts(nodes, nodeCodeMapping);
        if (this.ruleDefinitionListeners != null) {
            this.ruleDefinitionListeners.forEach(item -> item.onDefinitionModify(definition));
        }
        return definition;
    }

    private RuleDefinitionEntity update(RuleDefinitionEntity ruleDefinitionEntity) {
        String account = this.findModifyor();
        ruleDefinitionEntity.setModifyAccount(account);
        ruleDefinitionEntity.setModifyTime(new Date());
        RuleDefinitionEntity current = this.updateForm(ruleDefinitionEntity);
        return current;
    }

    private RuleDefinitionEntity updateForm(RuleDefinitionEntity ruleDefinitionEntity) {
        this.updateValidation(ruleDefinitionEntity);
        String currentId = ruleDefinitionEntity.getId();
        Optional op_currentRuleDefinitionEntity = this.ruleDefinitionEntityRepository.findById(currentId);
        RuleDefinitionEntity currentRuleDefinitionEntity = op_currentRuleDefinitionEntity.orElse(null);
        Validate.notNull((Object)((Object)currentRuleDefinitionEntity), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]);
        currentRuleDefinitionEntity.setModifyAccount(ruleDefinitionEntity.getModifyAccount());
        currentRuleDefinitionEntity.setModifyTime(ruleDefinitionEntity.getModifyTime());
        currentRuleDefinitionEntity.setDesc(ruleDefinitionEntity.getDesc());
        currentRuleDefinitionEntity.setTemplateFilename(ruleDefinitionEntity.getTemplateFilename());
        currentRuleDefinitionEntity.setTemplateRelativepath(ruleDefinitionEntity.getTemplateRelativepath());
        currentRuleDefinitionEntity.setReturnParam(ruleDefinitionEntity.getReturnParam());
        this.ruleDefinitionEntityRepository.saveAndFlush((Object)currentRuleDefinitionEntity);
        return currentRuleDefinitionEntity;
    }

    private void updateValidation(RuleDefinitionEntity ruleDefinitionEntity) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)ruleDefinitionEntity.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)ruleDefinitionEntity.getModifyAccount(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u66f4\u65b0\u4eba\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)ruleDefinitionEntity.getDesc(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u89c4\u5219\u5b9a\u4e49\u7528\u9014\u8bf4\u660e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)ruleDefinitionEntity.getTemplateFilename(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u89c4\u5219\u5b9a\u4e49\u7528\u9014\u8bf4\u660e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)ruleDefinitionEntity.getTemplateRelativepath(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u524d\u7aef\u56fe\u5f62\u5316\u5c55\u793a\u7ed3\u6784\u63cf\u8ff0\u6587\u4ef6\u7684\u76f8\u5bf9\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((ruleDefinitionEntity.getModifyAccount() == null || ruleDefinitionEntity.getModifyAccount().length() < 255 ? 1 : 0) != 0, (String)"\u66f4\u65b0\u4eba\u8d26\u53f7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((ruleDefinitionEntity.getDesc() == null || ruleDefinitionEntity.getDesc().length() < 512 ? 1 : 0) != 0, (String)"\u89c4\u5219\u5b9a\u4e49\u7528\u9014\u8bf4\u660e,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(512)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((ruleDefinitionEntity.getTemplateFilename() == null || ruleDefinitionEntity.getTemplateFilename().length() < 256 ? 1 : 0) != 0, (String)"\u89c4\u5219\u5b9a\u4e49\u7528\u9014\u8bf4\u660e,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(256)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((ruleDefinitionEntity.getTemplateRelativepath() == null || ruleDefinitionEntity.getTemplateRelativepath().length() < 256 ? 1 : 0) != 0, (String)"\u524d\u7aef\u56fe\u5f62\u5316\u5c55\u793a\u7ed3\u6784\u63cf\u8ff0\u6587\u4ef6\u7684\u76f8\u5bf9\u8def\u5f84,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(256)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        RuleDefinitionEntity current = this.findById(id);
        if (current != null) {
            this.ruleDefinitionEntityRepository.delete((Object)current);
        }
        if (this.ruleDefinitionListeners != null) {
            this.ruleDefinitionListeners.forEach(item -> item.onDefinitionDelete(current));
        }
    }

    @Override
    public RuleDefinitionEntity findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.ruleDefinitionEntityRepository.findDetailsById(id);
    }

    @Override
    public RuleDefinitionEntity findDetailsByCodeAndVersion(String code, String cversion) {
        if (StringUtils.isBlank((CharSequence)code) || StringUtils.isBlank((CharSequence)cversion)) {
            return null;
        }
        return this.ruleDefinitionEntityRepository.findDetailsByCodeAndVersion(code, cversion);
    }

    @Override
    public RuleDefinitionEntity findByCodeAndVersion(String code, String cversion) {
        if (StringUtils.isBlank((CharSequence)code) || StringUtils.isBlank((CharSequence)cversion)) {
            return null;
        }
        return this.ruleDefinitionEntityRepository.findByCodeAndVersion(code, cversion);
    }

    @Override
    public RuleDefinitionEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.ruleDefinitionEntityRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    public Page<RuleDefinitionEntity> findByConditions(Pageable pageable, String code, String desc) {
        Pageable cPageable = pageable;
        if (cPageable == null) {
            cPageable = PageRequest.of((int)0, (int)50);
        }
        return this.ruleDefinitionEntityRepository.findByConditions(cPageable, code, desc);
    }

    @Override
    public List<RuleDefinitionEntity> findAll() {
        return this.ruleDefinitionEntityRepository.findAll(Sort.by((String[])new String[]{"createTime"}));
    }

    @Override
    public String findContentByCodeAndVersion(String code, String version) {
        if (StringUtils.isBlank((CharSequence)code) || StringUtils.isBlank((CharSequence)version)) {
            return null;
        }
        RuleDefinitionEntity ruleDefinition = this.ruleDefinitionEntityRepository.findByCodeAndVersion(code, version);
        if (ruleDefinition == null) {
            return null;
        }
        byte[] content = this.venusFileService.readFileContent(ruleDefinition.getTemplateRelativepath(), ruleDefinition.getTemplateFilename());
        if (content == null || content.length == 0) {
            return null;
        }
        return new String(content, StandardCharsets.UTF_8);
    }

    @Override
    public RuleDefinitionEntity updateVersion(RuleDefinitionEntity definition, String newVersion, JSONObject layoutContent) {
        Validate.notNull((Object)((Object)definition), (String)"\u89c4\u5219\u5b9a\u4e49\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)definition.getCode(), (String)"\u89c4\u5219\u5b9a\u4e49\u7f16\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)definition.getCverion(), (String)"\u89c4\u5219\u5b9a\u4e49\u7248\u672c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)newVersion, (String)"\u89c4\u5219\u5b9a\u4e49\u5347\u7ea7\u7248\u672c\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.isTrue((!definition.getCverion().equals(newVersion) ? 1 : 0) != 0, (String)"\u5347\u7ea7\u7248\u672c\u53f7\u4e0e\u539f\u7248\u672c\u53f7\u76f8\u540c\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        RuleDefinitionEntity ruleDefinitionEntity = this.ruleDefinitionEntityRepository.findByCodeAndVersion(definition.getCode(), definition.getCverion());
        Validate.notNull((Object)((Object)ruleDefinitionEntity), (String)"\u539f\u5347\u7ea7\u89c4\u5219\u5b9a\u4e49\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        definition.setId(null);
        definition.setCverion(newVersion);
        definition.setExtParams(ruleDefinitionEntity.getExtParams());
        RuleDefinitionEntity result = this.create(definition, layoutContent, null);
        return result;
    }
}

