package com.bizunited.platform.mars.repository;

import java.lang.String;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import com.bizunited.platform.mars.entity.RuleConcurrentAggregationEntity;

/**
 * RuleConcurrentAggregationEntity业务模型的数据库方法支持
 * @author saturn
 */
@Repository("_RuleConcurrentAggregationEntityRepository")
public interface RuleConcurrentAggregationEntityRepository
    extends
      JpaRepository<RuleConcurrentAggregationEntity, String>
      ,JpaSpecificationExecutor<RuleConcurrentAggregationEntity>
  {

  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   * */
  @Query("select distinct ruleConcurrentAggregationEntity from RuleConcurrentAggregationEntity ruleConcurrentAggregationEntity "
      + " where ruleConcurrentAggregationEntity.id=:id ")
  public RuleConcurrentAggregationEntity findDetailsById(@Param("id") String id);



}