package com.bizunited.platform.mars.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 锁节点定义的信息
 * @author yinwenjie
 */
@Entity
@Table(name = "engine_lock_rule_nodes")
@ApiModel(value = "RuleLockNodeEntity" , description="锁节点定义的信息")
@org.hibernate.annotations.Table(appliesTo = "engine_lock_rule_nodes" , comment = "锁节点定义的信息")
public class RuleLockNodeEntity extends UuidEntity {
  /**
   * 
   */
  private static final long serialVersionUID = -5439498782054704168L;
  /**
   * 锁表达式,例如"${object.value}_a_b"，其中object代表上下文中的某个对象
   */
  @ApiModelProperty(name = "expression", value = "锁表达式")
  @Column(name = "expression" , length = 128 , nullable = false , columnDefinition = "varchar(128) COMMENT '锁表达式'")
  @SaturnColumn(description = "锁表达式")
  private String expression;
  public String getExpression() {
    return expression;
  }
  public void setExpression(String expression) {
    this.expression = expression;
  }
}
