package com.bizunited.platform.mars.entity;

import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import org.hibernate.annotations.Where;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 规则定义中的一个具体节点定义
 * @author yinwenjie
 * @since V2.2.1
 */
@Entity
@Table(name = "engine_rule_nodes")
@ApiModel(value = "RuleNodeEntity" , description="规则定义节点")
@org.hibernate.annotations.Table(appliesTo = "engine_rule_nodes" , comment = "规则定义节点")
public class RuleNodeEntity extends UuidEntity {
  /**
   *
   */
  private static final long serialVersionUID = 3218912718719020074L;
  /**
   * 节点定义业务编号
   */
  @ApiModelProperty(name = "code", value = "节点定义业务编号")
  @Column(name = "code" , length = 128 , nullable = false  , unique = true, columnDefinition = "varchar(128) COMMENT '节点定义业务编号'")
  @SaturnColumn(description = "节点定义业务编号" , updatable = false)
  private String code;
  /**
   * 该节点定义使用的节点模板，这个必须要，例如【该人员近两月销售额】，就是一个节点模板
   */
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="template_node_id" , nullable=false, columnDefinition = "varchar(255) COMMENT '该节点定义使用的节点模板'")
  @SaturnColumn(description="该节点定义使用的节点模板")
  private RuleTemplateNodeEntity templateNode;
  /**
   * 节点定义所属的规则定义
   */
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="definition_id" , nullable=true, columnDefinition = "varchar(255) COMMENT '规则工作节点所属的规则模板'")
  @SaturnColumn(description="规则工作节点所属的规则模板")
  private RuleDefinitionEntity definition;
  /**
   * 可能记录的锁组件定义关联信息，当type == 3
   */
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="rule_lock_node_id" , nullable=true, columnDefinition = "varchar(255) COMMENT '可能记录的锁组件定义关联信息'")
  @SaturnColumn(description="可能记录的锁组件定义关联信息")
  private RuleLockNodeEntity ruleLockExt;
  /**
   * 可能记录的A/B并行分支组件定义关联信息，当type == 6
   */
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="rule_aggregation_node_id" , nullable=true, columnDefinition = "varchar(255) COMMENT '可能记录的A/B并行分支组件定义关联信息'")
  @SaturnColumn(description="可能记录的A/B并行分支组件定义关联信息")
  private RuleConcurrentAggregationEntity ruleAggregationExt;
  /**
   * 可能记录的计时组件定义关联信息，当type == 8
   */
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="rule_timer_node_id" , nullable=true, columnDefinition = "varchar(255) COMMENT '可能记录的计时组件定义关联信息'")
  @SaturnColumn(description="可能记录的计时组件定义关联信息")
  private RuleTimerNodeEntity ruleTimerExt;
  /**
   * 节点定义类型
   * 1:判定组件、2、逻辑组件、3、锁组件，4、开始组件、5、结束组件、
   * 6、A/B并发组件、7、并发汇聚组件、8、时间控制组件、9、业务扩展组件、10、自定义A/B并发组件、11、自定义判定组件
   */
  @ApiModelProperty(name = "type", value = "节点定义类型")
  @Column(name = "type" , nullable = false , columnDefinition = "int(11)  COMMENT '节点定义类型'")
  @SaturnColumn(description = "节点定义类型" , updatable = false)
  private Integer type;
  /**
   * 只要是逻辑组件（节点）一定需要处理源，其余类型的节点组件不一定需要</br>
   * 节点定义工作逻辑类型：
   * 1、服务源；2、数据视图（聚集）、3、后台脚本；4、数据权限？；5、全动态脚本；6、数据视图（集合）
   */
  @ApiModelProperty(name = "source_type", value = "节点定义工作逻辑类型")
  @Column(name = "source_type" , nullable = true , columnDefinition = "int(11)  COMMENT '节点定义工作逻辑类型'")
  @SaturnColumn(description = "节点定义工作逻辑类型" , updatable = false)
  private Integer sourceType;
  /**
   * 当type为9的时候，该节点模板为业务扩展节点。(显示来运最好来源于数据字典)
   * 这种情况下需要设置业务扩展节点的类型（不能设置为1，该值已被使用）
   */
  @ApiModelProperty(name = "extType", value = "当type为9的时候，该节点模板为业务扩展节点。")
  @Column(name = "ext_type" , nullable = true , columnDefinition = "int(11)  COMMENT '当type为9的时候，该节点模板为业务扩展节点。'")
  @SaturnColumn(description = "当type为9的时候，该节点模板为业务扩展节点。")
  private Integer extType;
  /**
   * 该节点定义对应的规则运行实例号(如果该节点对应的模板使用了[动态]表单引擎)
   */
  @ApiModelProperty(name = "instanceId", value = "该节点定义对应的规则运行实例号")
  @Column(name = "instance_id" , length = 255 , nullable = true , columnDefinition = "varchar(255) COMMENT '该节点定义对应的规则运行实例号'")
  @SaturnColumn(description = "该节点定义对应的规则运行实例号")
  private String instanceId;
  /**
   * 该节点定义对应的业务单据ID（如果该节点对应的模板使用了用户自定义页面）
   */
  @ApiModelProperty(name = "taskCode", value = "该节点定义对应的业务单据ID")
  @Column(name = "task_code" , length = 255 , nullable = true , columnDefinition = "varchar(255) COMMENT '该节点定义对应的业务单据ID'")
  @SaturnColumn(description = "该节点定义对应的业务单据ID")
  private String taskCode;
  /**
   * 入参信息(可能没有，也可能有多个)
   */
  @SaturnColumn(description = "入参信息")
  @Where(clause = "type=1")
  @ApiModelProperty("入参信息")
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "node")
  private Set<RuleNodeParamsEntity> inputs;
  /**
   * 出参信息(可能没有，也可能有多个)
   */
  @SaturnColumn(description = "出参信息")
  @Where(clause = "type=2")
  @ApiModelProperty("出参信息")
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "node")
  private Set<RuleNodeParamsEntity> outputs;
  /**
   * 该处理节点的连线信息（以连线的起始节点为标准）
   */
  @SaturnColumn(description = "该处理节点的连线信息")
  @ApiModelProperty("该处理节点的连线信息")
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "fromNode")
  private Set<RuleNodeNextsEntity> nexts;
  /**
   * 节点描述
   */
  @SaturnColumn(description = "该处理节点的描述信息")
  @ApiModelProperty(name="nodeDesc",value = "该处理节点的描述信息")
  @Column(name = "node_desc" , length = 255 , nullable = true , columnDefinition = "varchar(255) COMMENT '该处理节点的描述信息'")
  private String nodeDesc;

  /**
   * 节点编辑状态 true、已编辑 false、未编辑
   */
  @ApiModelProperty(name = "edited", value = "节点编辑状态 true、已编辑 false、未编辑")
  @Column(name = "edited" , nullable = false , columnDefinition = "bit(1)  COMMENT '节点编辑状态 true、已编辑 false、未编辑'")
  @SaturnColumn(description = "节点编辑状态 true、已编辑 false、未编辑")
  private boolean edited;

  public Set<RuleNodeNextsEntity> getNexts() {
    return nexts;
  }
  public void setNexts(Set<RuleNodeNextsEntity> nexts) {
    this.nexts = nexts;
  }
  public RuleTemplateNodeEntity getTemplateNode() {
    return templateNode;
  }
  public void setTemplateNode(RuleTemplateNodeEntity templateNode) {
    this.templateNode = templateNode;
  }
  public RuleDefinitionEntity getDefinition() {
    return definition;
  }
  public void setDefinition(RuleDefinitionEntity definition) {
    this.definition = definition;
  }
  public Integer getType() {
    return type;
  }
  public void setType(Integer type) {
    this.type = type;
  }
  public Integer getSourceType() {
    return sourceType;
  }
  public void setSourceType(Integer sourceType) {
    this.sourceType = sourceType;
  }
  public String getCode() {
    return code;
  }
  public void setCode(String code) {
    this.code = code;
  }
  public Set<RuleNodeParamsEntity> getInputs() {
    return inputs;
  }
  public void setInputs(Set<RuleNodeParamsEntity> inputs) {
    this.inputs = inputs;
  }
  public Set<RuleNodeParamsEntity> getOutputs() {
    return outputs;
  }
  public void setOutputs(Set<RuleNodeParamsEntity> outputs) {
    this.outputs = outputs;
  }
  public RuleLockNodeEntity getRuleLockExt() {
    return ruleLockExt;
  }
  public void setRuleLockExt(RuleLockNodeEntity ruleLockExt) {
    this.ruleLockExt = ruleLockExt;
  }
  public RuleConcurrentAggregationEntity getRuleAggregationExt() {
    return ruleAggregationExt;
  }
  public void setRuleAggregationExt(RuleConcurrentAggregationEntity ruleAggregationExt) {
    this.ruleAggregationExt = ruleAggregationExt;
  }
  public RuleTimerNodeEntity getRuleTimerExt() {
    return ruleTimerExt;
  }
  public void setRuleTimerExt(RuleTimerNodeEntity ruleTimerExt) {
    this.ruleTimerExt = ruleTimerExt;
  }
  public String getInstanceId() {
    return instanceId;
  }
  public void setInstanceId(String instanceId) {
    this.instanceId = instanceId;
  }
  public String getTaskCode() {
    return taskCode;
  }
  public void setTaskCode(String taskCode) {
    this.taskCode = taskCode;
  }
  public Integer getExtType() {
    return extType;
  }
  public void setExtType(Integer extType) {
    this.extType = extType;
  }
  public String getNodeDesc() {
    return nodeDesc;
  }
  public void setNodeDesc(String nodeDesc) {
    this.nodeDesc = nodeDesc;
  }
  public boolean isEdited() {
    return edited;
  }
  public void setEdited(boolean edited) {
    this.edited = edited;
  }
}