/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.mars.repository.internal;

import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.mars.entity.RuleDefinitionEntity;
import com.bizunited.platform.mars.repository.internal.RuleDefinitionEntityRepositoryCustom;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository(value="RuleDefinitionEntityRepositoryImpl")
public class RuleDefinitionEntityRepositoryImpl
implements RuleDefinitionEntityRepositoryCustom {
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private PlatformContext platformContext;

    @Override
    public Page<RuleDefinitionEntity> findByConditions(Pageable pageable, String code, String desc) {
        StringBuilder hql = new StringBuilder("select distinct rd from RuleDefinitionEntity rd where 1=1 ");
        StringBuilder countHql = new StringBuilder("select count(*) from RuleDefinitionEntity rd where 1 = 1 ");
        StringBuilder condition = new StringBuilder();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        condition.append(" AND rd.projectName=:projectName ");
        parameters.put("projectName", this.platformContext.getAppName());
        if (StringUtils.isNotBlank((CharSequence)code)) {
            condition.append(" AND rd.code = :code ");
            parameters.put("code", code);
        }
        if (StringUtils.isNotBlank((CharSequence)desc)) {
            condition.append(" AND rd.desc like CONCAT('%',:desc,'%') ");
            parameters.put("desc", desc);
        }
        hql.append((CharSequence)condition);
        hql.append(" order by rd.cverion , rd.createTime ");
        countHql.append((CharSequence)condition);
        Query query = this.entityManager.createQuery(hql.toString());
        Query countQuery = this.entityManager.createQuery(countHql.toString());
        parameters.forEach((k, v) -> {
            query.setParameter(k, v);
            countQuery.setParameter(k, v);
        });
        query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
        query.setMaxResults(pageable.getPageSize());
        List resutls = query.getResultList();
        long count = (Long)countQuery.getResultList().get(0);
        return new PageImpl(resutls, pageable, count);
    }
}

