package com.bizunited.platform.mars.repository;
import com.bizunited.platform.mars.entity.RuleNodeNextsEntity;
import java.lang.String;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * RuleNodeNextsEntity业务模型的数据库方法支持
 * @author saturn
 */
@Repository("_RuleNodeNextsEntityRepository")
public interface RuleNodeNextsEntityRepository
    extends
      JpaRepository<RuleNodeNextsEntity, String>
      ,JpaSpecificationExecutor<RuleNodeNextsEntity>
  {
  /**
   * 按照该连接线对应的开始信息（起始节点）进行详情查询（包括关联信息）
   * @param fromNode 该连接线对应的开始信息（起始节点）
   * */
  @Query("from RuleNodeNextsEntity rn "
      + " left join fetch rn.fromNode fn "
      + " left join fetch rn.toNode tn "
       + " where fn.id = :id")
  public Set<RuleNodeNextsEntity> findDetailsByFromNode(@Param("id") String id);
  /**
   * 按照该连接线对应的开始信息（目标节点）进行详情查询（包括关联信息）
   * @param toNode 该连接线对应的开始信息（目标节点）
   * */
  @Query("select ruleNodeNextsEntity from RuleNodeNextsEntity ruleNodeNextsEntity "
      + " left join fetch ruleNodeNextsEntity.fromNode ruleNodeNextsEntity_fromNode "
      + " left join fetch ruleNodeNextsEntity.toNode ruleNodeNextsEntity_toNode "
       + " where ruleNodeNextsEntity_toNode.id = :id")
  public Set<RuleNodeNextsEntity> findDetailsByToNode(@Param("id") String id);

  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   * */
  @Query("select ruleNodeNextsEntity from RuleNodeNextsEntity ruleNodeNextsEntity "
      + " left join fetch ruleNodeNextsEntity.fromNode ruleNodeNextsEntity_fromNode "
      + " left join fetch ruleNodeNextsEntity.toNode ruleNodeNextsEntity_toNode "
      + " where ruleNodeNextsEntity.id=:id ")
  public RuleNodeNextsEntity findDetailsById(@Param("id") String id);

  /**
   * 根据连线的起始节点定义和目标节点定义，查询连线信息
   * @param fromCode 指定的起始节点定义业务编号
   * @param toCode 指定的目标节点定义业务编号
   * @return
   */
  @Query("from RuleNodeNextsEntity rn where rn.fromNode.code = :fromCode and rn.toNode.code = :toCode ")
  public RuleNodeNextsEntity findByFromAndTo(@Param("fromCode") String fromCode , @Param("toCode") String toCode);
  /**
   * 按照指定的连线起始节点的编号，删除相关的连线信息
   * @param fromNodes
   */
  @Modifying
  @Query(value="delete from engine_rule_node_next where engine_rule_node_next.from_node_id in (:fromNodes)  " , nativeQuery = true)
  public void deleteByFromNodes(@Param("fromNodes") String fromNodes[]);
}