package com.bizunited.platform.mars.service.internal;

import com.bizunited.platform.core.annotations.NebulaServiceMethod;
import com.bizunited.platform.core.annotations.NebulaServiceMethod.ScopeType;
import com.bizunited.platform.core.annotations.ServiceMethodParam;
import com.bizunited.platform.mars.entity.RuleSourceDataViewEntity;
import com.bizunited.platform.mars.repository.RuleSourceDataViewEntityRepository;
import com.bizunited.platform.mars.service.RuleSourceDataViewService;

import java.lang.Override;
import java.lang.String;
import java.util.Optional;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * RuleSourceDataViewEntity业务模型的服务层接口实现
 * @author saturn
 */
@Service("RuleSourceDataViewServiceImpl")
public class RuleSourceDataViewServiceImpl implements RuleSourceDataViewService { 
  @Autowired
  private RuleSourceDataViewEntityRepository ruleSourceDataViewEntityRepository;
  @Transactional
  @Override
  public RuleSourceDataViewEntity create(RuleSourceDataViewEntity ruleSourceDataViewEntity) { 
    RuleSourceDataViewEntity current = this.createForm(ruleSourceDataViewEntity);
    //==================================================== 
    //    这里可以处理第三方系统调用（或特殊处理过程）
    //====================================================
    return current;
  } 
  @Transactional
  @Override
  @NebulaServiceMethod(name="RuleSourceDataViewEntityService.createForm" , desc="创建一个新的StudentEntity模型对象（默认不包括任何可能第三方系统调用、任何复杂逻辑处理等）" , returnPropertiesFilter="" , scope=ScopeType.WRITE)
  public RuleSourceDataViewEntity createForm(RuleSourceDataViewEntity ruleSourceDataViewEntity) { 
    this.createValidation(ruleSourceDataViewEntity);
    
    // ===============================
    //  和业务有关的验证填写在这个区域    
    // ===============================
    this.ruleSourceDataViewEntityRepository.save(ruleSourceDataViewEntity);
    // 返回最终处理的结果，里面带有详细的关联信息
    return ruleSourceDataViewEntity;
  }
  /**
   * 在创建一个新的RuleSourceDataViewEntity模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   */
  private void createValidation(RuleSourceDataViewEntity ruleSourceDataViewEntity) { 
    Validate.notNull(ruleSourceDataViewEntity , "进行当前操作时，信息对象必须传入!!");
    // 判定那些不能为null的输入值：条件为 caninsert = true，且nullable = false
    Validate.isTrue(StringUtils.isBlank(ruleSourceDataViewEntity.getId()), "添加信息时，当期信息的数据编号（主键）不能有值！");
    ruleSourceDataViewEntity.setId(null);
    Validate.notBlank(ruleSourceDataViewEntity.getViewCode(), "添加信息时，数据视图业务编号不能为空！");
    // 验证长度，被验证的这些字段符合特征: 字段类型为String，且不为PK （注意连续空字符串的情况） 
    Validate.isTrue(ruleSourceDataViewEntity.getViewCode() == null || ruleSourceDataViewEntity.getViewCode().length() < 128 , "数据视图业务编号,在进行添加时填入值超过了限定长度(128)，请检查!");
  }
  @Transactional
  @Override
  @NebulaServiceMethod(name="RuleSourceDataViewEntityService.update" , desc="该方法只用于处理业务表单信息，包括了主业务模型、其下的关联模型、分组信息和明细细信息等" , returnPropertiesFilter="", scope=ScopeType.WRITE)
  public RuleSourceDataViewEntity update(RuleSourceDataViewEntity ruleSourceDataViewEntity) { 
    RuleSourceDataViewEntity current = this.updateForm(ruleSourceDataViewEntity);
    //==================================================== 
    //    这里可以处理第三方系统调用（或特殊处理过程）
    //====================================================
    return current;
  } 
  @Transactional
  @Override
  public RuleSourceDataViewEntity updateForm(RuleSourceDataViewEntity ruleSourceDataViewEntity) { 
    this.updateValidation(ruleSourceDataViewEntity);
    // ===================基本信息
    String currentId = ruleSourceDataViewEntity.getId();
    Optional<RuleSourceDataViewEntity> op_currentRuleSourceDataViewEntity = this.ruleSourceDataViewEntityRepository.findById(currentId);
    RuleSourceDataViewEntity currentRuleSourceDataViewEntity = op_currentRuleSourceDataViewEntity.orElse(null);
    currentRuleSourceDataViewEntity = Validate.notNull(currentRuleSourceDataViewEntity ,"未发现指定的原始模型对象信");
    // 开始重新赋值——一般属性
    currentRuleSourceDataViewEntity.setViewCode(ruleSourceDataViewEntity.getViewCode());
    
    this.ruleSourceDataViewEntityRepository.saveAndFlush(currentRuleSourceDataViewEntity);
    return currentRuleSourceDataViewEntity;
  }
  /**
   * 在更新一个已有的RuleSourceDataViewEntity模型对象之前，该私有方法检查对象各属性的正确性，其id属性必须有值
   */
  private void updateValidation(RuleSourceDataViewEntity ruleSourceDataViewEntity) { 
    Validate.isTrue(!StringUtils.isBlank(ruleSourceDataViewEntity.getId()), "修改信息时，当期信息的数据编号（主键）必须有值！");
    
    // 基础信息判断，基本属性，需要满足not null
    Validate.notBlank(ruleSourceDataViewEntity.getViewCode(), "修改信息时，数据视图业务编号不能为空！");
    // 验证长度，被验证的这些字段符合特征: 字段类型为String，且不为PK，且canupdate = true
    Validate.isTrue(ruleSourceDataViewEntity.getViewCode() == null || ruleSourceDataViewEntity.getViewCode().length() < 128 , "数据视图业务编号,在进行修改时填入值超过了限定长度(128)，请检查!");
  } 
  @Override
  @NebulaServiceMethod(name="RuleSourceDataViewEntityService.findDetailsById" , desc="按照主键进行详情查询（包括关联信息）" , returnPropertiesFilter="" , scope=ScopeType.READ)
  public RuleSourceDataViewEntity findDetailsById(@ServiceMethodParam(name="id") String id) {
    if(StringUtils.isBlank(id)) { 
      return null;
    }
    return this.ruleSourceDataViewEntityRepository.findDetailsById(id);
  }
  @Override
  public RuleSourceDataViewEntity findById(String id) { 
    if(StringUtils.isBlank(id)) { 
      return null;
    }
    
    Optional<RuleSourceDataViewEntity> op = ruleSourceDataViewEntityRepository.findById(id);
    return op.orElse(null); 
  }
  @Override
  @Transactional
  public void deleteById(String id) {
    // 只有存在才进行删除
    Validate.notBlank(id , "进行删除时，必须给定主键信息!!");
    RuleSourceDataViewEntity current = this.findById(id);
    if(current != null) { 
      this.ruleSourceDataViewEntityRepository.delete(current);
    }
  }
} 
