package com.bizunited.platform.mars.repository;
import com.bizunited.platform.mars.entity.RuleSourceAggregateDataViewEntity;
import java.lang.String;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * RuleSourceAggregateDataViewEntity业务模型的数据库方法支持
 * @author saturn
 */
@Repository("_RuleSourceAggregateDataViewEntityRepository")
public interface RuleSourceAggregateDataViewEntityRepository
    extends
      JpaRepository<RuleSourceAggregateDataViewEntity, String>
      ,JpaSpecificationExecutor<RuleSourceAggregateDataViewEntity>
  {

  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   * */
  @Query("select distinct ruleSourceAggregateDataViewEntity from RuleSourceAggregateDataViewEntity ruleSourceAggregateDataViewEntity "
      + " where ruleSourceAggregateDataViewEntity.id=:id ")
  public RuleSourceAggregateDataViewEntity findDetailsById(@Param("id") String id);
}