package com.bizunited.platform.mars.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 节点模板的处理源——数据视图（内聚函数）信息
 * @author yinwenjie
 * @since  2020-06-20
 */
@Entity
@Table(name = "engine_rule_source_aggregateview")
@ApiModel(value = "RuleSourceDataViewEntity" , description="节点模板的处理源——数据视图（内聚函数）信息")
@org.hibernate.annotations.Table(appliesTo = "engine_rule_source_aggregateview" , comment = "节点模板的处理源——数据视图（内聚函数）信息")
public class RuleSourceAggregateDataViewEntity extends UuidEntity {
  /**
   * 
   */
  private static final long serialVersionUID = -1478018741105342470L;
  /**
   * 数据视图业务编号
   */
  @ApiModelProperty(name = "viewCode", value = "数据视图业务编号")
  @Column(name = "view_code" , length = 128 , nullable = false , columnDefinition = "varchar(128) COMMENT '数据视图业务编号'")
  @SaturnColumn(description = "数据视图业务编号")
  private String viewCode;
  /**
   * 聚集函数对应的视图字段
   */
  @ApiModelProperty(name = "aggregateField", value = "聚集函数对应的视图字段")
  @Column(name = "aggregate_field" , length = 256 , nullable = false , columnDefinition = "varchar(256) COMMENT '聚集函数对应的视图字段'")
  @SaturnColumn(description = "聚集函数对应的视图字段")
  private String aggregateField;
  /**
   * SQL集合函数类型：
   * 1、count；2、sum；3、avg；4、max；5、min
   */
  @ApiModelProperty(name = "aggregateType", value = "SQL集合函数类型")
  @Column(name = "aggregate_type" , nullable = false , columnDefinition = "int(11)  COMMENT 'SQL集合函数类型：1、count；2、sum；3、avg；4、max；5、min'")
  @SaturnColumn(description = "SQL集合函数类型")
  private Integer aggregateType;
  /**
   * 小数保留维数（默认为2）
   */
  @ApiModelProperty(name = "scale", value = "小数保留维数（默认为2）")
  @Column(name = "scale" , nullable = false , columnDefinition = "int(11)  COMMENT '小数保留维数（默认为2）'")
  @SaturnColumn(description = "小数保留尾数（默认为2）")
  private Integer scale = 2;
  
  public String getViewCode() {
    return viewCode;
  }
  public void setViewCode(String viewCode) {
    this.viewCode = viewCode;
  }
  public void setAggregateType(Integer aggregateType) {
    this.aggregateType = aggregateType;
  }
  public String getAggregateField() {
    return aggregateField;
  }
  public void setAggregateField(String aggregateField) {
    this.aggregateField = aggregateField;
  }
  public Integer getScale() {
    return scale;
  }
  public void setScale(Integer scale) {
    this.scale = scale;
  }
  public Integer getAggregateType() {
    return aggregateType;
  }
}
