package com.bizunited.platform.mars.repository;
import com.bizunited.platform.mars.entity.RuleDefinitionEntity;
import java.lang.String;
import java.util.Set;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * RuleDefinitionEntity业务模型的数据库方法支持
 * @author saturn
 */
@Repository("_RuleDefinitionEntityRepository")
public interface RuleDefinitionEntityRepository
    extends
      JpaRepository<RuleDefinitionEntity, String>
      ,JpaSpecificationExecutor<RuleDefinitionEntity>
  {

  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   * */
  @Query("from RuleDefinitionEntity r "
      + " left join fetch r.nodes "
      + " where r.id=:id ")
  public RuleDefinitionEntity findDetailsById(@Param("id") String id);

  /**
   * 按照版本和业务编号查询详情（包括关联信息，特别是规则定义中使用的节点模板信息，但是不再包括模板中的关联信息）</br>
   * 这个SQL性能不高，但是不用去改，因为在规则实例创建服务中，该查询已经被缓存24小时。
   * @param code 指定的业务编号
   * @param cversion 指定的版本信息
   * @return 
   */
  @Query("select distinct r from RuleDefinitionEntity r "
      + " left join fetch r.nodes n "
      + " left join fetch n.templateNode ntn "
      + " left join fetch n.inputs ins "
      + " left join fetch n.outputs ous "
      + " left join fetch n.nexts nexts "
      + " left join fetch n.ruleLockExt rle "
      + " left join fetch n.ruleAggregationExt rae "
      + " left join fetch n.ruleTimerExt rte "
      + " left join fetch nexts.fromNode nextsf "
      + " left join fetch nexts.toNode nextst "
      + " where r.code=:code and r.cverion=:cversion")
  public RuleDefinitionEntity findDetailsByCodeAndVersion(@Param("code") String code ,@Param("cversion")  String cversion);
  
  /**
   * 按照版本和业务编号查询详情
   * @param code 指定的业务编号
   * @param cversion 指定的版本信息
   * @return 
   */
  @Query("from RuleDefinitionEntity r "
      + " where r.code=:code and r.cverion=:cversion ")
  public RuleDefinitionEntity findByCodeAndVersion(@Param("code") String code , @Param("cversion") String cversion);

  /**
   * 查询当前已创建的所有规则定义基本信息，并按照创建时间进行排序
   * @return
   */
  @Query("from RuleDefinitionEntity r where r.projectName=:projectName order by r.createTime desc")
  public Set<RuleDefinitionEntity> findAllByProjectName(@Param("projectName") String projectName);
}