package com.bizunited.platform.mars.repository;
import com.bizunited.platform.mars.entity.RuleTemplateGroupEntity;

import java.lang.String;
import java.util.Set;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * RuleTemplateGroupEntity业务模型的数据库方法支持
 * @author saturn
 */
@Repository("_RuleTemplateGroupEntityRepository")
public interface RuleTemplateGroupEntityRepository extends 
    JpaRepository<RuleTemplateGroupEntity, String>
   ,JpaSpecificationExecutor<RuleTemplateGroupEntity> {

  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   * */
  @Query("select distinct ruleTemplateGroupEntity from RuleTemplateGroupEntity ruleTemplateGroupEntity "
      + " where ruleTemplateGroupEntity.id=:id ")
  public RuleTemplateGroupEntity findDetailsById(@Param("id") String id);
  /**
   * 按照分组编号编号进行查询
   * @param code 分组编号编号
   * */
  @Query(" from RuleTemplateGroupEntity f where f.code = :code ")
  public RuleTemplateGroupEntity findByCode(@Param("code") String code);
  
  /**
   * 按照分组的状态情况进行查询，并按照分类+名字的方式进行排序（只包括基本信息）
   * @param groupStatus
   * @return
   */
  @Query(" from RuleTemplateGroupEntity f where f.groupStatus = :groupStatus and f.projectName=:projectName order by f.type , f.name")
  public Set<RuleTemplateGroupEntity> findByGroupStatusAndProjectName(@Param("groupStatus") Integer groupStatus, @Param("projectName") String projectName);
  /**
   * 按照分组的类型进行查询，并按照分类+名字的方式进行排序（只包括基本信息）
   * @param type 1:判定组件、2、逻辑组件、3、锁组件，4、开始组件、5、结束组件、6、异常组件
   * @return
   */
  @Query(" from RuleTemplateGroupEntity f where f.type = :type and f.projectName=:projectName order by f.name")
  public Set<RuleTemplateGroupEntity> findByTypeAndProjectName(@Param("type") Integer type, @Param("projectName") String projectName);
  /**
   * 按照分类+名字的方式进行排序（只包括基本信息）
   * @return
   */
  @Query(" from RuleTemplateGroupEntity f where f.projectName=:projectName order by f.type , f.name")
  public Set<RuleTemplateGroupEntity> findAllOrderByTypeAndNameAndProjectName(@Param("projectName") String projectName);
}