package com.bizunited.platform.mars.service.init;

import java.util.Date;

import javax.transaction.Transactional;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.bizunited.platform.common.service.init.InitProcessService;
import com.bizunited.platform.mars.entity.RuleTemplateNodeEntity;
import com.bizunited.platform.mars.repository.RuleTemplateNodeEntityRepository;
import com.bizunited.platform.mars.service.RuleTemplateNodeService;

/**
 * 该初始化服务负责在第一次启动mars规则实例时,进行默认模板节点的初始化工作。</br>
 * 包括了默认的开始节点、默认的结束节点、默认的条件节点、默认的动态脚本逻辑节点
 * @author yinwenjie
 */
@Component("RuleTemplateNodeInitProcessService")
public class RuleTemplateNodeInitProcessService implements InitProcessService {
  @Autowired
  private RuleTemplateNodeService ruleTemplateNodeService;
  @Autowired
  private RuleTemplateNodeEntityRepository ruleTemplateNodeRepository;
  
  /**
   * 默认的开始节点模板编号
   */
  private static final String START_TEMPLATE_CODE = "defaultStart";
  /**
   * 默认的结束节点模板编号
   */
  private static final String END_TEMPLATE_CODE = "defaultEnd";
  /**
   * 默认的条件节点模板编号
   */
  private static final String CONDITION_TEMPLATE_CODE = "defaultCondition";
  /**
   * 默认的动态脚本模板编号
   */
  private static final String DYNAMIC_SCRIPT_TEMPLATE_CODE = "dynamicScript"; 
  
  @Override
  public boolean doProcess() {
    RuleTemplateNodeEntity defaultStart = this.ruleTemplateNodeService.findByCode(START_TEMPLATE_CODE);
    RuleTemplateNodeEntity defaultEnd = this.ruleTemplateNodeService.findByCode(END_TEMPLATE_CODE);
    RuleTemplateNodeEntity defaultCondition = this.ruleTemplateNodeService.findByCode(CONDITION_TEMPLATE_CODE);
    RuleTemplateNodeEntity dynamicScript = this.ruleTemplateNodeService.findByCode(DYNAMIC_SCRIPT_TEMPLATE_CODE);
    
    if(defaultStart == null || defaultEnd == null || defaultCondition == null || dynamicScript == null) {
      return true;
    }
    return false;
  }

  @Override
  @Transactional
  public void init() {
    RuleTemplateNodeEntity defaultStart = this.ruleTemplateNodeService.findByCode(START_TEMPLATE_CODE);
    if(defaultStart == null) {
      this.initDefaultStart();
    }
    RuleTemplateNodeEntity defaultEnd = this.ruleTemplateNodeService.findByCode(END_TEMPLATE_CODE);
    if(defaultEnd == null) {
      this.initDefaultEnd();
    }
    RuleTemplateNodeEntity defaultCondition = this.ruleTemplateNodeService.findByCode(CONDITION_TEMPLATE_CODE);
    if(defaultCondition == null) {
      this.initDefaultCondition();
    }
    RuleTemplateNodeEntity dynamicScript = this.ruleTemplateNodeService.findByCode(DYNAMIC_SCRIPT_TEMPLATE_CODE);
    if(dynamicScript == null) {
      this.initDefaultDynamicScript();
    }
  }
  
  /**
   * 初始化开始节点的模板
   */
  private void initDefaultStart() {
    Date currentTime = new Date();
    RuleTemplateNodeEntity ruleTemplateNode = new RuleTemplateNodeEntity();
    ruleTemplateNode.setCode(START_TEMPLATE_CODE);
    ruleTemplateNode.setName("默认开始");
    ruleTemplateNode.setCreateAccount("admin");
    ruleTemplateNode.setCreateTime(currentTime);
    ruleTemplateNode.setModifyAccount("admin");
    ruleTemplateNode.setModifyTime(currentTime);
    ruleTemplateNode.setNodeStatus(1);
    ruleTemplateNode.setType(4);
    this.ruleTemplateNodeRepository.save(ruleTemplateNode);
  }
  /**
   * 初始化开始节点的模板
   */
  private void initDefaultEnd() {
    Date currentTime = new Date();
    RuleTemplateNodeEntity ruleTemplateNode = new RuleTemplateNodeEntity();
    ruleTemplateNode.setCode(END_TEMPLATE_CODE);
    ruleTemplateNode.setName("默认结束");
    ruleTemplateNode.setCreateAccount("admin");
    ruleTemplateNode.setCreateTime(currentTime);
    ruleTemplateNode.setModifyAccount("admin");
    ruleTemplateNode.setModifyTime(currentTime);
    ruleTemplateNode.setNodeStatus(1);
    ruleTemplateNode.setType(5);
    this.ruleTemplateNodeRepository.save(ruleTemplateNode);
  }
  /**
   * 初始化默认的条件判定节点的模板
   */
  private void initDefaultCondition() {
    Date currentTime = new Date();
    RuleTemplateNodeEntity ruleTemplateNode = new RuleTemplateNodeEntity();
    ruleTemplateNode.setCode(CONDITION_TEMPLATE_CODE);
    ruleTemplateNode.setName("默认条件");
    ruleTemplateNode.setCreateAccount("admin");
    ruleTemplateNode.setCreateTime(currentTime);
    ruleTemplateNode.setModifyAccount("admin");
    ruleTemplateNode.setModifyTime(currentTime);
    ruleTemplateNode.setNodeStatus(1);
    ruleTemplateNode.setType(1);
    this.ruleTemplateNodeRepository.save(ruleTemplateNode);
  }
  /**
   * 初始化默认的动态脚本节点的模板
   */
  private void initDefaultDynamicScript() {
    Date currentTime = new Date();
    RuleTemplateNodeEntity ruleTemplateNode = new RuleTemplateNodeEntity();
    ruleTemplateNode.setCode(DYNAMIC_SCRIPT_TEMPLATE_CODE);
    ruleTemplateNode.setName("默认动态脚本逻辑");
    ruleTemplateNode.setCreateAccount("admin");
    ruleTemplateNode.setCreateTime(currentTime);
    ruleTemplateNode.setModifyAccount("admin");
    ruleTemplateNode.setModifyTime(currentTime);
    ruleTemplateNode.setNodeStatus(1);
    ruleTemplateNode.setType(2);
    ruleTemplateNode.setSourceType(5);
    this.ruleTemplateNodeRepository.save(ruleTemplateNode);
  }
}
