package com.bizunited.platform.mars.service.internal;
import com.bizunited.platform.core.annotations.NebulaServiceMethod;
import com.bizunited.platform.core.annotations.NebulaServiceMethod.ScopeType;
import com.bizunited.platform.core.annotations.ServiceMethodParam;
import com.bizunited.platform.mars.entity.RuleConcurrentAggregationEntity;
import com.bizunited.platform.mars.repository.RuleConcurrentAggregationEntityRepository;
import com.bizunited.platform.mars.service.RuleConcurrentAggregationService;

import java.lang.Override;
import java.lang.String;
import java.util.Optional;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * RuleConcurrentAggregationEntity业务模型的服务层接口实现
 * @author saturn
 */
@Service("RuleConcurrentAggregationServiceImpl")
public class RuleConcurrentAggregationServiceImpl implements RuleConcurrentAggregationService { 
  @Autowired
  private RuleConcurrentAggregationEntityRepository ruleConcurrentAggregationEntityRepository;
  @Transactional
  @Override
  public RuleConcurrentAggregationEntity create(RuleConcurrentAggregationEntity ruleConcurrentAggregationEntity) { 
    RuleConcurrentAggregationEntity current = this.createForm(ruleConcurrentAggregationEntity);
    //==================================================== 
    //    这里可以处理第三方系统调用（或特殊处理过程）
    //====================================================
    return current;
  } 
  @Transactional
  @Override
  @NebulaServiceMethod(name="RuleConcurrentAggregationEntityService.createForm" , desc="创建一个新的StudentEntity模型对象（默认不包括任何可能第三方系统调用、任何复杂逻辑处理等）" , returnPropertiesFilter="" , scope=ScopeType.WRITE)
  public RuleConcurrentAggregationEntity createForm(RuleConcurrentAggregationEntity ruleConcurrentAggregationEntity) { 
   /* 
    * 针对1.1.3版本的需求，这个对静态模型的保存操作做出调整，新的包裹过程为：
    * 1、如果当前模型对象不是主模型
    * 1.1、那么创建前只会验证基本信息，直接的ManyToOne关联（单选）和ManyToMany关联（多选）
    * 1.2、验证完成后，也只会保存当前对象的基本信息，直接的单选
    * TODO 1.3、ManyToMany的关联（多选），暂时需要开发人员自行处理
    * 2、如果当前模型对象是主业务模型
    *  2.1、创建前会验证当前模型的基本属性，单选和多选属性
    *  2.2、然后还会验证当前模型关联的各个OneToMany明细信息，调用明细对象的服务，明每一条既有明细进行验证
    *  （2.2的步骤还需要注意，如果当前被验证的关联对象是回溯对象，则不需要验证了）
    * 2.3、还会验证当前模型关联的各个OneToOne分组，调用分组对象的服务，对分组中的信息进行验证
    *   2.3.1、包括验证每一个分组项的基本信息、直接的单选、多选信息
    *   2.3.2、以及验证每个分组的OneToMany明细信息
    * */
    this.createValidation(ruleConcurrentAggregationEntity);
    
    // ===============================
    //  和业务有关的验证填写在这个区域    
    // ===============================
    
    this.ruleConcurrentAggregationEntityRepository.save(ruleConcurrentAggregationEntity);
    // 返回最终处理的结果，里面带有详细的关联信息
    return ruleConcurrentAggregationEntity;
  }
  /**
   * 在创建一个新的RuleConcurrentAggregationEntity模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   */
  private void createValidation(RuleConcurrentAggregationEntity ruleConcurrentAggregationEntity) { 
    Validate.notNull(ruleConcurrentAggregationEntity , "进行当前操作时，信息对象必须传入!!");
    // 判定那些不能为null的输入值：条件为 caninsert = true，且nullable = false
    Validate.isTrue(StringUtils.isBlank(ruleConcurrentAggregationEntity.getId()), "添加信息时，当期信息的数据编号（主键）不能有值！");
    ruleConcurrentAggregationEntity.setId(null);
    Validate.notBlank(ruleConcurrentAggregationEntity.getParamName(), "添加信息时，进行分流判定的上下文中参数依据,该参数只能是集合或者是数组。不能为空！");
    // 验证长度，被验证的这些字段符合特征: 字段类型为String，且不为PK （注意连续空字符串的情况） 
    Validate.isTrue(ruleConcurrentAggregationEntity.getParamName() == null || ruleConcurrentAggregationEntity.getParamName().length() < 64 , "进行分流判定的上下文中参数依据,该参数只能是集合或者是数组。,在进行添加时填入值超过了限定长度(64)，请检查!");
  }
  @Transactional
  @Override
  @NebulaServiceMethod(name="RuleConcurrentAggregationEntityService.update" , desc="该方法只用于处理业务表单信息，包括了主业务模型、其下的关联模型、分组信息和明细细信息等" , returnPropertiesFilter="", scope=ScopeType.WRITE)
  public RuleConcurrentAggregationEntity update(RuleConcurrentAggregationEntity ruleConcurrentAggregationEntity) { 
    RuleConcurrentAggregationEntity current = this.updateForm(ruleConcurrentAggregationEntity);
    //==================================================== 
    //    这里可以处理第三方系统调用（或特殊处理过程）
    //====================================================
    return current;
  } 
  @Transactional
  @Override
  public RuleConcurrentAggregationEntity updateForm(RuleConcurrentAggregationEntity ruleConcurrentAggregationEntity) { 
    /* 
     * 针对1.1.3版本的需求，这个对静态模型的修改操作做出调整，新的过程为：
     * 1、如果当前模型对象不是主模型
     * 1.1、那么创建前只会验证基本信息，直接的ManyToOne关联（单选）和ManyToMany关联（多选）
     * 1.2、验证完成后，也只会保存当前对象的基本信息，直接的单选
     * TODO 1.3、ManyToMany的关联（多选），暂时需要开发人员自行处理（求删除、新增绑定的代码已生成）
     * 
     * 2、如果当前模型对象是主业务模型
     *  2.1、创建前会验证当前模型的基本属性，单选和多选属性
     *  2.2、然后还会验证当前模型关联的各个OneToMany明细信息，调用明细对象的服务，明每一条既有明细进行验证
     *  （2.2的步骤还需要注意，如果当前被验证的关联对象是回溯对象，则不需要验证了）
     *  2.3、还会验证当前模型关联的各个OneToOne分组，调用分组对象的服务，对分组中的信息进行验证
     *    2.3.1、包括验证每一个分组项的基本信息、直接的单选、多选信息
     *    2.3.2、以及验证每个分组的OneToMany明细信息
     * */
    
    this.updateValidation(ruleConcurrentAggregationEntity);
    // ===================基本信息
    String currentId = ruleConcurrentAggregationEntity.getId();
    Optional<RuleConcurrentAggregationEntity> op_currentRuleConcurrentAggregationEntity = this.ruleConcurrentAggregationEntityRepository.findById(currentId);
    RuleConcurrentAggregationEntity currentRuleConcurrentAggregationEntity = op_currentRuleConcurrentAggregationEntity.orElse(null);
    currentRuleConcurrentAggregationEntity = Validate.notNull(currentRuleConcurrentAggregationEntity ,"未发现指定的原始模型对象信");
    // 开始重新赋值——一般属性
    currentRuleConcurrentAggregationEntity.setParamName(ruleConcurrentAggregationEntity.getParamName());
    
    this.ruleConcurrentAggregationEntityRepository.saveAndFlush(currentRuleConcurrentAggregationEntity);
    return currentRuleConcurrentAggregationEntity;
  }
  /**
   * 在更新一个已有的RuleConcurrentAggregationEntity模型对象之前，该私有方法检查对象各属性的正确性，其id属性必须有值
   */
  private void updateValidation(RuleConcurrentAggregationEntity ruleConcurrentAggregationEntity) { 
    Validate.isTrue(!StringUtils.isBlank(ruleConcurrentAggregationEntity.getId()), "修改信息时，当期信息的数据编号（主键）必须有值！");
    
    // 基础信息判断，基本属性，需要满足not null
    Validate.notBlank(ruleConcurrentAggregationEntity.getParamName(), "修改信息时，进行分流判定的上下文中参数依据,该参数只能是集合或者是数组。不能为空！");
    // 验证长度，被验证的这些字段符合特征: 字段类型为String，且不为PK，且canupdate = true
    Validate.isTrue(ruleConcurrentAggregationEntity.getParamName() == null || ruleConcurrentAggregationEntity.getParamName().length() < 64 , "进行分流判定的上下文中参数依据,该参数只能是集合或者是数组。,在进行修改时填入值超过了限定长度(64)，请检查!");
  } 
  @Override
  @NebulaServiceMethod(name="RuleConcurrentAggregationEntityService.findDetailsById" , desc="按照主键进行详情查询（包括关联信息）" , returnPropertiesFilter="" , scope=ScopeType.READ)
  public RuleConcurrentAggregationEntity findDetailsById(@ServiceMethodParam(name="id") String id) {
    if(StringUtils.isBlank(id)) { 
      return null;
    }
    return this.ruleConcurrentAggregationEntityRepository.findDetailsById(id);
  }
  @Override
  public RuleConcurrentAggregationEntity findById(String id) { 
    if(StringUtils.isBlank(id)) { 
      return null;
    }
    
    Optional<RuleConcurrentAggregationEntity> op = ruleConcurrentAggregationEntityRepository.findById(id);
    return op.orElse(null); 
  }
  @Override
  @Transactional
  public void deleteById(String id) {
    // 只有存在才进行删除
    Validate.notBlank(id , "进行删除时，必须给定主键信息!!");
    RuleConcurrentAggregationEntity current = this.findById(id);
    if(current != null) { 
      this.ruleConcurrentAggregationEntityRepository.delete(current);
    }
  }
  @Override
  @Transactional
  public void deleteByIds(String[] ids) {
    Validate.notNull(ids , "进行删除时，必须给定主键信息(支持多个)!!");
    for (String id : ids) {
      this.deleteById(id);
    }
  }
} 
