package com.bizunited.platform.mars.service.internal;
import com.bizunited.platform.mars.entity.RuleNodeNextsEntity;
import com.bizunited.platform.mars.repository.RuleNodeNextsEntityRepository;
import com.bizunited.platform.mars.service.RuleNodeNextsService;
import com.google.common.collect.Sets;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * RuleNodeNextsEntity业务模型的服务层接口实现
 * @author saturn
 */
@Service("RuleNodeNextsEntityServiceImpl")
public class RuleNodeNextsServiceImpl implements RuleNodeNextsService { 

  @Autowired
  private RuleNodeNextsEntityRepository ruleNodeNextsEntityRepository;
  
  @Transactional
  @Override
  public RuleNodeNextsEntity create(RuleNodeNextsEntity ruleNodeNextsEntity) { 
    RuleNodeNextsEntity current = this.createForm(ruleNodeNextsEntity);
    //==================================================== 
    //    这里可以处理第三方系统调用（或特殊处理过程）
    //====================================================
    return current;
  } 
  @Transactional
  @Override
  public RuleNodeNextsEntity createForm(RuleNodeNextsEntity ruleNodeNextsEntity) { 
   /* 
    * 针对1.1.3版本的需求，这个对静态模型的保存操作做出调整，新的包裹过程为：
    * 1、如果当前模型对象不是主模型
    * 1.1、那么创建前只会验证基本信息，直接的ManyToOne关联（单选）和ManyToMany关联（多选）
    * 1.2、验证完成后，也只会保存当前对象的基本信息，直接的单选
    * TODO 1.3、ManyToMany的关联（多选），暂时需要开发人员自行处理
    * 2、如果当前模型对象是主业务模型
    *  2.1、创建前会验证当前模型的基本属性，单选和多选属性
    *  2.2、然后还会验证当前模型关联的各个OneToMany明细信息，调用明细对象的服务，明每一条既有明细进行验证
    *  （2.2的步骤还需要注意，如果当前被验证的关联对象是回溯对象，则不需要验证了）
    * 2.3、还会验证当前模型关联的各个OneToOne分组，调用分组对象的服务，对分组中的信息进行验证
    *   2.3.1、包括验证每一个分组项的基本信息、直接的单选、多选信息
    *   2.3.2、以及验证每个分组的OneToMany明细信息
    * */
    this.createValidation(ruleNodeNextsEntity);
    
    // ===============================
    //  和业务有关的验证填写在这个区域    
    // ===============================
    this.ruleNodeNextsEntityRepository.save(ruleNodeNextsEntity);
    
    // 返回最终处理的结果，里面带有详细的关联信息
    return ruleNodeNextsEntity;
  }
  /**
   * 在创建一个新的RuleNodeNextsEntity模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   */
  private void createValidation(RuleNodeNextsEntity ruleNodeNextsEntity) { 
    Validate.notNull(ruleNodeNextsEntity , "进行当前操作时，信息对象必须传入!!");
    // 判定那些不能为null的输入值：条件为 caninsert = true，且nullable = false
    Validate.isTrue(StringUtils.isBlank(ruleNodeNextsEntity.getId()), "添加信息时，当期信息的数据编号（主键）不能有值！");
    ruleNodeNextsEntity.setId(null);
    Validate.notNull(ruleNodeNextsEntity.getSort(), "添加信息时，连接线的判定顺序不能为空！");
    Validate.notNull(ruleNodeNextsEntity.getLineType(), "添加信息时，线条类型(1：正常线；2：异常线)不能为空！");
    // 验证长度，被验证的这些字段符合特征: 字段类型为String，且不为PK （注意连续空字符串的情况） 
    Validate.isTrue(ruleNodeNextsEntity.getConditions() == null || ruleNodeNextsEntity.getConditions().length() < 255 , "流转表达式（流转条件）,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(ruleNodeNextsEntity.getExceptions() == null || ruleNodeNextsEntity.getExceptions().length() < 255 , "异常线支持的完整异常类型,在进行添加时填入值超过了限定长度(255)，请检查!");
  }
  @Transactional
  @Override
  public RuleNodeNextsEntity update(RuleNodeNextsEntity ruleNodeNextsEntity) { 
    RuleNodeNextsEntity current = this.updateForm(ruleNodeNextsEntity);
    //==================================================== 
    //    这里可以处理第三方系统调用（或特殊处理过程）
    //====================================================
    return current;
  } 
  @Transactional
  @Override
  public RuleNodeNextsEntity updateForm(RuleNodeNextsEntity ruleNodeNextsEntity) { 
    /* 
     * 针对1.1.3版本的需求，这个对静态模型的修改操作做出调整，新的过程为：
     * 1、如果当前模型对象不是主模型
     * 1.1、那么创建前只会验证基本信息，直接的ManyToOne关联（单选）和ManyToMany关联（多选）
     * 1.2、验证完成后，也只会保存当前对象的基本信息，直接的单选
     * TODO 1.3、ManyToMany的关联（多选），暂时需要开发人员自行处理（求删除、新增绑定的代码已生成）
     * 
     * 2、如果当前模型对象是主业务模型
     *  2.1、创建前会验证当前模型的基本属性，单选和多选属性
     *  2.2、然后还会验证当前模型关联的各个OneToMany明细信息，调用明细对象的服务，明每一条既有明细进行验证
     *  （2.2的步骤还需要注意，如果当前被验证的关联对象是回溯对象，则不需要验证了）
     *  2.3、还会验证当前模型关联的各个OneToOne分组，调用分组对象的服务，对分组中的信息进行验证
     *    2.3.1、包括验证每一个分组项的基本信息、直接的单选、多选信息
     *    2.3.2、以及验证每个分组的OneToMany明细信息
     * */
    
    this.updateValidation(ruleNodeNextsEntity);
    // ===================基本信息
    String currentId = ruleNodeNextsEntity.getId();
    Optional<RuleNodeNextsEntity> op_currentRuleNodeNextsEntity = this.ruleNodeNextsEntityRepository.findById(currentId);
    RuleNodeNextsEntity currentRuleNodeNextsEntity = op_currentRuleNodeNextsEntity.orElse(null);
    currentRuleNodeNextsEntity = Validate.notNull(currentRuleNodeNextsEntity ,"未发现指定的原始模型对象信");
    // 开始重新赋值——一般属性
    currentRuleNodeNextsEntity.setSort(ruleNodeNextsEntity.getSort());
    currentRuleNodeNextsEntity.setLineType(ruleNodeNextsEntity.getLineType());
    currentRuleNodeNextsEntity.setConditions(ruleNodeNextsEntity.getConditions());
    currentRuleNodeNextsEntity.setExceptions(ruleNodeNextsEntity.getExceptions());
    currentRuleNodeNextsEntity.setFromNode(ruleNodeNextsEntity.getFromNode());
    currentRuleNodeNextsEntity.setToNode(ruleNodeNextsEntity.getToNode());
    
    this.ruleNodeNextsEntityRepository.saveAndFlush(currentRuleNodeNextsEntity);
    return currentRuleNodeNextsEntity;
  }
  /**
   * 在更新一个已有的RuleNodeNextsEntity模型对象之前，该私有方法检查对象各属性的正确性，其id属性必须有值
   */
  private void updateValidation(RuleNodeNextsEntity ruleNodeNextsEntity) { 
    Validate.isTrue(!StringUtils.isBlank(ruleNodeNextsEntity.getId()), "修改信息时，当期信息的数据编号（主键）必须有值！");
    
    // 基础信息判断，基本属性，需要满足not null
    Validate.notNull(ruleNodeNextsEntity.getSort(), "修改信息时，连接线的判定顺序不能为空！");
    Validate.notNull(ruleNodeNextsEntity.getLineType(), "修改信息时，线条类型(1：正常线；2：异常线)不能为空！");
    // 验证长度，被验证的这些字段符合特征: 字段类型为String，且不为PK，且canupdate = true
    Validate.isTrue(ruleNodeNextsEntity.getConditions() == null || ruleNodeNextsEntity.getConditions().length() < 255 , "流转表达式（流转条件）,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(ruleNodeNextsEntity.getExceptions() == null || ruleNodeNextsEntity.getExceptions().length() < 255 , "异常线支持的完整异常类型,在进行修改时填入值超过了限定长度(255)，请检查!");
    
    // 关联性判断，关联属性判断，需要满足ManyToOne或者OneToOne，且not null 且是主模型
  } 
  @Override
  @Transactional
  public void deleteById(String id) {
    // 只有存在才进行删除
    Validate.notBlank(id , "进行删除时，必须给定主键信息!!");
    RuleNodeNextsEntity current = this.findById(id);
    if(current != null) { 
      this.ruleNodeNextsEntityRepository.delete(current);
    }
  }
  @Override
  @Transactional
  public void deleteByFromNodes(String[] fromNodes) {
    Validate.isTrue(fromNodes != null && fromNodes.length > 0 , "删除节点连线时，至少传入一个开始节点信息的编号");
    this.ruleNodeNextsEntityRepository.deleteByFromNodes(fromNodes);
    this.ruleNodeNextsEntityRepository.flush();
  }
  @Override
  public Set<RuleNodeNextsEntity> findDetailsByFromNode(String fromNode) { 
    if(StringUtils.isBlank(fromNode)) { 
      return Sets.newHashSet();
    }
    return this.ruleNodeNextsEntityRepository.findDetailsByFromNode(fromNode);
  }
  @Override
  public Set<RuleNodeNextsEntity> findDetailsByToNode(String toNode) { 
    if(StringUtils.isBlank(toNode)) { 
      return Sets.newHashSet();
    }
    return this.ruleNodeNextsEntityRepository.findDetailsByToNode(toNode);
  }
  @Override
  public RuleNodeNextsEntity findDetailsById(String id) { 
    if(StringUtils.isBlank(id)) { 
      return null;
    }
    return this.ruleNodeNextsEntityRepository.findDetailsById(id);
  }
  @Override
  public RuleNodeNextsEntity findById(String id) { 
    if(StringUtils.isBlank(id)) { 
      return null;
    }
    
    Optional<RuleNodeNextsEntity> op = ruleNodeNextsEntityRepository.findById(id);
    return op.orElse(null); 
  }
  @Override
  public RuleNodeNextsEntity findByFromAndTo(String fromCode , String toCode) {
    if(StringUtils.isBlank(fromCode) || StringUtils.isBlank(toCode)) {
      return null;
    }
    
    return this.ruleNodeNextsEntityRepository.findByFromAndTo(fromCode, toCode);
  }
} 
