package com.bizunited.platform.mars.service.internal;

import com.bizunited.platform.mars.entity.RuleNodeEntity;
import com.bizunited.platform.mars.repository.RuleNodeEntityRepository;
import com.bizunited.platform.mars.service.RuleNodeService;
import com.google.common.collect.Sets;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * RuleNodeEntity业务模型的服务层接口实现
 * @author saturn
 */
@Service("RuleNodeEntityServiceImpl")
public class RuleNodeServiceImpl implements RuleNodeService { 
  @Autowired
  private RuleNodeEntityRepository ruleNodeEntityRepository;
  @Transactional
  @Override
  public RuleNodeEntity create(RuleNodeEntity ruleNodeEntity) { 
    RuleNodeEntity current = this.createForm(ruleNodeEntity);
    //==================================================== 
    //    这里可以处理第三方系统调用（或特殊处理过程）
    //====================================================
    return current;
  } 
  @Transactional
  @Override
  public RuleNodeEntity createForm(RuleNodeEntity ruleNodeEntity) { 
   /* 
    * 针对1.1.3版本的需求，这个对静态模型的保存操作做出调整，新的包裹过程为：
    * 1、如果当前模型对象不是主模型
    * 1.1、那么创建前只会验证基本信息，直接的ManyToOne关联（单选）和ManyToMany关联（多选）
    * 1.2、验证完成后，也只会保存当前对象的基本信息，直接的单选
    * TODO 1.3、ManyToMany的关联（多选），暂时需要开发人员自行处理
    * 2、如果当前模型对象是主业务模型
    *  2.1、创建前会验证当前模型的基本属性，单选和多选属性
    *  2.2、然后还会验证当前模型关联的各个OneToMany明细信息，调用明细对象的服务，明每一条既有明细进行验证
    *  （2.2的步骤还需要注意，如果当前被验证的关联对象是回溯对象，则不需要验证了）
    * 2.3、还会验证当前模型关联的各个OneToOne分组，调用分组对象的服务，对分组中的信息进行验证
    *   2.3.1、包括验证每一个分组项的基本信息、直接的单选、多选信息
    *   2.3.2、以及验证每个分组的OneToMany明细信息
    * */
    this.createValidation(ruleNodeEntity);
    this.ruleNodeEntityRepository.save(ruleNodeEntity);
    
    // 返回最终处理的结果，里面带有详细的关联信息
    return ruleNodeEntity;
  }
  /**
   * 在创建一个新的RuleNodeEntity模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   */
  private void createValidation(RuleNodeEntity ruleNodeEntity) { 
    Validate.notNull(ruleNodeEntity , "进行当前操作时，信息对象必须传入!!");
    // 判定那些不能为null的输入值：条件为 caninsert = true，且nullable = false
    Validate.isTrue(StringUtils.isBlank(ruleNodeEntity.getId()), "添加信息时，当期信息的数据编号（主键）不能有值！");
    ruleNodeEntity.setId(null);
    Integer type = ruleNodeEntity.getType();
    Validate.notNull(type, "添加信息时，节点定义类型不能为空！");
    if(type == 2) {
      Validate.notNull(ruleNodeEntity.getSourceType(), "添加信息时，节点定义工作逻辑类型不能为空！");
    }
  }
  @Transactional
  @Override
  public RuleNodeEntity update(RuleNodeEntity ruleNodeEntity) { 
    RuleNodeEntity current = this.updateForm(ruleNodeEntity);
    //==================================================== 
    //    这里可以处理第三方系统调用（或特殊处理过程）
    //====================================================
    return current;
  } 
  @Transactional
  @Override
  public RuleNodeEntity updateForm(RuleNodeEntity ruleNodeEntity) { 
    /* 
     * 针对1.1.3版本的需求，这个对静态模型的修改操作做出调整，新的过程为：
     * 1、如果当前模型对象不是主模型
     * 1.1、那么创建前只会验证基本信息，直接的ManyToOne关联（单选）和ManyToMany关联（多选）
     * 1.2、验证完成后，也只会保存当前对象的基本信息，直接的单选
     * TODO 1.3、ManyToMany的关联（多选），暂时需要开发人员自行处理（求删除、新增绑定的代码已生成）
     * 
     * 2、如果当前模型对象是主业务模型
     *  2.1、创建前会验证当前模型的基本属性，单选和多选属性
     *  2.2、然后还会验证当前模型关联的各个OneToMany明细信息，调用明细对象的服务，明每一条既有明细进行验证
     *  （2.2的步骤还需要注意，如果当前被验证的关联对象是回溯对象，则不需要验证了）
     *  2.3、还会验证当前模型关联的各个OneToOne分组，调用分组对象的服务，对分组中的信息进行验证
     *    2.3.1、包括验证每一个分组项的基本信息、直接的单选、多选信息
     *    2.3.2、以及验证每个分组的OneToMany明细信息
     * */
    
    this.updateValidation(ruleNodeEntity);
    // ===================基本信息
    String currentId = ruleNodeEntity.getId();
    Optional<RuleNodeEntity> op_currentRuleNodeEntity = this.ruleNodeEntityRepository.findById(currentId);
    RuleNodeEntity currentRuleNodeEntity = op_currentRuleNodeEntity.orElse(null);
    currentRuleNodeEntity = Validate.notNull(currentRuleNodeEntity ,"未发现指定的原始模型对象信");
    // 开始重新赋值——一般属性
    currentRuleNodeEntity.setType(ruleNodeEntity.getType());
    currentRuleNodeEntity.setSourceType(ruleNodeEntity.getSourceType());
    currentRuleNodeEntity.setTemplateNode(ruleNodeEntity.getTemplateNode());
    currentRuleNodeEntity.setDefinition(ruleNodeEntity.getDefinition());
    
    this.ruleNodeEntityRepository.saveAndFlush(currentRuleNodeEntity);
    return currentRuleNodeEntity;
  }
  /**
   * 在更新一个已有的RuleNodeEntity模型对象之前，该私有方法检查对象各属性的正确性，其id属性必须有值
   */
  private void updateValidation(RuleNodeEntity ruleNodeEntity) { 
    Validate.isTrue(!StringUtils.isBlank(ruleNodeEntity.getId()), "修改信息时，当期信息的数据编号（主键）必须有值！");
    
    // 基础信息判断，基本属性，需要满足not null
    Integer type = ruleNodeEntity.getType();
    Validate.notNull(type, "修改信息时，节点定义类型不能为空！");
    if(type == 2) {
      Validate.notNull(ruleNodeEntity.getSourceType(), "修改信息时，节点定义工作逻辑类型不能为空！");
    }
  } 
  @Override
  @Transactional
  public void deleteById(String id) {
    // 只有存在才进行删除
    Validate.notBlank(id , "进行删除时，必须给定主键信息!!");
    RuleNodeEntity current = this.findById(id);
    if(current != null) { 
      this.ruleNodeEntityRepository.delete(current);
    }
  }
  @Override
  public void deleteByIds(String[] ids) {
    Validate.isTrue(ids != null && ids.length > 0 , "进行删除时，必须给定至少一个主键信息!!");
    this.ruleNodeEntityRepository.deleteByIds(ids);
    this.ruleNodeEntityRepository.flush();
  }
  @Override
  public Set<RuleNodeEntity> findDetailsByTemplateNode(String templateNode) { 
    if(StringUtils.isBlank(templateNode)) { 
      return Sets.newHashSet();
    }
    return this.ruleNodeEntityRepository.findDetailsByTemplateNode(templateNode);
  }
  @Override
  public Set<RuleNodeEntity> findDetailsByDefinition(String definition) { 
    if(StringUtils.isBlank(definition)) { 
      return Sets.newHashSet();
    }
    return this.ruleNodeEntityRepository.findDetailsByDefinition(definition);
  }
  @Override
  public RuleNodeEntity findDetailsById(String id) { 
    if(StringUtils.isBlank(id)) { 
      return null;
    }
    return this.ruleNodeEntityRepository.findDetailsById(id);
  }
  @Override
  public RuleNodeEntity findById(String id) { 
    if(StringUtils.isBlank(id)) { 
      return null;
    }
    
    Optional<RuleNodeEntity> op = ruleNodeEntityRepository.findById(id);
    return op.orElse(null); 
  }
  @Override
  public RuleNodeEntity findByCode(String code) {
    if(StringUtils.isBlank(code)) {
      return null;
    } 
    return this.ruleNodeEntityRepository.findByCode(code);
  }
} 