package com.bizunited.platform.mars.entity;

import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import org.hibernate.annotations.Where;

import com.bizunited.platform.core.entity.UuidOpEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 规则节点模板，规则节点模板可以是依据相关注解创建,也可以是技术人员/业务人员在页面上直接创建<br>
 * 根据工作位置不一样，规则节点可分为：1:判定规则、2、逻辑、3、锁规则，4、开始规则、5、结束规则、6、异常规则<br>
 * 详情可参见文档介绍 
 * @author yinwenjie 
 * @since  2020-06-21 
 */
@Entity
@Table(name = "engine_rule_template_node")
@ApiModel(value = "RuleTemplateNodeEntity" , description="规则节点模板")
@org.hibernate.annotations.Table(appliesTo = "engine_rule_template_node" , comment = "规则节点模板")
public class RuleTemplateNodeEntity extends UuidOpEntity {
  /**
   * 
   */
  private static final long serialVersionUID = 4810559224348086431L;
  /**
   * 节点模板业务编号
   */
  @ApiModelProperty(name = "code", value = "节点模板业务编号")
  @Column(name = "code" , length = 128 , nullable = false  , unique = true, columnDefinition = "varchar(128) COMMENT '节点模板业务编号'")
  @SaturnColumn(description = "节点模板业务编号" , updatable = false)
  private String code;
  /**
   * 节点模板业务名称（中文）
   */
  @ApiModelProperty(name = "name", value = " 节点模板业务名称（中文）")
  @Column(name = "name" , length = 128 , nullable = false , columnDefinition = "varchar(128) COMMENT '节点模板业务名称（中文）'")
  @SaturnColumn(description = "节点模板业务名称（中文）")
  private String name;
  /**
   * 节点可用状态， 1：正常，其它值（0）不正常</br>
   * 如果节点不可用不会影响已有的设置规则，只是新规则中不能再使用了
   */
  @ApiModelProperty(name="nodeStatus" , value="节点可用状态， 1：正常，其它值（0）不正常" , required=false)
  @Column(name = "c_status", nullable = false, columnDefinition = "int(11) COMMENT '节点可用状态， 1：正常，其它值（0）不正常'")
  @SaturnColumn(description="节点可用状态")
  private Integer nodeStatus = 1;
  /**
   * 节点模板类型
   * 1:判定组件、2、逻辑组件、3、锁组件，4、开始组件、5、结束组件、
   * 6、A/B并发组件、7、并发汇聚组件、8、时间控制组件、9、业务扩展组件
   */
  @ApiModelProperty(name = "type", value = "节点模板类型")
  @Column(name = "type" , nullable = false , columnDefinition = "int(11)  COMMENT '节点模板类型'")
  @SaturnColumn(description = "节点模板类型" , updatable = false)
  private Integer type;
  /**
   * 节点模板处理器类型（只有在逻辑组件类型时使用）：
   * 1、服务源；2、数据视图（聚集）、3、后台脚本；4、数据权限？；5、全动态脚本；6、数据视图（集合）
   */
  @ApiModelProperty(name = "source_type", value = "节点模板工作逻辑类型")
  @Column(name = "source_type" , nullable = true , columnDefinition = "int(11)  COMMENT '节点模板工作逻辑类型'")
  @SaturnColumn(description = "节点模板工作逻辑类型" , updatable = false)
  private Integer sourceType;
  /**
   * 当type为9的时候，该节点模板为业务扩展节点。(显示来运最好来源于数据字典)
   * 这种情况下需要设置业务扩展节点的类型（不能设置为1，该值已被使用）
   */
  @ApiModelProperty(name = "extType", value = "当type为9的时候，该节点模板为业务扩展节点。")
  @Column(name = "ext_type" , nullable = true , columnDefinition = "int(11)  COMMENT '当type为9的时候，该节点模板为业务扩展节点。'")
  @SaturnColumn(description = "当type为9的时候，该节点模板为业务扩展节点。")
  private Integer extType;
  /**
   * 节点背景颜色
   */
  @ApiModelProperty(name = "iconBgColor",value="节点背景颜色")
  @Column(name="icon_bg_color",length = 100,nullable = true,columnDefinition = "varchar(100) COMMENT '节点背景颜色'")
  @SaturnColumn(description = "节点背景颜色")
  private String iconBgColor;
  /**
   * 节点使用图标的颜色
   */
  @ApiModelProperty(name = "iconColor",value="节点使用图标的颜色")
  @Column(name="icon_color",length = 100,nullable = true,columnDefinition = "varchar(100) COMMENT '节点使用图标的颜色'")
  @SaturnColumn(description = "节点使用图标的颜色")
  private String iconColor;
  /**
   * 节点字体颜色
   */
  @ApiModelProperty(name = "fontColor",value="节点字体颜色")
  @Column(name="font_color",length = 100,nullable = true,columnDefinition = "varchar(100) COMMENT '节点字体颜色'")
  @SaturnColumn(description = "节点字体颜色")
  private String fontColor;
  /**
   * 节点使用的图标加载路径（相对路径）
   */
  @ApiModelProperty(name = "iconPath", value = "节点使用的图标加载路径（相对路径）")
  @Column(name = "icon_path" , length = 256 , nullable = true, columnDefinition = "varchar(256) COMMENT '节点使用的图标加载路径（相对路径）'")
  @SaturnColumn(description = "节点使用的图标加载路径（相对路径）")
  private String iconPath;
  /**
   * 如果需要进行页面引擎弹窗，则这里可填写弹窗的标题信息
   */
  @ApiModelProperty(name = "showTitle", value = "如果需要进行页面引擎弹窗，则这里可填写弹窗的标题信息")
  @Column(name = "show_title" ,  nullable = true)
  @SaturnColumn(description = "如果需要进行页面引擎弹窗，则这里可填写弹窗的标题信息")
  private String showTitle;
  /**
   * 弹窗的高度，可以是像素或者百分比
   */
  @ApiModelProperty(name = "showHight", value = "弹窗的高度，可以是像素或者百分比")
  @Column(name = "show_hight" ,  nullable = true)
  @SaturnColumn(description = "弹窗的高度，可以是像素或者百分比")
  private Integer showHight;
  /**
   * 弹窗的宽度，可以是像素或者百分比
   */
  @ApiModelProperty(name = "showWidth", value = "弹窗的宽度，可以是像素或者百分比")
  @Column(name = "show_width" ,  nullable = true)
  @SaturnColumn(description = "弹窗的宽度，可以是像素或者百分比")
  private Integer showWidth;
  /**
   * 这个逻辑组件是否使用表单引擎作为入参值输入介质
   */
  @ApiModelProperty(name = "formEngine", value = "这个逻辑组件是否使用表单引擎作为入参值输入介质")
  @Column(name = "form_engine" ,  nullable = false)
  @SaturnColumn(description = "这个逻辑组件是否使用表单引擎作为入参值输入介质")
  private Boolean formEngine = false;
  /**
   * 当前表单引擎使用的业务编号
   */
  @ApiModelProperty(name = "formEngineCode", value = "当前表单引擎使用的业务编号")
  @Column(name = "form_engine_code" , length = 256 ,  nullable = true)
  @SaturnColumn(description = "当前表单引擎使用的业务编号")
  private String formEngineCode;
  /**
   * 当前表单引擎使用的版本信息（如果使用的默认版本，则该出可能没有值）
   */
  @ApiModelProperty(name = "formEngineVersion", value = "当前表单引擎使用的版本信息（如果使用的默认版本，则该出可能没有值）")
  @Column(name = "form_engine_version" , length = 218 ,  nullable = true)
  @SaturnColumn(description = "当前表单引擎使用的版本信息（如果使用的默认版本，则该出可能没有值）")
  private String formEngineVersion;
  /**
   * 当前表单引擎是否使用默认版本
   */
  @ApiModelProperty(name = "formEngineDefault1Version", value = "当前表单引擎是否使用默认版本")
  @Column(name = "form_engine_default_version" , length = 218 ,  nullable = true)
  @SaturnColumn(description = "当前表单引擎是否使用默认版本")
  private Boolean formEngineDefault1Version;
  /**
   * 当前使用的表单引擎的可见性
   */
  @ApiModelProperty(name = "formEngineVisibility", value = "当前使用的表单引擎的可见性")
  @Column(name = "form_engine_visibility" , length = 218 ,  nullable = true)
  @SaturnColumn(description = "当前使用的表单引擎的可见性")
  private String formEngineVisibility;
  /**
   * 这个逻辑组件是否使用列表引擎作为入参值输入介质
   */
  @ApiModelProperty(name = "listEngine", value = "这个逻辑组件是否使用列表引擎作为入参值输入介质")
  @Column(name = "list_engine" ,  nullable = false)
  @SaturnColumn(description = "这个逻辑组件是否使用列表引擎作为入参值输入介质")
  private Boolean listEngine = false;
  /**
   * 列表引擎的业务编码
   */
  @ApiModelProperty(name = "listEngineCode", value = "列表引擎的业务编码")
  @Column(name = "list_engine_code" , length = 256 ,  nullable = true)
  @SaturnColumn(description = "列表引擎的业务编码")
  private String listEngineCode;
  /**
   * 列表引擎的业务版本号
   */
  @ApiModelProperty(name = "listEngineVersion", value = "列表引擎的业务版本号")
  @Column(name = "list_engine_version" , length = 256 ,  nullable = true)
  @SaturnColumn(description = "列表引擎的业务版本号")
  private String listEngineVersion;
  /**
   * 这个业务扩展组件是否使用用户自定义的业务扩展页面(只有type == 9是才能设置为true)
   */
  @ApiModelProperty(name = "userPage", value = "这个业务扩展组件是否使用用户自定义的业务扩展页面(只有type == 9是才能设置为true)")
  @Column(name = "user_page" ,  nullable = false)
  @SaturnColumn(description = "这个业务扩展组件是否使用用户自定义的业务扩展页面(只有type == 9是才能设置为true)")
  private Boolean userPage = false;
  /**
   * 当业务扩展组件需要在规则定义页面需要展开并回显数据时</br>
   * 就会使用该参数名进行url请求，例如:/xxxx/show?taskName=taskCode;
   */
  @ApiModelProperty(name = "taskName", value = "就会使用该参数名进行url请求，例如:/xxxx/show?taskName=taskCode;")
  @Column(name = "task_name" , length = 128 ,  nullable = true)
  @SaturnColumn(description = "就会使用该参数名进行url请求，例如:/xxxx/show?taskName=taskCode;")
  private String taskName;
  /**
   * 入参信息(可能没有，也可能有多个)
   */
  @SaturnColumn(description = "入参信息")
  @Where(clause = "type=1")
  @ApiModelProperty("入参信息")
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "templateNode")
  private Set<RuleTemplateParamsEntity> inputs;
  /**
   * 出参信息(可能没有，也可能有多个)
   */
  @SaturnColumn(description = "出参信息")
  @Where(clause = "type=2")
  @ApiModelProperty("出参信息")
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "templateNode")
  private Set<RuleTemplateParamsEntity> outputs;
  /**
   * 节点定义所属的分组（可以不属于任何分组）
   */
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="group_id" , nullable=true, columnDefinition = "varchar(255) COMMENT '节点定义所属的分组'")
  @SaturnColumn(description="节点定义所属的分组")
  private RuleTemplateGroupEntity templateGroup;
  /**
   * 可能对应的服务源，当sourceType == 1时使用
   */
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="source_servicable_id" , nullable=true, columnDefinition = "varchar(255) COMMENT '可能对应的服务源，当sourceType == 1时使用'")
  @SaturnColumn(description="可能对应的服务源，当sourceType == 1时使用")
  private RuleSourceServicableEntity sourceServicable;
  /**
   * 可能对应的数据视图（聚集函数），当sourceType == 2时使用
   */
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="source_aggregate_data_view_id" , nullable=true, columnDefinition = "varchar(255) COMMENT '可能对应的数据视图（聚集函数），当sourceType == 2时使用'")
  @SaturnColumn(description="可能对应的数据视图（聚集函数），当sourceType == 2时使用")
  private RuleSourceAggregateDataViewEntity sourceAggregateDataView;
  /**
   * 可能对应的groovy动态脚本，当sourceType == 3时使用
   */
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="source_script_id" , nullable=true, columnDefinition = "varchar(255) COMMENT '可能对应的groovy动态脚本，当sourceType == 3时使用'")
  @SaturnColumn(description="可能对应的groovy动态脚本，当sourceType == 3时使用")
  private RuleSourceScriptEntity sourceScript;
  /**
   * 可能对应的数据视图（集合），当sourceType == 6时使用
   */
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="source_data_view_id" , nullable=true, columnDefinition = "varchar(255) COMMENT '可能对应的数据视图（集合），当sourceType == 6时使用'")
  @SaturnColumn(description="可能对应的数据视图（集合），当sourceType == 6时使用")
  private RuleSourceDataViewEntity sourceDataView;
  /**
   * 当前项目名工程名
   */
  @ApiModelProperty("项目名")
  @Column(name="project_name", nullable = false, columnDefinition = "varchar(255) default '' comment '工程名'")
  @SaturnColumn(description = "工程名")
  private String projectName;

  public String getProjectName() {
    return projectName;
  }
  public void setProjectName(String projectName) {
    this.projectName = projectName;
  }
  public String getCode() {
    return code;
  }
  public void setCode(String code) {
    this.code = code;
  }
  public String getName() {
    return name;
  }
  public void setName(String name) {
    this.name = name;
  }
  public Integer getNodeStatus() {
    return nodeStatus;
  }
  public void setNodeStatus(Integer nodeStatus) {
    this.nodeStatus = nodeStatus;
  }
  public Set<RuleTemplateParamsEntity> getInputs() {
    return inputs;
  }
  public void setInputs(Set<RuleTemplateParamsEntity> inputs) {
    this.inputs = inputs;
  }
  public Set<RuleTemplateParamsEntity> getOutputs() {
    return outputs;
  }
  public void setOutputs(Set<RuleTemplateParamsEntity> outputs) {
    this.outputs = outputs;
  }
  public Integer getType() {
    return type;
  }
  public void setType(Integer type) {
    this.type = type;
  }
  public Integer getSourceType() {
    return sourceType;
  }
  public void setSourceType(Integer sourceType) {
    this.sourceType = sourceType;
  }
  public RuleTemplateGroupEntity getTemplateGroup() {
    return templateGroup;
  }
  public void setTemplateGroup(RuleTemplateGroupEntity templateGroup) {
    this.templateGroup = templateGroup;
  }
  public RuleSourceServicableEntity getSourceServicable() {
    return sourceServicable;
  }
  public void setSourceServicable(RuleSourceServicableEntity sourceServicable) {
    this.sourceServicable = sourceServicable;
  }
  public RuleSourceAggregateDataViewEntity getSourceAggregateDataView() {
    return sourceAggregateDataView;
  }
  public void setSourceAggregateDataView(RuleSourceAggregateDataViewEntity sourceAggregateDataView) {
    this.sourceAggregateDataView = sourceAggregateDataView;
  }
  public RuleSourceScriptEntity getSourceScript() {
    return sourceScript;
  }
  public void setSourceScript(RuleSourceScriptEntity sourceScript) {
    this.sourceScript = sourceScript;
  }
  public Boolean getFormEngine() {
    return formEngine;
  }
  public void setFormEngine(Boolean formEngine) {
    this.formEngine = formEngine;
  }
  public String getFormEngineCode() {
    return formEngineCode;
  }
  public void setFormEngineCode(String formEngineCode) {
    this.formEngineCode = formEngineCode;
  }
  public Boolean getListEngine() {
    return listEngine;
  }
  public void setListEngine(Boolean listEngine) {
    this.listEngine = listEngine;
  }
  public String getListEngineCode() {
    return listEngineCode;
  }
  public void setListEngineCode(String listEngineCode) {
    this.listEngineCode = listEngineCode;
  }
  public String getListEngineVersion() {
    return listEngineVersion;
  }
  public void setListEngineVersion(String listEngineVersion) {
    this.listEngineVersion = listEngineVersion;
  }
  public RuleSourceDataViewEntity getSourceDataView() {
    return sourceDataView;
  }
  public void setSourceDataView(RuleSourceDataViewEntity sourceDataView) {
    this.sourceDataView = sourceDataView;
  }
  public String getIconPath() {
    return iconPath;
  }
  public void setIconPath(String iconPath) {
    this.iconPath = iconPath;
  }
  public String getShowTitle() {
    return showTitle;
  }
  public void setShowTitle(String showTitle) {
    this.showTitle = showTitle;
  }
  public Integer getShowHight() {
    return showHight;
  }
  public void setShowHight(Integer showHight) {
    this.showHight = showHight;
  }
  public Integer getShowWidth() {
    return showWidth;
  }
  public void setShowWidth(Integer showWidth) {
    this.showWidth = showWidth;
  }
  public String getFormEngineVersion() {
    return formEngineVersion;
  }
  public void setFormEngineVersion(String formEngineVersion) {
    this.formEngineVersion = formEngineVersion;
  }
  public Boolean getFormEngineDefault1Version() {
    return formEngineDefault1Version;
  }
  public void setFormEngineDefault1Version(Boolean formEngineDefault1Version) {
    this.formEngineDefault1Version = formEngineDefault1Version;
  }
  public String getFormEngineVisibility() {
    return formEngineVisibility;
  }
  public void setFormEngineVisibility(String formEngineVisibility) {
    this.formEngineVisibility = formEngineVisibility;
  }
  public Integer getExtType() {
    return extType;
  }
  public void setExtType(Integer extType) {
    this.extType = extType;
  }
  public Boolean getUserPage() {
    return userPage;
  }
  public void setUserPage(Boolean userPage) {
    this.userPage = userPage;
  }
  public String getTaskName() {
    return taskName;
  }
  public void setTaskName(String taskName) {
    this.taskName = taskName;
  }
  public String getIconBgColor() {
    return iconBgColor;
  }
  public void setIconBgColor(String iconBgColor) {
    this.iconBgColor = iconBgColor;
  }
  public String getIconColor() {
    return iconColor;
  }
  public void setIconColor(String iconColor) {
    this.iconColor = iconColor;
  }
  public String getFontColor() {
    return fontColor;
  }
  public void setFontColor(String fontColor) {
    this.fontColor = fontColor;
  }
}