package com.bizunited.platform.mars.service.internal;
import com.bizunited.platform.mars.entity.RuleSourceScriptEntity;
import com.bizunited.platform.mars.repository.RuleSourceScriptEntityRepository;
import com.bizunited.platform.mars.service.RuleSourceScriptService;
import com.google.common.collect.Sets;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * RuleSourceScriptEntity业务模型的服务层接口实现
 * @author saturn
 */
@Service("RuleSourceScriptEntityServiceImpl")
public class RuleSourceScriptServiceImpl implements RuleSourceScriptService { 
  @Autowired
  private RuleSourceScriptEntityRepository ruleSourceScriptRepository;
  @Transactional
  @Override
  public RuleSourceScriptEntity create(RuleSourceScriptEntity ruleSourceScript) { 
    RuleSourceScriptEntity current = this.createForm(ruleSourceScript);
    //==================================================== 
    //    这里可以处理第三方系统调用（或特殊处理过程）
    //====================================================
    return current;
  } 
  @Transactional
  @Override
  public RuleSourceScriptEntity createForm(RuleSourceScriptEntity ruleSourceScript) { 
    this.createValidation(ruleSourceScript);
    
    // ===============================
    //  和业务有关的验证填写在这个区域    
    // ===============================
    this.ruleSourceScriptRepository.save(ruleSourceScript);
    
    // 返回最终处理的结果，里面带有详细的关联信息
    return ruleSourceScript;
  }
  /**
   * 在创建一个新的RuleSourceScriptEntity模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   */
  private void createValidation(RuleSourceScriptEntity ruleSourceScript) { 
    Validate.notNull(ruleSourceScript , "进行当前操作时，信息对象必须传入!!");
    // 判定那些不能为null的输入值：条件为 caninsert = true，且nullable = false
    Validate.isTrue(StringUtils.isBlank(ruleSourceScript.getId()), "添加信息时，当期信息的数据编号（主键）不能有值！");
    ruleSourceScript.setId(null);
  }
  @Transactional
  @Override
  public RuleSourceScriptEntity update(RuleSourceScriptEntity ruleSourceScript) { 
    RuleSourceScriptEntity current = this.updateForm(ruleSourceScript);
    //==================================================== 
    //    这里可以处理第三方系统调用（或特殊处理过程）
    //====================================================
    return current;
  } 
  @Transactional
  @Override
  public RuleSourceScriptEntity updateForm(RuleSourceScriptEntity ruleSourceScript) {     
    this.updateValidation(ruleSourceScript);
    // ===================基本信息
    String currentId = ruleSourceScript.getId();
    Optional<RuleSourceScriptEntity> op_currentRuleSourceScriptEntity = this.ruleSourceScriptRepository.findById(currentId);
    RuleSourceScriptEntity currentRuleSourceScriptEntity = op_currentRuleSourceScriptEntity.orElse(null);
    currentRuleSourceScriptEntity = Validate.notNull(currentRuleSourceScriptEntity ,"未发现指定的原始模型对象信");
    currentRuleSourceScriptEntity.setScript(ruleSourceScript.getScript());
    
    this.ruleSourceScriptRepository.saveAndFlush(currentRuleSourceScriptEntity);
    return currentRuleSourceScriptEntity;
  }
  /**
   * 在更新一个已有的RuleSourceScriptEntity模型对象之前，该私有方法检查对象各属性的正确性，其id属性必须有值
   */
  private void updateValidation(RuleSourceScriptEntity ruleSourceScript) { 
    Validate.isTrue(!StringUtils.isBlank(ruleSourceScript.getId()), "修改信息时，当期信息的数据编号（主键）必须有值！");
  } 
  @Override
  public Set<RuleSourceScriptEntity> findDetailsByScript(String script) { 
    if(StringUtils.isBlank(script)) { 
      return Sets.newHashSet();
    }
    return this.ruleSourceScriptRepository.findDetailsByScript(script);
  }
  @Override
  public RuleSourceScriptEntity findDetailsById(String id) { 
    if(StringUtils.isBlank(id)) { 
      return null;
    }
    return this.ruleSourceScriptRepository.findDetailsById(id);
  }
  @Override
  public RuleSourceScriptEntity findById(String id) { 
    if(StringUtils.isBlank(id)) { 
      return null;
    }
    
    Optional<RuleSourceScriptEntity> op = ruleSourceScriptRepository.findById(id);
    return op.orElse(null); 
  }
  @Override
  @Transactional
  public void deleteById(String id) {
    // 只有存在才进行删除，另外只删除关联信息
    Validate.notBlank(id , "进行删除时，必须给定主键信息!!");
    RuleSourceScriptEntity current = this.findById(id);
    if(current != null) { 
      this.ruleSourceScriptRepository.delete(current);
    }
  }
} 
