package com.bizunited.platform.mars.service.internal;
import com.bizunited.platform.core.annotations.NebulaServiceMethod;
import com.bizunited.platform.core.annotations.NebulaServiceMethod.ScopeType;
import com.bizunited.platform.core.annotations.ServiceMethodParam;
import com.bizunited.platform.mars.entity.RuleLockNodeEntity;
import com.bizunited.platform.mars.repository.RuleLockNodeEntityRepository;
import com.bizunited.platform.mars.service.RuleLockNodeService;

import java.lang.Override;
import java.lang.String;
import java.util.Optional;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * RuleLockNodeEntity业务模型的服务层接口实现
 * @author saturn
 */
@Service("RuleLockNodeServiceImpl")
public class RuleLockNodeServiceImpl implements RuleLockNodeService { 
  @Autowired
  private RuleLockNodeEntityRepository ruleLockNodeEntityRepository;
  @Transactional
  @Override
  public RuleLockNodeEntity create(RuleLockNodeEntity ruleLockNodeEntity) { 
    RuleLockNodeEntity current = this.createForm(ruleLockNodeEntity);
    //==================================================== 
    //    这里可以处理第三方系统调用（或特殊处理过程）
    //====================================================
    return current;
  } 
  @Transactional
  @Override
  @NebulaServiceMethod(name="RuleLockNodeEntityService.createForm" , desc="创建一个新的StudentEntity模型对象（默认不包括任何可能第三方系统调用、任何复杂逻辑处理等）" , returnPropertiesFilter="" , scope=ScopeType.WRITE)
  public RuleLockNodeEntity createForm(RuleLockNodeEntity ruleLockNodeEntity) { 
    this.createValidation(ruleLockNodeEntity);
    
    // ===============================
    //  和业务有关的验证填写在这个区域    
    // ===============================
    
    this.ruleLockNodeEntityRepository.save(ruleLockNodeEntity);
    // 返回最终处理的结果，里面带有详细的关联信息
    return ruleLockNodeEntity;
  }
  /**
   * 在创建一个新的RuleLockNodeEntity模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   */
  private void createValidation(RuleLockNodeEntity ruleLockNodeEntity) { 
    Validate.notNull(ruleLockNodeEntity , "进行当前操作时，信息对象必须传入!!");
    // 判定那些不能为null的输入值：条件为 caninsert = true，且nullable = false
    Validate.isTrue(StringUtils.isBlank(ruleLockNodeEntity.getId()), "添加信息时，当期信息的数据编号（主键）不能有值！");
    ruleLockNodeEntity.setId(null);
    Validate.notBlank(ruleLockNodeEntity.getExpression(), "添加信息时，锁表达式不能为空！");
    // 验证长度，被验证的这些字段符合特征: 字段类型为String，且不为PK （注意连续空字符串的情况） 
    Validate.isTrue(ruleLockNodeEntity.getExpression() == null || ruleLockNodeEntity.getExpression().length() < 128 , "锁表达式,在进行添加时填入值超过了限定长度(128)，请检查!");
  }
  @Transactional
  @Override
  @NebulaServiceMethod(name="RuleLockNodeEntityService.update" , desc="该方法只用于处理业务表单信息，包括了主业务模型、其下的关联模型、分组信息和明细细信息等" , returnPropertiesFilter="", scope=ScopeType.WRITE)
  public RuleLockNodeEntity update(RuleLockNodeEntity ruleLockNodeEntity) { 
    RuleLockNodeEntity current = this.updateForm(ruleLockNodeEntity);
    //==================================================== 
    //    这里可以处理第三方系统调用（或特殊处理过程）
    //====================================================
    return current;
  } 
  @Transactional
  @Override
  public RuleLockNodeEntity updateForm(RuleLockNodeEntity ruleLockNodeEntity) { 
    this.updateValidation(ruleLockNodeEntity);
    // ===================基本信息
    String currentId = ruleLockNodeEntity.getId();
    Optional<RuleLockNodeEntity> op_currentRuleLockNodeEntity = this.ruleLockNodeEntityRepository.findById(currentId);
    RuleLockNodeEntity currentRuleLockNodeEntity = op_currentRuleLockNodeEntity.orElse(null);
    currentRuleLockNodeEntity = Validate.notNull(currentRuleLockNodeEntity ,"未发现指定的原始模型对象信");
    // 开始重新赋值——一般属性
    currentRuleLockNodeEntity.setExpression(ruleLockNodeEntity.getExpression());
    
    this.ruleLockNodeEntityRepository.saveAndFlush(currentRuleLockNodeEntity);
    return currentRuleLockNodeEntity;
  }
  /**
   * 在更新一个已有的RuleLockNodeEntity模型对象之前，该私有方法检查对象各属性的正确性，其id属性必须有值
   */
  private void updateValidation(RuleLockNodeEntity ruleLockNodeEntity) { 
    Validate.isTrue(!StringUtils.isBlank(ruleLockNodeEntity.getId()), "修改信息时，当期信息的数据编号（主键）必须有值！");
    
    // 基础信息判断，基本属性，需要满足not null
    Validate.notBlank(ruleLockNodeEntity.getExpression(), "修改信息时，锁表达式不能为空！");
    // 验证长度，被验证的这些字段符合特征: 字段类型为String，且不为PK，且canupdate = true
    Validate.isTrue(ruleLockNodeEntity.getExpression() == null || ruleLockNodeEntity.getExpression().length() < 128 , "锁表达式,在进行修改时填入值超过了限定长度(128)，请检查!");
  } 
  @Override
  @NebulaServiceMethod(name="RuleLockNodeEntityService.findDetailsById" , desc="按照主键进行详情查询（包括关联信息）" , returnPropertiesFilter="" , scope=ScopeType.READ)
  public RuleLockNodeEntity findDetailsById(@ServiceMethodParam(name="id") String id) {
    if(StringUtils.isBlank(id)) { 
      return null;
    }
    return this.ruleLockNodeEntityRepository.findDetailsById(id);
  }
  @Override
  public RuleLockNodeEntity findById(String id) { 
    if(StringUtils.isBlank(id)) { 
      return null;
    }
    
    Optional<RuleLockNodeEntity> op = ruleLockNodeEntityRepository.findById(id);
    return op.orElse(null); 
  }
  @Override
  @Transactional
  public void deleteById(String id) {
    // 只有存在才进行删除
    Validate.notBlank(id , "进行删除时，必须给定主键信息!!");
    RuleLockNodeEntity current = this.findById(id);
    if(current != null) { 
      this.ruleLockNodeEntityRepository.delete(current);
    }
  }
  @Override
  @Transactional
  public void deleteByIds(String[] ids) {
    Validate.notNull(ids , "进行删除时，必须给定主键信息(支持多个)!!");
    for (String id : ids) {
      this.deleteById(id);
    }
  }
} 
