package com.bizunited.platform.mars.service.internal;

import com.bizunited.platform.mars.entity.RuleSourceAggregateDataViewEntity;
import com.bizunited.platform.mars.repository.RuleSourceAggregateDataViewEntityRepository;
import com.bizunited.platform.mars.service.RuleSourceAggregateDataViewEntityService;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * RuleSourceAggregateDataViewEntity业务模型的服务层接口实现
 * @author saturn
 */
@Service("RuleSourceAggregateDataViewEntityServiceImpl")
public class RuleSourceAggregateDataViewServiceImpl implements RuleSourceAggregateDataViewEntityService { 
  @Autowired
  private RuleSourceAggregateDataViewEntityRepository ruleSourceAggregateDataViewEntityRepository;
  @Transactional
  @Override
  public RuleSourceAggregateDataViewEntity create(RuleSourceAggregateDataViewEntity ruleSourceAggregateDataViewEntity) { 
    RuleSourceAggregateDataViewEntity current = this.createForm(ruleSourceAggregateDataViewEntity);
    //==================================================== 
    //    这里可以处理第三方系统调用（或特殊处理过程）
    //====================================================
    return current;
  } 
  @Transactional
  @Override
  public RuleSourceAggregateDataViewEntity createForm(RuleSourceAggregateDataViewEntity ruleSourceAggregateDataViewEntity) { 
    this.createValidation(ruleSourceAggregateDataViewEntity);
    
    // ===============================
    //  和业务有关的验证填写在这个区域 
    // ===============================
    this.ruleSourceAggregateDataViewEntityRepository.save(ruleSourceAggregateDataViewEntity);
    // 返回最终处理的结果，里面带有详细的关联信息
    return ruleSourceAggregateDataViewEntity;
  }
  /**
   * 在创建一个新的RuleSourceAggregateDataViewEntity模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   */
  private void createValidation(RuleSourceAggregateDataViewEntity ruleSourceAggregateDataViewEntity) { 
    Validate.notNull(ruleSourceAggregateDataViewEntity , "进行当前操作时，信息对象必须传入!!");
    // 判定那些不能为null的输入值：条件为 caninsert = true，且nullable = false
    Validate.isTrue(StringUtils.isBlank(ruleSourceAggregateDataViewEntity.getId()), "添加信息时，当期信息的数据编号（主键）不能有值！");
    ruleSourceAggregateDataViewEntity.setId(null);
    Validate.notBlank(ruleSourceAggregateDataViewEntity.getViewCode(), "添加信息时，数据视图业务编号不能为空！");
    Validate.notBlank(ruleSourceAggregateDataViewEntity.getAggregateField(), "添加信息时，聚集函数对应的视图字段不能为空！");
    Validate.notNull(ruleSourceAggregateDataViewEntity.getAggregateType(), "添加信息时，SQL集合函数类型不能为空！");
    Validate.notNull(ruleSourceAggregateDataViewEntity.getScale(), "添加信息时，小数保留尾数（默认为2）不能为空！");
    // 验证长度，被验证的这些字段符合特征: 字段类型为String，且不为PK （注意连续空字符串的情况） 
    Validate.isTrue(ruleSourceAggregateDataViewEntity.getViewCode() == null || ruleSourceAggregateDataViewEntity.getViewCode().length() < 128 , "数据视图业务编号,在进行添加时填入值超过了限定长度(128)，请检查!");
    Validate.isTrue(ruleSourceAggregateDataViewEntity.getAggregateField() == null || ruleSourceAggregateDataViewEntity.getAggregateField().length() < 256 , "聚集函数对应的视图字段,在进行添加时填入值超过了限定长度(256)，请检查!");
  }
  @Transactional
  @Override
  public RuleSourceAggregateDataViewEntity update(RuleSourceAggregateDataViewEntity ruleSourceAggregateDataViewEntity) { 
    RuleSourceAggregateDataViewEntity current = this.updateForm(ruleSourceAggregateDataViewEntity);
    //==================================================== 
    //    这里可以处理第三方系统调用（或特殊处理过程）
    //====================================================
    return current;
  } 
  @Transactional
  @Override
  public RuleSourceAggregateDataViewEntity updateForm(RuleSourceAggregateDataViewEntity ruleSourceAggregateDataViewEntity) { 
    this.updateValidation(ruleSourceAggregateDataViewEntity);
    // ===================基本信息
    String currentId = ruleSourceAggregateDataViewEntity.getId();
    Optional<RuleSourceAggregateDataViewEntity> op_currentRuleSourceAggregateDataViewEntity = this.ruleSourceAggregateDataViewEntityRepository.findById(currentId);
    RuleSourceAggregateDataViewEntity currentRuleSourceAggregateDataViewEntity = op_currentRuleSourceAggregateDataViewEntity.orElse(null);
    currentRuleSourceAggregateDataViewEntity = Validate.notNull(currentRuleSourceAggregateDataViewEntity ,"未发现指定的原始模型对象信");
    // 开始重新赋值——一般属性
    currentRuleSourceAggregateDataViewEntity.setViewCode(ruleSourceAggregateDataViewEntity.getViewCode());
    currentRuleSourceAggregateDataViewEntity.setAggregateField(ruleSourceAggregateDataViewEntity.getAggregateField());
    currentRuleSourceAggregateDataViewEntity.setAggregateType(ruleSourceAggregateDataViewEntity.getAggregateType());
    currentRuleSourceAggregateDataViewEntity.setScale(ruleSourceAggregateDataViewEntity.getScale());
    
    this.ruleSourceAggregateDataViewEntityRepository.saveAndFlush(currentRuleSourceAggregateDataViewEntity);
    return currentRuleSourceAggregateDataViewEntity;
  }
  /**
   * 在更新一个已有的RuleSourceAggregateDataViewEntity模型对象之前，该私有方法检查对象各属性的正确性，其id属性必须有值
   */
  private void updateValidation(RuleSourceAggregateDataViewEntity ruleSourceAggregateDataViewEntity) { 
    Validate.isTrue(!StringUtils.isBlank(ruleSourceAggregateDataViewEntity.getId()), "修改信息时，当期信息的数据编号（主键）必须有值！");
    
    // 基础信息判断，基本属性，需要满足not null
    Validate.notBlank(ruleSourceAggregateDataViewEntity.getViewCode(), "修改信息时，数据视图业务编号不能为空！");
    Validate.notBlank(ruleSourceAggregateDataViewEntity.getAggregateField(), "修改信息时，聚集函数对应的视图字段不能为空！");
    Validate.notNull(ruleSourceAggregateDataViewEntity.getAggregateType(), "修改信息时，SQL集合函数类型不能为空！");
    Validate.notNull(ruleSourceAggregateDataViewEntity.getScale(), "修改信息时，小数保留尾数（默认为2）不能为空！");
    
    // 验证长度，被验证的这些字段符合特征: 字段类型为String，且不为PK，且canupdate = true
    Validate.isTrue(ruleSourceAggregateDataViewEntity.getViewCode() == null || ruleSourceAggregateDataViewEntity.getViewCode().length() < 128 , "数据视图业务编号,在进行修改时填入值超过了限定长度(128)，请检查!");
    Validate.isTrue(ruleSourceAggregateDataViewEntity.getAggregateField() == null || ruleSourceAggregateDataViewEntity.getAggregateField().length() < 256 , "聚集函数对应的视图字段,在进行修改时填入值超过了限定长度(256)，请检查!");
  } 
  @Override
  public RuleSourceAggregateDataViewEntity findDetailsById(String id) { 
    if(StringUtils.isBlank(id)) { 
      return null;
    }
    return this.ruleSourceAggregateDataViewEntityRepository.findDetailsById(id);
  }
  @Override
  public RuleSourceAggregateDataViewEntity findById(String id) { 
    if(StringUtils.isBlank(id)) { 
      return null;
    }
    
    Optional<RuleSourceAggregateDataViewEntity> op = ruleSourceAggregateDataViewEntityRepository.findById(id);
    return op.orElse(null); 
  }
  @Override
  @Transactional
  public void deleteById(String id) {
    // 只有存在才进行删除
    Validate.notBlank(id , "进行删除时，必须给定主键信息!!");
    RuleSourceAggregateDataViewEntity current = this.findById(id);
    if(current != null) { 
      this.ruleSourceAggregateDataViewEntityRepository.delete(current);
    }
  }
} 
