package com.bizunited.platform.mars.repository;
import com.bizunited.platform.mars.entity.RuleSourceServicableEntity;
import java.lang.String;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * RuleSourceServicableEntity业务模型的数据库方法支持
 * @author saturn
 */
@Repository("_RuleSourceServicableEntityRepository")
public interface RuleSourceServicableEntityRepository
    extends
      JpaRepository<RuleSourceServicableEntity, String>
      ,JpaSpecificationExecutor<RuleSourceServicableEntity>
  {

  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   * */
  @Query("select distinct ruleSourceServicableEntity from RuleSourceServicableEntity ruleSourceServicableEntity "
      + " where ruleSourceServicableEntity.id=:id ")
  public RuleSourceServicableEntity findDetailsById(@Param("id") String id);

}