package com.bizunited.platform.mars.service.internal;

import com.bizunited.platform.mars.entity.RuleSourceServicableEntity;
import com.bizunited.platform.mars.repository.RuleSourceServicableEntityRepository;
import com.bizunited.platform.mars.service.RuleSourceServicableService;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;

import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * RuleSourceServicableEntity业务模型的服务层接口实现
 * @author saturn
 */
@Service("RuleSourceServicableEntityServiceImpl")
public class RuleSourceServicableServiceImpl implements RuleSourceServicableService { 
  @Autowired
  private RuleSourceServicableEntityRepository ruleSourceServicableEntityRepository;
  @Transactional
  @Override
  public RuleSourceServicableEntity create(RuleSourceServicableEntity ruleSourceServicableEntity) { 
    RuleSourceServicableEntity current = this.createForm(ruleSourceServicableEntity);
    //==================================================== 
    //    这里可以处理第三方系统调用（或特殊处理过程）
    //====================================================
    return current;
  } 
  @Transactional
  @Override
  public RuleSourceServicableEntity createForm(RuleSourceServicableEntity ruleSourceServicableEntity) { 
    this.createValidation(ruleSourceServicableEntity);
    
    // ===============================
    //  和业务有关的验证填写在这个区域    
    // ===============================
    this.ruleSourceServicableEntityRepository.save(ruleSourceServicableEntity);
    // 返回最终处理的结果，里面带有详细的关联信息
    return ruleSourceServicableEntity;
  }
  /**
   * 在创建一个新的RuleSourceServicableEntity模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   */
  private void createValidation(RuleSourceServicableEntity ruleSourceServicableEntity) { 
    Validate.notNull(ruleSourceServicableEntity , "进行当前操作时，信息对象必须传入!!");
    // 判定那些不能为null的输入值：条件为 caninsert = true，且nullable = false
    Validate.isTrue(StringUtils.isBlank(ruleSourceServicableEntity.getId()), "添加信息时，当期信息的数据编号（主键）不能有值！");
    ruleSourceServicableEntity.setId(null);
    String servicableMethod = ruleSourceServicableEntity.getServicableMethod();
    Validate.notBlank(servicableMethod, "添加信息时，完整的服务源方法名不能为空！");
    // 验证长度，被验证的这些字段符合特征: 字段类型为String，且不为PK （注意连续空字符串的情况） 
    Validate.isTrue(servicableMethod == null || servicableMethod.length() < 256 , "完整的服务源方法名,在进行添加时填入值超过了限定长度(256)，请检查!");
  }
  @Transactional
  @Override
  public RuleSourceServicableEntity update(RuleSourceServicableEntity ruleSourceServicableEntity) { 
    RuleSourceServicableEntity current = this.updateForm(ruleSourceServicableEntity);
    //==================================================== 
    //    这里可以处理第三方系统调用（或特殊处理过程）
    //====================================================
    return current;
  } 
  @Transactional
  @Override
  public RuleSourceServicableEntity updateForm(RuleSourceServicableEntity ruleSourceServicableEntity) { 
    this.updateValidation(ruleSourceServicableEntity);
    // ===================基本信息
    String currentId = ruleSourceServicableEntity.getId();
    Optional<RuleSourceServicableEntity> op_currentRuleSourceServicableEntity = this.ruleSourceServicableEntityRepository.findById(currentId);
    RuleSourceServicableEntity currentRuleSourceServicableEntity = op_currentRuleSourceServicableEntity.orElse(null);
    currentRuleSourceServicableEntity = Validate.notNull(currentRuleSourceServicableEntity ,"未发现指定的原始模型对象信");
    // 开始重新赋值——一般属性
    currentRuleSourceServicableEntity.setServicableMethod(ruleSourceServicableEntity.getServicableMethod());
    
    this.ruleSourceServicableEntityRepository.saveAndFlush(currentRuleSourceServicableEntity);
    return currentRuleSourceServicableEntity;
  }
  /**
   * 在更新一个已有的RuleSourceServicableEntity模型对象之前，该私有方法检查对象各属性的正确性，其id属性必须有值
   */
  private void updateValidation(RuleSourceServicableEntity ruleSourceServicableEntity) { 
    Validate.isTrue(!StringUtils.isBlank(ruleSourceServicableEntity.getId()), "修改信息时，当期信息的数据编号（主键）必须有值！");
    
    // 基础信息判断，基本属性，需要满足not null
    Validate.notBlank(ruleSourceServicableEntity.getServicableMethod(), "修改信息时，完整的服务源方法名不能为空！");
    // 验证长度，被验证的这些字段符合特征: 字段类型为String，且不为PK，且canupdate = true
    Validate.isTrue(ruleSourceServicableEntity.getServicableMethod() == null || ruleSourceServicableEntity.getServicableMethod().length() < 256 , "完整的服务源方法名,在进行修改时填入值超过了限定长度(256)，请检查!");
  } 
  @Override
  @Transactional
  public void deleteById(String id) {
    // 只有存在才进行删除
    Validate.notBlank(id , "进行删除时，必须给定主键信息!!");
    RuleSourceServicableEntity current = this.findById(id);
    if(current != null) { 
      this.ruleSourceServicableEntityRepository.delete(current);
    }
  }
  @Override
  public RuleSourceServicableEntity findDetailsById(String id) { 
    if(StringUtils.isBlank(id)) { 
      return null;
    }
    return this.ruleSourceServicableEntityRepository.findDetailsById(id);
  }
  @Override
  public RuleSourceServicableEntity findById(String id) { 
    if(StringUtils.isBlank(id)) { 
      return null;
    }
    
    Optional<RuleSourceServicableEntity> op = ruleSourceServicableEntityRepository.findById(id);
    return op.orElse(null); 
  }
} 
