package com.bizunited.platform.mars.entity;

import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import com.bizunited.platform.common.util.ApplicationContextUtils;
import com.bizunited.platform.core.entity.UuidOpEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 规则节点分组信息，依据不同的节点模板，将规则节点归纳到不同的分组进行显示。</br>
 * 同一组内只能有一类规则节点，同一个规则节点可以属于不同的分组
 * 详情可参见文档介绍
 * @Author yinwenjie
 * @Date  2020-06-21
 */
@Entity
@Table(name = "engine_rule_template_group")
@ApiModel(value = "RuleNodeGroupEntity" , description="规则节点模板分组信息")
@org.hibernate.annotations.Table(appliesTo = "engine_rule_template_group" , comment = "规则节点分组信息")
public class RuleTemplateGroupEntity extends UuidOpEntity {
  /**
   * 
   */
  private static final long serialVersionUID = 4810559224348086431L;
  /**
   * 模板分组编号
   */
  @ApiModelProperty(name = "code", value = "分组编号编号")
  @Column(name = "code" , length = 128 , nullable = false  , unique = true , columnDefinition = "varchar(128) COMMENT '分组编号编号'")
  @SaturnColumn(description = "分组编号编号")
  private String code;
  /**
   * 模板分组名称（中文）
   */
  @ApiModelProperty(name = "name", value = " 模板分组名称（中文）")
  @Column(name = "name" , length = 128 , nullable = false , columnDefinition = "varchar(128) COMMENT '模板分组名称（中文）'")
  @SaturnColumn(description = "模板分组名称（中文）")
  private String name;
  /**
   * 分组可用状态， 1：正常，其它值（0）不正常</br>
   * 如果分组不可用，则不会在页面上进行展示
   */
  @ApiModelProperty(name="groupStatus" , value="分组可用状态， 1：正常，其它值（0）不正常" , required=false)
  @Column(name = "c_status", nullable = false, columnDefinition = "int(11) COMMENT '分组可用状态， 1：正常，其它值（0）不正常'")
  @SaturnColumn(description="分组可用状态")
  private Integer groupStatus = 1;
  /**
   * 分组类型，只有模板节点类型与分组类型一致，才能放入到指定的分组中</br>
   * 1:判定组件、2、逻辑组件、3、锁组件，4、开始组件、5、结束组件、6、异常组件
   */
  @ApiModelProperty(name = "type", value = "分组类型")
  @Column(name = "type" , nullable = false , columnDefinition = "int(11)  COMMENT '分组类型'")
  @SaturnColumn(description = "分组类型")
  private Integer type;
  /**
   * 属于该分组的节点模板
   */
  @SaturnColumn(description = "属于该分组的节点模板")
  @ApiModelProperty("属于该分组的节点模板")
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "templateGroup")
  private Set<RuleTemplateNodeEntity> nodes;

  /**
   * 当前项目名工程名
   */
  @ApiModelProperty("项目名")
  @Column(name="project_name", nullable = false, columnDefinition = "varchar(255) default '' comment '工程名'")
  @SaturnColumn(description = "工程名")
  private String projectName = ApplicationContextUtils.getProjectName();

  public String getProjectName() {
    return projectName;
  }

  public void setProjectName(String projectName) {
    this.projectName = projectName;
  }
  public String getCode() {
    return code;
  }
  public void setCode(String code) {
    this.code = code;
  }
  public String getName() {
    return name;
  }
  public void setName(String name) {
    this.name = name;
  }
  public Integer getGroupStatus() {
    return groupStatus;
  }
  public void setGroupStatus(Integer groupStatus) {
    this.groupStatus = groupStatus;
  }
  public Integer getType() {
    return type;
  }
  public void setType(Integer type) {
    this.type = type;
  }
  public Set<RuleTemplateNodeEntity> getNodes() {
    return nodes;
  }
  public void setNodes(Set<RuleTemplateNodeEntity> nodes) {
    this.nodes = nodes;
  }
}