/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.mars.repository.internal;

import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.mars.entity.RuleTemplateNodeEntity;
import com.bizunited.platform.mars.repository.internal.RuleTemplateNodeEntityRepositoryCustom;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository(value="RuleTemplateNodeEntityRepositoryImpl")
public class RuleTemplateNodeEntityRepositoryImpl
implements RuleTemplateNodeEntityRepositoryCustom {
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private PlatformContext platformContext;

    @Override
    public List<RuleTemplateNodeEntity> findByTemplateGroupAndStatusAndType(String templateGroup, Integer nodeStatus, Integer type) {
        StringBuilder hql = new StringBuilder("select distinct et from RuleTemplateNodeEntity et left join fetch et.templateGroup tg where 1=1 ");
        StringBuilder condition = new StringBuilder();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        condition.append(" and et.projectName=:projectName ");
        parameters.put("projectName", this.platformContext.getAppName());
        if (StringUtils.isNotBlank((CharSequence)templateGroup)) {
            condition.append(" AND tg.id = :templateGroup ");
            parameters.put("templateGroup", templateGroup);
        }
        if (nodeStatus != null) {
            condition.append(" AND et.nodeStatus = :nodeStatus ");
            parameters.put("nodeStatus", nodeStatus);
        }
        if (type != null) {
            condition.append(" AND et.type = :type ");
            parameters.put("type", type);
        }
        hql.append((CharSequence)condition).append(" order by et.createTime desc  ");
        Query query = this.entityManager.createQuery(hql.toString());
        parameters.forEach((k, v) -> query.setParameter(k, v));
        return query.getResultList();
    }

    @Override
    public Page<RuleTemplateNodeEntity> findByConditions(Pageable pageable) {
        StringBuilder hql = new StringBuilder("select distinct et from RuleTemplateNodeEntity et  left join fetch et.templateGroup tg left join fetch et.sourceServicable ets  left join fetch et.sourceAggregateDataView etad  left join fetch et.sourceScript etss  left join fetch et.sourceDataView etsd  where 1=1 ");
        StringBuilder countHql = new StringBuilder("select count(*) from RuleTemplateNodeEntity et where 1 = 1 ");
        hql.append(" order by et.createTime desc ");
        Query query = this.entityManager.createQuery(hql.toString());
        Query countQuery = this.entityManager.createQuery(countHql.toString());
        query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
        query.setMaxResults(pageable.getPageSize());
        List resutls = query.getResultList();
        long count = (Long)countQuery.getResultList().get(0);
        return new PageImpl(resutls, pageable, count);
    }

    @Override
    public Page<RuleTemplateNodeEntity> findByTypesAndStatus(Pageable pageable, Set<Integer> types, Integer nodeStatus, String name, String groupCode) {
        StringBuilder hql = new StringBuilder("select distinct et from RuleTemplateNodeEntity et left join fetch et.templateGroup tg where 1=1 ");
        StringBuilder countHql = new StringBuilder("select count(*) from RuleTemplateNodeEntity et where 1=1 ");
        StringBuilder condition = new StringBuilder();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        condition.append(" AND et.projectName = :projectName ");
        parameters.put("projectName", this.platformContext.getAppName());
        if (nodeStatus != null) {
            condition.append(" AND et.nodeStatus = :nodeStatus ");
            parameters.put("nodeStatus", nodeStatus);
        }
        if (CollectionUtils.isNotEmpty(types)) {
            condition.append(" AND et.type in (:type) ");
            parameters.put("type", types);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name})) {
            condition.append(" And et.name like :name ");
            parameters.put("name", StringUtils.join((Object[])new String[]{"%", name, "%"}));
        }
        hql.append((CharSequence)condition).append(" order by et.createTime desc  ");
        countHql.append((CharSequence)condition);
        Query query = this.entityManager.createQuery(hql.toString());
        Query countQuery = this.entityManager.createQuery(countHql.toString());
        parameters.forEach((k, v) -> {
            query.setParameter(k, v);
            countQuery.setParameter(k, v);
        });
        query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
        query.setMaxResults(pageable.getPageSize());
        List resutls = query.getResultList();
        long count = (Long)countQuery.getResultList().get(0);
        return new PageImpl(resutls, pageable, count);
    }
}

