package com.bizunited.platform.mars.repository.internal;

import com.bizunited.platform.common.constant.PlatformContext;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

import com.bizunited.platform.mars.entity.RuleTemplateNodeEntity;

@Repository("RuleTemplateNodeEntityRepositoryImpl")
public class RuleTemplateNodeEntityRepositoryImpl implements RuleTemplateNodeEntityRepositoryCustom {
  @Autowired
  @PersistenceContext
  private EntityManager entityManager;
  @Autowired
  private PlatformContext platformContext;

  @SuppressWarnings("unchecked")
  @Override
  public List<RuleTemplateNodeEntity> findByTemplateGroupAndStatusAndType(String templateGroup, Integer nodeStatus, Integer type) {
    StringBuilder hql = new StringBuilder("select distinct et from RuleTemplateNodeEntity et left join fetch et.templateGroup tg where 1=1 ");
    StringBuilder condition = new StringBuilder();
    Map<String, Object> parameters = new HashMap<>();
    //筛选项目名称
    condition.append(" and et.projectName=:projectName ");
    parameters.put("projectName", platformContext.getAppName());
    // 分组信息
    if(StringUtils.isNotBlank(templateGroup)) {
      condition.append(" AND tg.id = :templateGroup ");
      parameters.put("templateGroup", templateGroup);
    }
    // 节点状态
    if(nodeStatus != null) {
      condition.append(" AND et.nodeStatus = :nodeStatus ");
      parameters.put("nodeStatus", nodeStatus);
    }
    // 节点类型 
    if(type != null) {
      condition.append(" AND et.type = :type ");
      parameters.put("type", type);
    }

    hql.append(condition).append(" order by et.createTime desc  ");
    Query query = entityManager.createQuery(hql.toString());
    parameters.forEach((k, v) -> {
      query.setParameter(k, v);
    });
    return query.getResultList();
  }

  @SuppressWarnings("unchecked")
  @Override
  public Page<RuleTemplateNodeEntity> findByConditions(Pageable pageable) {
    StringBuilder hql = new StringBuilder("select distinct et from RuleTemplateNodeEntity et "
        + " left join fetch et.templateGroup tg"
        + " left join fetch et.sourceServicable ets "
        + " left join fetch et.sourceAggregateDataView etad "
        + " left join fetch et.sourceScript etss "
        + " left join fetch et.sourceDataView etsd "
        + " where 1=1 ");
    StringBuilder countHql = new StringBuilder("select count(*) from RuleTemplateNodeEntity et where 1 = 1 ");

    // 构造HQL查询 和 数量查询
    hql.append(" order by et.createTime desc ");
    Query query = entityManager.createQuery(hql.toString());
    Query countQuery = entityManager.createQuery(countHql.toString());

    // 构造分页信息
    query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
    query.setMaxResults(pageable.getPageSize());
    List<RuleTemplateNodeEntity> resutls = query.getResultList();
    // 查询总数量信息
    long count = (long)countQuery.getResultList().get(0);
    return new PageImpl<>(resutls,pageable,count);
  }

  @SuppressWarnings("unchecked")
  @Override
  public Page<RuleTemplateNodeEntity> findByTypesAndStatus(Pageable pageable, Set<Integer> types, Integer nodeStatus, String name, String groupCode) {
    StringBuilder hql = new StringBuilder("select distinct et from RuleTemplateNodeEntity et left join fetch et.templateGroup tg where 1=1 ");
    StringBuilder countHql = new StringBuilder("select count(*) from RuleTemplateNodeEntity et where 1=1 ");
    StringBuilder condition = new StringBuilder();
    Map<String, Object> parameters = new HashMap<>();
    //筛选项目名称
    condition.append(" AND et.projectName = :projectName ");
    parameters.put("projectName", platformContext.getAppName());
    // 节点状态
    if(nodeStatus != null) {
      condition.append(" AND et.nodeStatus = :nodeStatus ");
      parameters.put("nodeStatus", nodeStatus);
    }
    // 节点类型
    if(CollectionUtils.isNotEmpty(types)) {
      condition.append(" AND et.type in (:type) ");
      parameters.put("type", types);
    }
    //节点名称
    if(StringUtils.isNoneBlank(name)){
      condition.append(" And et.name like :name ");
      parameters.put("name",StringUtils.join("%",name,"%"));
    }

    hql.append(condition).append(" order by et.createTime desc  ");
    countHql.append(condition);

    Query query = entityManager.createQuery(hql.toString());
    Query countQuery = this.entityManager.createQuery(countHql.toString());
    parameters.forEach((k, v) -> {
      query.setParameter(k, v);
      countQuery.setParameter(k, v);
    });
    // 构造分页信息
    query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
    query.setMaxResults(pageable.getPageSize());
    List<RuleTemplateNodeEntity> resutls = query.getResultList();
    // 查询总数量信息
    long count = (long)countQuery.getResultList().get(0);
    return new PageImpl<>(resutls,pageable,count);
  }
}
