/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.mars.service.internal;

import com.bizunited.platform.mars.entity.RuleNodeEntity;
import com.bizunited.platform.mars.repository.RuleNodeEntityRepository;
import com.bizunited.platform.mars.service.RuleNodeService;
import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="RuleNodeEntityServiceImpl")
public class RuleNodeServiceImpl
implements RuleNodeService {
    @Autowired
    private RuleNodeEntityRepository ruleNodeEntityRepository;

    @Override
    @Transactional
    public RuleNodeEntity create(RuleNodeEntity ruleNodeEntity) {
        RuleNodeEntity current = this.createForm(ruleNodeEntity);
        return current;
    }

    @Override
    @Transactional
    public RuleNodeEntity createForm(RuleNodeEntity ruleNodeEntity) {
        this.createValidation(ruleNodeEntity);
        this.ruleNodeEntityRepository.save((Object)ruleNodeEntity);
        return ruleNodeEntity;
    }

    private void createValidation(RuleNodeEntity ruleNodeEntity) {
        Validate.notNull((Object)((Object)ruleNodeEntity), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)ruleNodeEntity.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        ruleNodeEntity.setId(null);
        Integer type = ruleNodeEntity.getType();
        Validate.notNull((Object)type, (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8282\u70b9\u5b9a\u4e49\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (type == 2) {
            Validate.notNull((Object)ruleNodeEntity.getSourceType(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8282\u70b9\u5b9a\u4e49\u5de5\u4f5c\u903b\u8f91\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        }
    }

    @Override
    @Transactional
    public RuleNodeEntity update(RuleNodeEntity ruleNodeEntity) {
        RuleNodeEntity current = this.updateForm(ruleNodeEntity);
        return current;
    }

    @Override
    @Transactional
    public RuleNodeEntity updateForm(RuleNodeEntity ruleNodeEntity) {
        this.updateValidation(ruleNodeEntity);
        String currentId = ruleNodeEntity.getId();
        Optional op_currentRuleNodeEntity = this.ruleNodeEntityRepository.findById(currentId);
        RuleNodeEntity currentRuleNodeEntity = op_currentRuleNodeEntity.orElse(null);
        currentRuleNodeEntity = (RuleNodeEntity)((Object)Validate.notNull((Object)((Object)currentRuleNodeEntity), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]));
        currentRuleNodeEntity.setType(ruleNodeEntity.getType());
        currentRuleNodeEntity.setSourceType(ruleNodeEntity.getSourceType());
        currentRuleNodeEntity.setTemplateNode(ruleNodeEntity.getTemplateNode());
        currentRuleNodeEntity.setDefinition(ruleNodeEntity.getDefinition());
        currentRuleNodeEntity.setEdited(ruleNodeEntity.getEdited());
        this.ruleNodeEntityRepository.saveAndFlush((Object)currentRuleNodeEntity);
        return currentRuleNodeEntity;
    }

    private void updateValidation(RuleNodeEntity ruleNodeEntity) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)ruleNodeEntity.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Integer type = ruleNodeEntity.getType();
        Validate.notNull((Object)type, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u8282\u70b9\u5b9a\u4e49\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (type == 2) {
            Validate.notNull((Object)ruleNodeEntity.getSourceType(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u8282\u70b9\u5b9a\u4e49\u5de5\u4f5c\u903b\u8f91\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        }
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        RuleNodeEntity current = this.findById(id);
        if (current != null) {
            this.ruleNodeEntityRepository.delete((Object)current);
        }
    }

    @Override
    public void deleteByIds(String[] ids) {
        Validate.isTrue((ids != null && ids.length > 0 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u81f3\u5c11\u4e00\u4e2a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        this.ruleNodeEntityRepository.deleteByIds(ids);
        this.ruleNodeEntityRepository.flush();
    }

    @Override
    public Set<RuleNodeEntity> findDetailsByTemplateNode(String templateNode) {
        if (StringUtils.isBlank((CharSequence)templateNode)) {
            return Sets.newHashSet();
        }
        return this.ruleNodeEntityRepository.findDetailsByTemplateNode(templateNode);
    }

    @Override
    public Set<RuleNodeEntity> findDetailsByDefinition(String definition) {
        if (StringUtils.isBlank((CharSequence)definition)) {
            return Sets.newHashSet();
        }
        return this.ruleNodeEntityRepository.findDetailsByDefinition(definition);
    }

    @Override
    public RuleNodeEntity findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.ruleNodeEntityRepository.findDetailsById(id);
    }

    @Override
    public RuleNodeEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.ruleNodeEntityRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    public RuleNodeEntity findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return this.ruleNodeEntityRepository.findByCode(code);
    }
}

