package com.bizunited.platform.mars.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 节点模板的处理源——数据视图（集合）信息
 * @author yinwenjie
 * @since  2020-09-25
 */
@Entity
@Table(name = "engine_rule_source_dataview")
@ApiModel(value = "RuleSourceDataViewEntity" , description="节点模板的处理源——数据视图（集合）信息")
@org.hibernate.annotations.Table(appliesTo = "engine_rule_source_dataview" , comment = "节点模板的处理源——数据视图（集合）信息")
public class RuleSourceDataViewEntity extends UuidEntity {
  /**
   * 
   */
  private static final long serialVersionUID = -1478018741105342470L;
  /**
   * 数据视图业务编号
   */
  @ApiModelProperty(name = "viewCode", value = "数据视图业务编号")
  @Column(name = "view_code" , length = 128 , nullable = false , columnDefinition = "varchar(128) COMMENT '数据视图业务编号'")
  @SaturnColumn(description = "数据视图业务编号")
  private String viewCode;
  
  public String getViewCode() {
    return viewCode;
  }
  public void setViewCode(String viewCode) {
    this.viewCode = viewCode;
  }
}

