package com.bizunited.platform.mars.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 一个A/B并行分支节点定义信息
 * @author yinwenjie  
 * @since V2.2.1
 */
@Entity
@Table(name = "engine_aggregation_rule_nodes")
@ApiModel(value = "RuleConcurrentAggregationEntity" , description="一个A/B并行分支节点定义")
@org.hibernate.annotations.Table(appliesTo = "engine_aggregation_rule_nodes" , comment = "一个A/B并行分支节点定义")
public class RuleConcurrentAggregationEntity extends UuidEntity {
  /**
   * 
   */
  private static final long serialVersionUID = 1532723296280769059L;
  /**
   * 进行分流判定的上下文中参数依据。
   * 该参数只能是集合或者是数组。
   */
  @ApiModelProperty(name = "paramName", value = "进行分流判定的上下文中参数依据,该参数只能是集合或者是数组。")
  @Column(name = "paramName" , length = 64 , nullable = false , columnDefinition = "varchar(64) COMMENT '进行分流判定的上下文中参数依据'")
  @SaturnColumn(description = "进行分流判定的上下文中参数依据,该参数只能是集合或者是数组。")
  private String paramName;

  public String getParamName() {
    return paramName;
  }

  public void setParamName(String paramName) {
    this.paramName = paramName;
  }
}
